﻿var Async = false;
var isAdd = true;
var NotValidateInputs = new Array();

var reg_EMail = /^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/;
var reg_QQ = /[1-9][0-9]{4,}/;
var reg_Post = /[0-9]\d{5}(?!\d)/;
var reg_IDCard = /\d{15}|\d{18}/;
var reg_UID = /^[a-zA-Z][a-zA-Z0-9_]{4,15}$/;
var reg_CN = /[\u4e00-\u9fa5]/;
var reg_Tel = /^\d{3,4}-\d{7,8}(-\d{3,4})?$/;
//var reg_Mobile = /^((\(\d{3}\))|(\d{3}\-))?13[0-9]\d{8}|15[89]\d{8}|18[0-9]\d{8}/;
var reg_Mobile = /^(13[0-9]|15[0|1|2|3|5|6|7|8|9]|18[0|1|2|3|4|5|6|7|8|9]|147)\d{8}$/;
var reg_Number = /^-?[1-9]\d*$/;
var reg_URI = "([/w-]+/.)+[/w-]+.([^a-z])(/[/w-: ./?%&=]*)?|[a-zA-Z/-/.][/w-]+.([^a-z])(/[/w-: ./?%&=]*)?";
var reg_Decimal = /^(([0-9]+\.[0-9]*[1-9][0-9]*)|([0-9]*[1-9][0-9]*\.[0-9]+)|([0-9]*[1-9][0-9]*))$/;
var reg_Date = /((^((1[8-9]\d{2})|([2-9]\d{3}))([-\/\._])(10|12|0?[13578])([-\/\._])(3[01]|[12][0-9]|0?[1-9])$)|(^((1[8-9]\d{2})|([2-9]\d{3}))([-\/\._])(11|0?[469])([-\/\._])(30|[12][0-9]|0?[1-9])$)|(^((1[8-9]\d{2})|([2-9]\d{3}))([-\/\._])(0?2)([-\/\._])(2[0-8]|1[0-9]|0?[1-9])$)|(^([2468][048]00)([-\/\._])(0?2)([-\/\._])(29)$)|(^([3579][26]00)([-\/\._])(0?2)([-\/\._])(29)$)|(^([1][89][0][48])([-\/\._])(0?2)([-\/\._])(29)$)|(^([2-9][0-9][0][48])([-\/\._])(0?2)([-\/\._])(29)$)|(^([1][89][2468][048])([-\/\._])(0?2)([-\/\._])(29)$)|(^([2-9][0-9][2468][048])([-\/\._])(0?2)([-\/\._])(29)$)|(^([1][89][13579][26])([-\/\._])(0?2)([-\/\._])(29)$)|(^([2-9][0-9][13579][26])([-\/\._])(0?2)([-\/\._])(29)$))/;
var reg_Image = /.+\.[J|j][P|p][G|g]$|.+\.[J|j][P|p][E|e][G|g]$|.+\.[G|g][I|i][F|f]$|.+\.[P|p][N|n][G|g]$|.+\.[B|b][M|m][P|p]$/;


function CheckInputByID(id) {
    return CheckInput($("#" + id));
}

function CheckInputWithType(inputType) {
    var result = true;
    $("#subAdd").find(inputType).each(function () {
        if (!CheckInput($(this))) {
            result = false;
            return false;
        }
    });
    return result;
}

function CheckInput(cb) {
    if (typeof OnValidating != 'undefined')
        if (!OnValidating(cb))
            return false;
    var emp = cb.attr("emp"); //设置则不可为空！
    var unq = cb.attr("unq"); //设置则必须唯一
    var exp = cb.attr("exp"); //正则表达式
    var id = cb.attr("id");
    var des = cb.attr("des"); //描述
    var name = cb.attr("name");
    var errorID = cb.attr("errorID");
    var disabled = cb.attr("disabled");
    var val = cb.val();
    var err = null;

    var errMessage = '';
    if (CheckNotNull(id)) {
        if (typeof errorID == 'undefined' || errorID == null || errorID == "")
            errorID = "error" + id;
    }
    else { return true; }

    err = $("#" + errorID);

    if (CheckNull(val) && CheckNotNull(emp)) {

        errMessage = des + '不能为空';
        if (CheckNotNull(err) && CheckNotNull(des)) {
            err.html('<span class="error">' + errMessage + '</span>');
        }
        else {
            alert(errMessage);
        }
        if (!Async)
            cb.focus();
        return false;

    }

    if (CheckNotNull(val) && CheckNotNull(exp)) {
        var reg;
        if (exp.indexOf("reg_") >= 0) {
            reg = new RegExp(eval(exp));
        }
        else {
            if (exp.indexOf("Compare_") >= 0) {
                var cid = exp.replace('Compare_', '');

                if (val != $("#" + cid).val()) {
                    if (CheckNotNull(des)) {
                        errMessage = des + '不正确,两次输入不一致!';

                        if (CheckNotNull(err)) {
                            err.html('<span class="error">' + errMessage + '</span>');
                        }
                        else {
                            alert(errMessage);
                        }
                    }
                    if (!Async)
                        cb.focus();
                    return false;
                }
                if (CheckNotNull(err)) {
                    err.html('');
                    return true;
                }
            }
            else {
                reg = new RegExp(exp);
            }
        }

        if (!reg.test(val) && CheckNotNull(des)) {
            errMessage = des + '不正确.';
            if (CheckNotNull(err))
                err.html('<span class="error">' + errMessage + '</span>');
            else {
                alert(errMessage);
            }
            if (!Async)
                cb.focus();
            return false;
        }

    }

    if (CheckIsAdd(disabled) && CheckNotNull(unq)) {
        var r = CheckField(id, name, val, function (re) {
            var res = CheckUnQ(re, err, val);
            if (!res && !Async)
                cb.focus();
            return res;
        });
        var resu = CheckUnQ(r, err, val);
        if (!resu && !Async)
            cb.focus();
        return resu;

    }
    if (CheckNotNull(err)) {
        err.html('');
        return true;
    }
}

function CheckIsAdd(disabled) {
    if (isAdd && CheckNull(disabled)) {
        return true;
    }
    else
        return false;
}

function CheckUnQ(re, err, val) {
    if (re && typeof err != 'undefined') {

        var errorMessage = val + '已经存在.';

        if (CheckNotNull(err)) {
            err.html('<span class="error">' + errorMessage + '</span>');
        }
        else {
            alert(errorMessage);
        }
        return false;
    }
    else {
        if (CheckNotNull(err))
            err.html('');
        return true;
    }
}

function CheckField(id, name, value, callBack) {
    var result = false;
    var postData = "{id:'" + id + "',name:'" + name + "',value:'" + value + "'}";
    var url = vRoot + "Services/WebService.asmx/CheckField";
    $.ajax({
        url: url,
        type: "POST",
        data: postData,
        contentType: "application/json; charset=UTF-8",
        dataType: "json",
        async: Async,
        success: function (data) {
            result = data.d;
            if (Async)
                callBack(data.d);
        },
        error: function (f) {
            result = false;
        }
    });
    return result;
}

function ValidateInParent(parentID) {
    var result = true;

    $("#" + parentID).find("input").each(function () {
        var inputID = $(this).attr("id");
        if (CheckNotNull(inputID) && CheckNull(NotValidateInputs[inputID])) {
            if (!CheckInput($(this))) {
                result = false;
                return false;
            }
        }
    });
    if (!result)
        return false;
    $("#" + parentID).find("textarea").each(function () {
        var inputID = $(this).attr("id");
        if (CheckNotNull(inputID) && CheckNull(NotValidateInputs[inputID])) {
            if (!CheckInput($(this))) {
                result = false;
                return false;
            }
        }
    });
    if (!result)
        return false;
    $("#" + parentID).find("select").each(function () {
        var inputID = $(this).attr("id");
        if (CheckNotNull(inputID) && CheckNull(NotValidateInputs[inputID])) {
            if (!CheckInput($(this))) {
                result = false;
                return false;
            }
        }
    });
    return result;
}