Element.implement({
	mooZoom: function(options){
		var settings = {
			xzoom: 300,
			yzoom: 300,
			offset: 20,
			position: "right",
			lens: 1,
			count: 0,
			preload: 1		
		};
		if(options) $extend(settings , options);
		var noalt = '';
		this.addEvent('mouseenter', function(){
			var imageLeft = this.offsetLeft;
			var imageRight = this.offsetRight;
			var imageTop = this.offsetTop;
			var imageWidth = this.getChildren('img')[0].offsetWidth;
			var imageHeight = this.getChildren('img')[0].offsetHeight;
			noalt = this.getChildren("img").get("alt");
			var bigimage = this.getChildren("img").get("jqimg");
			this.getChildren("img").set("alt", '');
			if (!$E("div.zoomdiv")) {
			    new Element("div",{"class":"zoomdiv"}).setHTML("<img class='bigimg' src='" + bigimage + "' />").inject(this,"after");
				this.grab(new Element("div",{"class":"jqZoomPup"}).setHTML(""));
			}
			if (settings.position == "right") {
				if (imageLeft + imageWidth + settings.offset + settings.xzoom > screen.width) {
					leftpos = imageLeft - settings.offset - settings.xzoom;
				} else {
					leftpos = imageLeft + imageWidth + settings.offset;
				}
			} else {
				leftpos = imageLeft - settings.xzoom - settings.offset;
				if (leftpos < 0) {
					leftpos = imageLeft + imageWidth + settings.offset;
				}
			}
			$E("div.zoomdiv").setStyles({
				top: imageTop,
				left: leftpos
			});
			
			$E("div.zoomdiv").setStyle("width",settings.xzoom);
			$E("div.zoomdiv").setStyle("height",settings.yzoom);
			$E("div.zoomdiv").setStyle("display","block");
			if (!settings.lens) {
				this.setStyle('cursor', 'crosshair');
			}
			
			this.addEvent("mousemove",function(e) {
			    
				mouse = new MouseEvent(e);
				var bigwidth = $E(".bigimg").offsetWidth;
				var bigheight = $E(".bigimg").offsetHeight;
				var scaley = 'x';
				var scalex = 'y';
				if (isNaN(scalex) | isNaN(scaley)) {
					var scalex = (bigwidth / imageWidth);
					var scaley = (bigheight / imageHeight);
					//$E("div.jqZoomPup").setStyle("width",(settings.xzoom) / scalex );
					//$E("div.jqZoomPup").setStyle("height",(settings.yzoom) / scaley );
					
					if (settings.lens) {
						$E("div.jqZoomPup").setStyle('visibility', 'visible');
					}
				}
				xpos = mouse.x - $E("div.jqZoomPup").getSize().x / 2 - imageLeft;
				ypos = mouse.y - $E("div.jqZoomPup").getSize().y / 2 - imageTop;
				if (settings.lens) {
					xpos = (mouse.x - $E("div.jqZoomPup").getSize().x / 2 < imageLeft) ? 0 : (mouse.x + $E("div.jqZoomPup").getSize().x / 2 > imageWidth + imageLeft) ? (imageWidth - $E("div.jqZoomPup").getSize().x - 2) : xpos;
					ypos = (mouse.y - $E("div.jqZoomPup").getSize().y / 2 < imageTop) ? 0 : (mouse.y + $E("div.jqZoomPup").getSize().y / 2 > imageHeight + imageTop) ? (imageHeight - $E("div.jqZoomPup").getSize().y - 2) : ypos;
				}
				
				if (settings.lens) {
					$E("div.jqZoomPup").setStyles({
						top: ypos,
						left: xpos
					});
				}
				scrolly = ypos;
				$E("div.zoomdiv").scrollTop = scrolly * scaley;
				scrollx = xpos;
				$E("div.zoomdiv").scrollLeft = (scrollx) * scalex;
			});			
		}).addEvent("mouseleave",function(){
			this.getChildren("img").set("alt", noalt);
			this.removeEvents("mousemove");
			if (settings.lens) {
			    if($E("div.jqZoomPup"))
				    $E("div.jqZoomPup").dispose();
			}
			if($E("div.zoomdiv")) $E("div.zoomdiv").dispose();
		});
		
		count = settings.count;
		if (settings.preload) {
			$E('body').grab(new Element("div",{"style":"display:none;","class":"jqPreload" + count}).setHTML("demo"));
			var imagetopreload = this.getChildren("img").get("jqimg");
			var content = $E('div.jqPreload' + count + '').getHTML();
			$E('div.jqPreload' + count + '').setHTML(content + '<img src=\"' + imagetopreload + '\">');
		}
	} 
});

function MouseEvent(e) {
    this.x = e.page.x
    this.y = e.page.y

}