# 添加页面

添加页面需要添加页面相关的Vue组件与相对应的路由配置

## 添加Vue组件

* 在**src/views**文件夹下创建页面对应的文件夹以及对应的页面组件文件

## 添加路由配置
### 自动添加路由配置
:point_right: [devtools 2.1.x 自动化生成您的前端页面](/guide/diboot-devtools/介绍)
:::tip
devtools 2.1.x为您提供了前端页面和后端接口的快速构建，赶快点击体验吧！！！
:::

### 手动添加路由配置
* 后台菜单是根据路由配置自动生成的，具体可参考[路由与菜单](https://pro.antdv.com/docs/router-and-nav)
* 在**src/config/router.config.js**文件中，可以配置需要新增页面的路由。
* 对于需要进行权限控制的菜单，~~需要放到asyncRouterMap中进行配置~~，其他不需要进行权限控制或所有人可用的菜单，可以放到constantRouterMap中。
> 2.1.x版本之后devtools具有前端生成能力，因此手动添加路由不建议直接放在asyncRoutes路由中，而是交给**generateRouterMap**处理，由devtools生成的路由会自动写入generateRouterMap集合

```javascript
export const asyncRouterMap = []
// 在router.config.js 末尾添加如下内容
const generateRouterMap = []
asyncRouterMap[0].children.splice(1, 0, ...generateRouterMap)
````
* 手动路由配置方式，可参考已有配置，如下：

```javascript
// 系统管理
{
  path: '/system',
  redirect: '/system/dictionary/list',
  component: PageView,
  meta: { title: '系统管理', icon: 'dashboard' },
  children: [
    {
      path: '/system/dictionary/list',
      name: 'DictList',
      component: () => import('@/views/system/dictionary/list'),
      meta: { title: '数据字典管理', keepAlive: true, permission: ['Dictionary'] }
    },
    {
      path: '/system/iamUser/list',
      name: 'IamUserList',
      component: () => import('@/views/system/iamUser/list'),
      meta: { title: '系统用户管理', keepAlive: true, permission: ['IamUser'] }
    },
    {
      path: '/system/iamRole/list',
      name: 'IamRoleList',
      component: () => import('@/views/system/iamRole/list'),
      meta: { title: '角色权限管理', keepAlive: true, permission: ['IamRole'] }
    },
    {
      path: '/system/iamFrontendPermission/list',
      name: 'IamFrontendPermission',
      component: () => import('@/views/system/iamFrontendPermission/list'),
      meta: { title: '菜单权限管理', keepAlive: true, permission: ['IamFrontendPermission'] }
    },
    {
      path: '/system/iamLoginTrace/list',
      name: 'IamLoginTraceList',
      component: () => import('@/views/system/iamLoginTrace/list'),
      meta: { title: '登录日志查看', keepAlive: true, permission: ['IamLoginTrace'] }
    }
  ]
}
```

* keepAlive：设置为true，将会在重新进入该页面时保持之前的数据，如果设置为false，则会重新加载数据；
* permission：为显示该菜单所需要该用户具有的权限码，这个码会在稍后配置系统权限的时候自动代入。
* 如果不配置permission，将不会对该菜单进行权限验证，所有用户都可以访问该页面，如果permission的列表中配置了多个权限码，那么具有其中一个就将会具有当前菜单的访问权限。
* 配置完成后，就可以对这些页面进行访问了（如果配置了权限码，可以先使用具有管理员权限的账号访问到）。
