# 常用工具类

## BeanUtils(Bean)

* copyProperties 对象拷贝
```java
//方法调用示例
Object obj = BeanUtils.copyProperties(source, target);
```
该方法用来复制source对象的值到另一个target对象。其在Spring的copyProperties之外扩展支持了@Accept注解指定的非同名字段拷贝，注解定义示例。 
```java
// 指定接收来自源对象的genderLabel属性值
@Accept(name = "genderLabel")
private String gender;
```

* convert 类型转换
```java
//方法定义
public static <T> T convert(Object source, Class<T> clazz){...}
//方法调用示例
Organization org = BeanUtils.convert(source, Organization.class);
```
该方法用来将一个对象转换为另外的对象实例，入参为被转化对象（source）、目标对象的类类型（clazz）。

* convertList 集合中的类型转换
```java
//方法定义
public static <T> List<T> convertList(List sourceList, Class<T> clazz){...}
//方法调用示例
List<Organization> orgList = BeanUtils.convertList(sourceList, Organization.class);
```
该方法用来将对象集合转换为另外的对象集合实例，入参为被转化对象集合（sourceList）、目标对象的类类型（clazz）。

* bindProperties 绑定map属性到对象
```java
//方法定义
public static void bindProperties(Object model, Map<String, Object> propMap){...}
//方法调用示例
BeanUtils.bindProperties(model, propMap);
```
该方法用来绑定Map中的属性值到Model，入参为被绑定对象（model）、属性值Map（propMap）。

* getProperty 获取属性值
```java
//方法定义
public static Object getProperty(Object obj, String field){...}
//方法调用示例
Object obj = BeanUtils.getProperty(obj, field);
```
该方法用来获取对象的属性值，入参为目标对象（obj）、对象字段名（field）。

* getStringProperty 获取属性值并转为String
```java
//方法定义
public static String getStringProperty(Object obj, String field){...}
//方法调用示例
String str = BeanUtils.getStringProperty(obj, field);
```
该方法用来获取对象的属性值并转换为字符串类型，入参为目标对象（obj）、字段名（field）。

* setProperty 设置属性值
```java
//方法定义
public static void setProperty(Object obj, String field, Object value){...}
//方法调用示例
BeanUtils.setProperty(obj, field, value);
```
该方法用来设置对象属性值，入参为目标对象（obj）、字段名（field）、字段值（value）。

* convertToStringKeyObjectMap 转换集合为Key-Object的map，key为指定字段值
```java
//方法定义
public static <T> Map<String, T> convertToStringKeyObjectMap(List<T> allLists, String... fields){...}
//方法调用示例
Map map = BeanUtils.convertToStringKeyObjectMap(allLists, fields);
```
该方法用来将对象集合转化成键值对为String-Object的Map形式，入参为目标对象集合（allLists）、字段名（fields）。

* convertToStringKeyObjectListMap 转换集合为Key-Object的map，key为指定字段值的String
```java
//方法定义
public static <T> Map<String, List<T>> convertToStringKeyObjectListMap(List<T> allLists, String... fields){...}
//方法调用示例
Map map = BeanUtils.convertToStringKeyObjectListMap(allLists, fields);
```
该方法用来将对象集合转化成键值对为String-List的Map形式，入参为目标对象集合（allLists）、字段名（fields）。

* buildTree 构建树形结构
```java
//该方法用来构建支持无限层级的树形结构，默认顶层父级节点的parentId=0，入参为对象集合（allNodes）
//方法定义
public static <T> List<T> buildTree(List<T> allNodes){...}
//方法调用示例
List<Menu> menuTree = BeanUtils.buildTree(allNodes);

//该方法用来构建支持无限层级的树形结构，指定顶层父级节点的parentId，入参为（allNodes, rootNodeId）
//方法定义
public static <T> List<T> buildTree(List<T> allNodes, Object rootNodeId){...}
//方法调用示例
List<Menu> menuTree = BeanUtils.buildTree(allNodes, 1L);

//该方法用来构建支持无限层级的树形结构，指定顶层父级节点的parentId及上级属性名、赋值属性名
//方法定义
public static <T> List<T> buildTree(List<T> allNodes, Object rootNodeId, String parentIdFieldName, String childrenFieldName){...}
//方法调用示例
List<Menu> menuTree = BeanUtils.buildTree(list, 0, "parentId", "children");
```

* extractDiff 提取对象值变化
```java
//该方法用来提取两个model的差异值，入参为两个实体对象oldModel、newModel
//方法定义
public static String extractDiff(BaseEntity oldModel, BaseEntity newModel){...}
//方法调用示例
String str = BeanUtils.extractDiff(oldModel, newModel);

//该方法用来提取两个model的差异值，只对比指定字段，入参为两个实体对象oldModel、newModel,以及指定字段fields
//方法定义
public static String extractDiff(BaseEntity oldModel, BaseEntity newModel, Set<String> fields){...}
//方法调用示例
String str = BeanUtils.extractDiff(oldModel, newModel, fields);
```

* collectToList 收集某字段值到集合
```java
//该方法用来从集合列表中提取指定属性值到新的集合，入参为对象集合（objectList）、IGetter对象（getterFn）
//方法定义
public static <E,T> List collectToList(List<E> objectList, IGetter<T> getterFn){...}
//方法调用示例
List list = BeanUtils.collectToList(objectList, getterFn);

//该方法用来从集合列表中提取指定属性值到新的集合，入参为对象集合（objectList）、字段名（getterPropName）
//方法定义
public static <E> List collectToList(List<E> objectList, String getterPropName){...}
//方法调用示例
List list = BeanUtils.collectToList(objectList, getterPropName);
```

* collectIdToList 收集id字段值到集合
```java
//方法定义
public static <E> List collectIdToList(List<E> objectList){...}
//方法调用示例
List list = BeanUtils.collectIdToList(objectList);
```
该方法用来从集合列表中提取Id主键值到新的集合，入参为对象集合（objectList）。

* convertToFieldName 获取属性名
```java
//该方法用来转换方法引用为属性名，入参为IGetter对象。
//方法定义
public static <T> String convertToFieldName(IGetter<T> fn){...}
//方法调用示例
String str = BeanUtils.convertToFieldName(fn);

//该方法用来转换方法引用为属性名，入参为ISetter对象。
//方法定义
public static <T,R> String convertToFieldName(ISetter<T,R> fn){...}
//方法调用示例
String str = BeanUtils.convertToFieldName(fn);
```

* extract*Fields 提取Field（包含父类中）
```java
// 提取所有Field
List<Field> list = BeanUtils.extractAllFields(Organization.class);
// 提取指定注解的Field
List<Field> list = BeanUtils.extractFields(Organization.class, MyAnnotation.class);
// 提取指定属性名的Field
Field field = extractField(Organization.class, "name");
```

* cloneBean 克隆对象
```java
//方法调用
User user2 = BeanUtils.cloneBean(user1);
```

* distinctByKey 基于某字段值去重
```java
//方法调用
List<Dictionary> list = BeanUtils.distinctByKey(dictionaryList, Dictionary::getId);
```

## ContextHelper(Spring上下文)

* getApplicationContext 方法
```java
//方法定义
public static ApplicationContext getApplicationContext(){...}
//方法调用示例
ApplicationContext context = ContextHelper.getApplicationContext();
```
该方法用来获取ApplicationContext上下文。

* getBean 方法
```java
//该方法用来根据beanId获取Bean实例，入参为beanId
//方法定义
public static Object getBean(String beanId){...}
//方法调用示例
Object obj = ContextHelper.getBean(beanId);

//该方法用来获取指定类型的单个Bean实例，入参为类类型（type）
//方法定义
public static Object getBean(Class type){...}
//方法调用示例
OrganizationService service = ContextHelper.getBean(OrganizationService.class);
```

* getBeans 方法
```java
//方法定义
public static <T> List<T> getBeans(Class<T> type){...}
//方法调用示例
List<OrganizationService> orgServiceList = ContextHelper.getBeans(OrganizationService.class);
```
该方法用来获取指定类型的全部实例，入参为类类型（type）。

* getBeansByAnnotation 方法
```java
//方法定义
public static List<Object> getBeansByAnnotation(Class<? extends Annotation> annotationType){...}
// 同Spring 的 getBeansWithAnnotation
```
该方法用来根据注解获取beans，入参为类类型（annotationType）。

* getServiceByEntity 方法
```java
//方法定义
public static IService getServiceByEntity(Class entity){...}
//方法调用示例
IService service = ContextHelper.getServiceByEntity(Organization.class);
List list = service.list();
```
该方法用来根据Entity获取对应的Service，入参为类类型（entity）。

## D(日期时间)

* 日期、时间、星期格式常量
```java
public static final String FORMAT_DATE_y2M = "yyMM";                        //例：1908  				  表示 19年8月
public static final String FORMAT_DATE_y2Md = "yyMMdd";					   //例：190816  			  表示 19年8月16日
public static final String FORMAT_DATE_y4 = "yyyy";   					   //例：2019  				  表示 2019年
public static final String FORMAT_DATE_y4Md = "yyyyMMdd";				   //例：20190816  			  表示 2019年8月16日
public static final String FORMAT_DATE_Y4MD = "yyyy-MM-dd";				   //例：2019-08-16  		  表示 2019年8月16日
public static final String FORMAT_TIMESTAMP = "yyMMddhhmmss";			   //例：190816121212  		  表示 19年8月16日12时12分12秒
public static final String FORMAT_TIME_HHmm = "HH:mm";					   //例：12:30  			      表示 12点30分
public static final String FORMAT_TIME_HHmmss = "HH:mm:ss";				   //例：12:30:30  			  表示 12点30分30秒
public static final String FORMAT_DATETIME_Y4MDHM = "yyyy-MM-dd HH:mm";	   //例：2019-08-16 12:30  	  表示 2019年8月16日 12点30分
public static final String FORMAT_DATETIME_Y4MDHMS = "yyyy-MM-dd HH:mm:ss";//例：2019-08-16 12:30:30  表示 2019年8月16日 12点30分30秒
public static final String[] WEEK = new String[]{"星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"};
```
格式常量表示某种日期时间格式的一个字符串类型的常量，D类中已经内置了如下列表所示的格式常量，
可以通过类似D.FORMAT_DATE_y2M这样的调用来获取这些常量的内容。

* now 方法
```java
//方法定义
public static String now(String format){...}
//方法调用示例
String nowDateStr = D.now("yyyy-MM-dd");
log.debug(nowDateStr);
//执行结果
===> 2019-08-20
```
该方法用来获取当前的日期时间的字符串形式，入参为日期匹配格式（format）。

* toTimestamp 方法
```java
//方法定义
public static String toTimestamp(Date date){...}
//方法调用示例
String dateStr = D.toTimestamp(date);
log.debug(dateStr);
//执行结果
===> 190820094202
```
该方法用来获取当前日期时间的时间戳形式，入参为日期（date）。

* getMonth 方法
```java
//方法定义
public static String getMonth(){...}
//方法调用示例
String monthStr = D.getMonth();
log.debug(monthStr);
//执行结果
===> 1908
```
该方法用来获取当前月份。

* today 方法
```java
//方法定义
public static String today(){...}
//方法调用示例
String todayStr = D.today();
log.debug(todayStr);
//执行结果
===> 20190820
```
该方法用来获取今天的日期。

* convert2FormatDate 方法
```java
//方法定义
public static Date convert2FormatDate(String datetime, String fmt){...}
//方法调用示例
Date date = D.convert2FormatDate("2019-08-20", "yyyy-MM-dd");
log.debug(date);
//执行结果
===> Tue Aug 20 00:00:00 CST 2019
```
该方法用来转换日期字符串为日期类型，入参为日期字符串（datetime）、日期匹配格式（fmt）。

* convert2FormatString 方法
```java
//方法定义
public static String convert2FormatString(Date date, String fmt){...}
//方法调用示例
String dateStr = D.convert2FormatString(new Date(), "yyyy-MM-dd");
log.debug(dateStr);
//执行结果
===> 2019-08-20
```
该方法用来转换日期为格式化字符串，入参为日期（date）、日期匹配格式（fmt）。

* getDate 方法
```java
//方法定义
public static String getDate(Date date, int... daysOffset){...}
//方法调用示例
String dateStr = D.getDate(new Date(), 0);
log.debug(dateStr);
//执行结果
===> 2019-08-20
```
该方法用来获取格式化的日期，入参为日期（date）、日期偏移量（daysOffset）。

* getDateTime 方法
```java
//方法定义
public static String getDateTime(Date date, int... daysOffset){...}
//方法调用示例
String dateTimeStr = D.getDateTime(new Date(), 0);
log.debug(dateTimeStr);
//执行结果
===> 2019-08-20 09:53
```
该方法用来获取格式化的日期时间，入参为日期（date）、日期偏移量（daysOffset）。

* isWorkingTime 方法
```java
//方法定义
public static boolean isWorkingTime(){...}
//方法调用示例
boolean isWorkingTime = D.isWorkingTime();
log.debug(isWorkingTime);
//执行结果
===> true
```
该方法用来判断是否是工作时间段，用于后台程序等。

* getAmPm 方法
```java
//方法定义
public static String getAmPm(){...}
//方法调用示例
String timeStr = D.getAmPm();
log.debug(timeStr);
//执行结果
===> 早上
```
该方法用来获取现在时间是早上/上午/中午/下午/晚上。

* getYearMonth 方法
```java
//方法定义
public static String getYearMonth(){...}
//方法调用示例
String yearMonthStr = D.getYearMonth();
log.debug(yearMonthStr);
//执行结果
===> 1908
```
该方法用来得到当前的年月YYMM，用于生成文件夹名称。

* getYearMonthDay 方法
```java
//方法定义
public static String getYearMonthDay(){...}
//方法调用示例
String yearMonthDayStr = D.getYearMonthDay();
log.debug(yearMonthDayStr);
//执行结果
===> 190820
```
该方法用来得到当前的年月日YYMMDD，用于生成文件夹名称。

* getDay 方法
```java
//方法定义
public static int getDay(){...}
//方法调用示例
int day = D.getDay();
log.debug(day);
//执行结果
===> 20
```
该方法用来得到当前日期为多少号。

* getWeek 方法
```java
//方法定义
public static String getWeek(Date date){...}
//方法调用示例
String week = D.getWeek(new Date());
log.debug(week);
//执行结果
===> 星期三
```
该方法用来得到当前日期为星期几，入参为日期（date）。

* timeMillis2Date 方法
```java
//方法定义
public static Date timeMillis2Date(Long timeMillis){...}
//方法调用示例
Date date = D.timeMillis2Date(System.currentTimeMillis());
log.debug(date);
//执行结果
===> Tue Aug 20 10:06:12 CST 2019
```
该方法用来毫秒数转日期，入参为时间毫秒数（timeMillis）。

* datetimeString2Date 方法
```java
//方法定义
public static Date datetimeString2Date(String value){...}
//方法调用示例
Date date = D.datetimeString2Date("2019-08-20 10:11:20");
log.debug(date);
//执行结果
===> Tue Aug 20 10:11:20 CST 2019
```
该方法用来字符串时间戳转日期，入参为时间字符串（value）。

* convert2Date 方法
```java
//方法定义
public static Date convert2Date(String date){...}
//方法调用示例
Date date = D.convert2Date("2019-08-20");
log.debug(date);
//执行结果
===> Tue Aug 20 00:00:00 CST 2019
```
该方法用来字符串时间戳转日期，入参为日期字符串（date）。

* convert2DateTime 方法
```java
//方法定义
public static Date convert2DateTime(String dateTime, String... dateFormat){...}
//方法调用示例
Date date = D.convert2DateTime("2019-08-20 10:14:20", "yyyy-MM-dd HH:mm:ss");
log.debug(date);
//执行结果
===> Tue Aug 20 10:14:20 CST 2019
```
该方法用来字符串时间戳转日期，入参为时间字符串（dateTime）、时间匹配格式（dateFormat）。

* fuzzyConvert 方法
```java
//方法定义
public static Date fuzzyConvert(String dateString){...}
//方法调用示例
Date date = D.fuzzyConvert("2019-08-20 10:14:20");
log.debug(date);
//执行结果
===> Tue Aug 20 10:14:20 CST 2019
```
该方法用来模糊转换日期，入参为时间字符串（dateString）。

## Encryptor(加解密)

* encrypt 方法
```java
//方法定义
public static String encrypt(String input, String... key){...}
//方法调用示例
String encryptStr = Encryptor.encrypt("123456", "admin");
log.debug(encryptStr);
//执行结果
===> ZVmTuAFJIjD5PLwkURuvRw==
```
该方法用来加密字符串（可指定加密密钥），入参为需加密字符串（input）、加密秘钥（key）。

* decrypt 方法
```java
//方法定义
public static String decrypt(String input, String... key){...}
//方法调用示例
String decryptStr = Encryptor.decrypt("ZVmTuAFJIjD5PLwkURuvRw==", "admin");
log.debug(decryptStr);
//执行结果
===> 123456
```
该方法用来解密字符串，入参为需解密字符串（input）、解密秘钥（key）。

## JSON (扩展自fastjson)

* stringify 方法
```java
//方法定义
public static String stringify(Object object){...}
//方法调用示例
String str = JSON.stringify(new Dictionary());
log.debug(str);
//执行结果
===> {"editable":false,"parentId":0,"sortId":99,"system":true}
```
该方法用来将Java对象转换为Json字符串，入参为对象（object）。

* toMap 方法
```java
//方法定义
public static Map toMap(String jsonStr){...}
//方法调用示例
Map map = JSON.toMap("{"editable":false,"parentId":0,"sortId":99,"system":true}");
log.debug(map);
//执行结果
===> {"system":true,"editable":false,"sortId":99,"parentId":0}
```
该方法用来将JSON字符串转换为Map对象，入参为JSON字符串（jsonStr）。

* toLinkedHashMap 方法
```java
//方法定义
public static LinkedHashMap toLinkedHashMap(String jsonStr){...}
//方法调用示例
LinkedHashMap linkedMap = JSON.toLinkedHashMap("{"editable":false,"parentId":0,"sortId":99,"system":true}");
log.debug(linkedMap);
//执行结果
===> {editable=false, parentId=0, sortId=99, system=true}
```
该方法用来将JSON字符串转换为LinkedHashMap对象，入参为JSON字符串（jsonStr）。

* toJavaObject 方法
```java
//方法定义
public static <T> T toJavaObject(String jsonStr, Class<T> clazz){...}
//方法调用示例
Dictionary dictionary = JSON.toJavaObject("{"editable":false,"parentId":0,"sortId":99,"system":true}", Dictionary.class );
System.out.pringtln(dictionary.getSystem());
//执行结果
===> true
```
该方法用来将JSON字符串转换为java对象，入参为JSON字符串（jsonStr）、类类型（clazz）。

## PropertiesUtils(配置文件)

* get 方法
```java
//方法定义
public static String get(String key, String... propertiesFileName){...}
//方法调用示例
String portStr = PropertiesUtils.get("database.port","system.properties");
log.debug(portStr);
//执行结果
===> 3306
```
该方法用来读取配置项的值，入参为配置字段名（key）、配置文件名（propertiesFileName）。

* getInteger 方法
```java
//方法定义
public static Integer getInteger(String key, String... propertiesFileName){...}
//方法调用示例
Integer portInt = PropertiesUtils.getInteger("database.port","system.properties");
log.debug(portInt);
//执行结果
===> 3306
```
该方法用来读取int型的配置项，入参为配置字段名（key）、配置文件名（propertiesFileName）。

* getBoolean 方法
```java
//方法定义
public static boolean getBoolean(String key, String... propertiesFileName){...}
//方法调用示例
boolean isOpen = PropertiesUtils.getBoolean("database.open","system.properties");
log.debug(isOpen);
//执行结果
===> true
```
该方法用来读取boolean型的配置项，入参为配置字段名（key）、配置文件名（propertiesFileName）。

## S(字符串)

* cut 方法
```java
//该方法用来裁剪字符串，入参为字符串（input）
//方法定义
public static String cut(String input){...}
//方法调用示例
String cutStr = S.cut("ABCDE");
log.debug(cutStr);
//执行结果
===> ABCDE

//该方法用来裁剪字符串，入参为字符串（input）、裁剪长度（cutLength）
//方法定义
public static String cut(String input, int cutLength){...}
//方法调用示例
String cutStr = S.cut("ABCDE", 1);
log.debug(cutStr);
//执行结果
===> A
```

* join 方法
```java
//该方法用来将集合拼接成字符串，默认分隔符为：“，”，入参为字符串集合（stringList）
//方法定义
public static String join(List<String> stringList){...}
//方法调用示例
String joinStr = S.join(new ArrayList<String>(){{add("A");add("B");add("C");}});
log.debug(joinStr);
//执行结果
===> A,B,C

//该方法用来将数组拼接成字符串，默认分隔符为：“，”，入参为字符串数组（stringArray）
//方法定义
public static String join(String[] stringArray){...}
//方法调用示例
String joinStr = S.join(new String[]{"A","B","C"});
log.debug(joinStr);
//执行结果
===> A,B,C
```

* split 方法
```java
//方法定义
public static String[] split(String joinedStr){...}
//方法调用示例
String[] strArray = S.split("A,B,C");
log.debug(strArray[0]);
//执行结果
===> A
```
该方法用来按“，”拆分字符串，入参为字符串（joinedStr）。

* toStringArray 方法
```java
//方法定义
public static String[] toStringArray(List<String> stringList){...}
//方法调用示例
String[] strArray = S.toStringArray(stringList);
```
该方法用来转换为String数组，入参为字符串集合（stringList）。

* toSnakeCase 方法
```java
//方法定义
public static String toSnakeCase(String camelCaseStr){...}
//方法调用示例
String userName = S.toSnakeCase("userName");
log.debug(userName);
//执行结果
===> user_name
```
该方法用来转换成蛇形命名（用于Java属性转换为数据库列名），入参为字符串（camelCaseStr）。

* toLowerCaseCamel 方法
```java
//方法定义
public static String toLowerCaseCamel(String snakeCaseStr){...}
//方法调用示例
String userName = S.toLowerCaseCamel("user_name");
log.debug(userName);
//执行结果
===> userName
```
该方法用来转换成首字母小写的驼峰命名（用于数据库列名转换为Java属性），入参为字符串（snakeCaseStr）。

* toLong 方法
```java
//方法定义
public static Long toLong(String strValue){...}
//方法调用示例
Long longValue = S.toLong("1");
```
该方法用来转换为Long类型，入参为字符串（strValue）。

* toInt 方法
```java
//方法定义
public static Integer toInt(String strValue){...}
//方法调用示例
Integer intValue = S.toInt("1");
```
该方法用来转换为Integer类型，入参为字符串（strValue）。

* toBoolean 方法
```java
//方法定义
public static boolean toBoolean(String strValue){...}
//方法调用示例
boolean isTrue = S.toBoolean("1");
log.debug(isTrue);
//执行结果
===> true
```
该方法用来转换为boolean类型，入参为字符串（strValue）。

* removeDuplicateBlank 方法
```java
//方法定义
public static String removeDuplicateBlank(String input){...}
//方法调用示例
String str = S.removeDuplicateBlank("A     B");
log.debug(str);
//执行结果
===> A B
```
该方法用来将多个空格替换为一个，入参为字符串（input）。

* newUuid 方法
```java
//方法定义
public static String newUuid(){...}
//方法调用示例
String uuid = S.newUuid();
log.debug(uuid);
//执行结果
===> c8b735798cfe4e0ba897a460d6107b8a
```
该方法用来获得随机串。

* newRandomNum 方法
```java
//方法定义
public static String newRandomNum(int length){...}
//方法调用示例
String randomNum = S.newRandomNum(6);
log.debug(randomNum);
//执行结果
===> 513987
```
该方法用来生成指定位数的数字/验证码，入参为指定字符长度（length）。

* uncapFirst 方法
```java
//方法定义
public static String uncapFirst(String input){...}
//方法调用示例
String str = S.uncapFirst("ABC");
log.debug(str);
//执行结果
===> aBC
```
该方法用来将首字母转为小写，入参为字符串（input）。

* capFirst 方法
```java
//方法定义
public static String capFirst(String input){...}
//方法调用示例
String str = S.capFirst("abc");
log.debug(str);
//执行结果
===> Abc
```
该方法用来将首字母转为大写，入参为字符串（input）。

## V(校验)

* isEmpty 方法
```java
//该方法用来判断对象是否为空, 为空返回true，不为空返回false
//方法定义
public static boolean isEmpty(Object obj){...}
//方法调用示例
boolean isEmpty = V.isEmpty(obj);

//该方法用来判断字符串是否为空, 为空返回true，不为空返回false
//方法定义
public static boolean isEmpty(String value){...}
//方法调用示例
boolean isEmpty = V.isEmpty(value);

//该方法用来判断字符串数组是否为空, 为空返回true，不为空返回false
//方法定义
public static boolean isEmpty(String[] values){...}
//方法调用示例
boolean isEmpty = V.isEmpty(values);

//该方法用来判断集合是否为空, 为空返回true，不为空返回false
//方法定义
public static <T> boolean isEmpty(Collection<T> list){...}
//方法调用示例
boolean isEmpty = V.isEmpty(list);

//该方法用来判断Map是否为空, 为空返回true，不为空返回false
//方法定义
public static boolean isEmpty(Map obj){...}
//方法调用示例
boolean isEmpty = V.isEmpty(obj);
```

* notEmpty 方法
```java
//判断对象是否不为空, 为空返回false，不为空返回true
//方法定义
public static boolean notEmpty(Object obj){...}
//方法调用示例
boolean notEmpty = V.notEmpty(obj);

//判断字符串是否不为空, 为空返回false，不为空返回true
//方法定义
public static boolean notEmpty(String value){...}
//方法调用示例
boolean notEmpty = V.notEmpty(value);

//判断数组是否不为空, 为空返回false，不为空返回true
//方法定义
public static boolean notEmpty(String[] values){...}
//方法调用示例
boolean notEmpty = V.notEmpty(values);

//判断集合是否不为空, 为空返回false，不为空返回true
//方法定义
public static <T> boolean notEmpty(Collection<T> list){...}
//方法调用示例
boolean notEmpty = V.notEmpty(list);

//判断Map是否不为空, 为空返回false，不为空返回true
//方法定义
public static boolean notEmpty(Map obj){...}
//方法调用示例
boolean notEmpty = V.notEmpty(obj);
```

* notEmptyOrZero 方法
```java
//判断Long类型对象是否不为空且不为0，是返回true，否返回false
//方法定义
public static boolean notEmptyOrZero(Long longObj){...}
//方法调用示例
boolean notEmptyOrZero = V.notEmptyOrZero(longObj);

//判断Integer类型对象是否不为空且不为0，是返回true，否返回false
//方法定义
public static boolean notEmptyOrZero(Integer intObj){...}
//方法调用示例
boolean notEmptyOrZero = V.notEmptyOrZero(intObj);
```

* isNumber 方法
```java
//方法定义
public static boolean isNumber(String str){...}
//方法调用示例
boolean isNumber = V.isNumber(str);
```
该方法用来判断是否为整型数字，是返回true，否返回false。

* isNumeric 方法
```java
//方法定义
public static boolean isNumeric(String str){...}
//方法调用示例
boolean isNumeric = V.isNumeric(str);
```
该方法用来判断是否为数字（允许小数点），是返回true，否返回false。

* isEmail 方法
```java
//方法定义
public static boolean isEmail(String str){...}
//方法调用示例
boolean isEmail = V.isEmail(str);
```
该方法用来判断是否为正确的邮件格式，是返回true，否返回false。

* isPhone 方法
```java
//方法定义
public static boolean isPhone(String str){...}
//方法调用示例
boolean isPhone = V.isPhone(str);
```
该方法用来判断是否为电话号码，是返回true，否返回false。

* isValidBoolean 方法
```java
//方法定义
public static boolean isValidBoolean(String value){...}
//方法调用示例
boolean isValidBoolean = V.isValidBoolean(value);
```
该方法用来判断是否为合法boolean类型，是返回true，否返回false。

* isTrue 方法
```java
//方法定义
public static boolean isTrue(String value){...}
//方法调用示例
boolean isTrue = V.isTrue(value);
```
该方法用来判定是否为true。

* validate 方法
```java
//方法定义
public static String validate(String value, String validation){...}
//方法调用示例
String validateResult = V.validate(value, validation);
```
该方法用来根据指定规则校验字符串的值是否合法，入参为需要校验的字符串（value）、校验种类（validation）。

* notEquals 方法
```java
//方法定义
public static boolean notEquals(Object source, Object target){...}
//方法调用示例
boolean notEquals = V.notEquals(source, target);
```
该方法用来判定两个对象是否不同类型或不同值，是返回true，否返回false。

* equals 方法
```java
//方法定义
public static <T> boolean equals(T source, T target){...}
//方法调用示例
boolean equals = V.equals(source, target);
```
该方法用来判定两个对象是否类型相同值相等，是返回true，否返回false。

* fuzzyEqual 方法
```java
//方法定义
public static boolean fuzzyEqual(Object source, Object target){...}
//方法调用示例
boolean fuzzyEqual = V.fuzzyEqual(source, target);
```
该方法用来模糊对比是否相等（类型不同的转成String对比），是返回true，否返回false。