# 起步简介

## diboot-core 简介

> diboot-core 是 diboot 2.x版本的核心基础框架，基于Spring Boot、Mybatis-plus封装，实现基础代码的简化及高效开发。
> 使用diboot-core可以更加简单快捷地创建web应用，您之前的诸多代码将被极大简化，更易维护。
> 同时搭档[diboot-devtools](../diboot-devtools/介绍.md)，让您彻底摆脱常规SQL与CRUD。

高效精简内核，重构查询方式，简化开发、提高性能，主要实现：
1. 单表CRUD无SQL
2. 关联查询绑定无SQL（注解自动绑定）
3. 数据字典无SQL（注解自动绑定）
4. 跨表Join查询无SQL（QueryWrapper自动构建与查询）
5. BaseService扩展增强，支持常规的单表及关联开发场景接口
6. 其他常用Service接口、工具类的最佳实践封装
7. 提供[diboot-core-starter](https://github.com/dibo-software/diboot-example/tree/master/diboot-core-example)，简化diboot-core的初始化配置（自动配置、自动创建数据字典表）

## diboot-core 使用步骤
### 1. 引入依赖
Gradle:
~~~gradle
compile("com.diboot:diboot-core-spring-boot-starter:{latestVersion}")
~~~
或Maven
~~~xml
<dependency>
    <groupId>com.diboot</groupId>
    <artifactId>diboot-core-spring-boot-starter</artifactId>
    <version>{latestVersion}</version>
</dependency>
~~~

### 2. 配置参数（数据源）
* 以Mysql为例，配置数据源如下：
~~~properties
#datasource config
spring.datasource.url=jdbc:mysql://localhost:3306/diboot_example?characterEncoding=utf8&serverTimezone=GMT%2B8
spring.datasource.username=diboot
spring.datasource.password=123456
spring.datasource.hikari.maximum-pool-size=5
spring.datasource.hikari.driver-class-name=com.mysql.cj.jdbc.Driver
~~~
> 注：@BindDict注解需要依赖dictionary表，diboot-core starter 初次启动时会自动创建该表。

* diboot-core-spring-boot-starter的可选参数配置：
~~~properties
# 是否初始化sql，默认true，初始化之后可以改为false关闭
diboot.core.init-sql=false
~~~

### 3. 参考样例 - [diboot-core-example](https://github.com/dibo-software/diboot-example/tree/master/diboot-core-example)

> diboot-core的最佳实践：建议自定义自己的Base类，避免直接继承core中的Base类，便于后期扩展。
启用devtools，可一键生成初始Base类代码到本地。

## 支持数据库
MySQL (5.7+)、MariaDB (10+)、ORACLE (12c+)、SQLServer (2017+)、PostgreSQL (11+)。
> 其他数据库不支持starter自动安装表，如果需要其他库下使用绑定功能，可只依赖diboot-core，手动建表验证。

## 相关依赖
> 新项目建议使用 diboot-core-starter自动配置及建表，mybatis-plus老项目可以尝试依赖diboot-core并手动配置。

::: tip
diboot-core 依赖：
:::
* **javax.servlet-api** 4.x
* **spring-web** 5.2.x.RELEASE
* **spring-tx** 5.2.x.RELEASE
* **spring-context** 5.2.x.RELEASE
* **hibernate-validator** 6.1.5.Final
* **slf4j-api** 1.7.x
* **mybatis-plus** 3.4.x
* **commons-lang3** 3.11
* **fastjson** 1.2.x

::: tip
diboot-core-starter 新增依赖：
:::
* **spring-boot-starter-web** 2.3.x.RELEASE
* **spring-boot-starter-validation** 2.3.x.RELEASE
* **mybatis-plus-boot-starter** 3.4.x
* **commons-io** 2.6

::: tip
需要额外添加的jar
:::
* **数据库驱动包** (如 mysql:mysql-connector-java:8.0.21)

> 使用过程中遇到问题，可加群交流。    
