# 介绍

## diboot-devtools 的诞生背景

> 众多开发团队现状: 效率低、质量差、可维护性差，我们也常听到开发者抱怨每天CRUD、工作就是搬砖。

> diboot-devtools 是面向Java开发人员的自动化助理，有了她，你可以彻底摆脱常规SQL与CRUD等重复性的工作，专注于数据结构设计、业务实现，提高软件的质量、效率、可维护性。

> **diboot-devtools - 将复杂的事情简单化，重复的事情自动化**

## diboot-devtools 的核心特性
* 支持多种数据库（MySQL、MariaDB、PostgreSQL、ORACLE、SQLServer）
* 使用很简单（UI界面操作，引入依赖，配置参数后，即可随SpringBoot本地项目启动运行）
* 功能很强大（数据结构变更与代码联动同步，一键生成&非覆盖式更新后端代码，自动记录变更SQL、维护索引，一键生成前端功能代码，自动进行前后端权限绑定，自动完成数据关联相关前后端工作，ER图展示关联关系等）
* 单表与联表场景完整CRUD功能前后端代码完全自动生成，无需手写代码
* SQL与代码很标准（devtools标准化了数据结构定义与代码实现，降低维护成本）
* 配置很灵活（可按需配置生成代码路径、是否启用`Lombok`、`Swagger`等）
* 开发很快捷（即便需要自己编写代码来实现特定业务逻辑，也能依赖我们生成的标准基础代码来快速完成）
* 使用很省心（能自动化处理的我们都会自动化帮您搞定，让您省心）
* 代码基于diboot高效基础框架生成，是diboot的最佳实践

## devtools支持的数据库版本
* MySQL 5.7+
* MariaDB 10+
* ORACLE 12c+
* SQLServer 2017+
* PostgreSQL 11+