# 开始使用
## 1. 创建新的Spring Boot web项目
推荐使用 [Spring Initializer](https://start.spring.io/)，快速初始化一个 Spring Boot 工程。
如果您使用IntelliJ IDEA，可以直接通过菜单: File -> New -> Project -> Spring Initializr 创建。

> 如果需要生成前端，需根据相关版本下载对应的前端项目: [diboot-element-admin](https://github.com/dibo-software/diboot-element-admin/releases) 或  [diboot-antd-admin](https://github.com/dibo-software/diboot-antd-admin/releases)

## 2. 引入依赖
* Gradle项目引入依赖
```
compile("com.diboot:diboot-core-spring-boot-starter:{latestVersion}")
providedCompile("com.diboot:diboot-devtools-spring-boot-starter:{latestVersion}")
```
* Maven项目引入依赖
```
<dependency>
    <groupId>com.diboot</groupId>
    <artifactId>diboot-core-spring-boot-starter</artifactId>
    <version>{latestVersion}</version>
</dependency>
<dependency>
    <groupId>com.diboot</groupId>
    <artifactId>diboot-devtools-spring-boot-starter</artifactId>
    <version>{latestVersion}</version>
    <scope>provided</scope><!-- 打war包时剔除，注: IDEA社区版请勿添加此行 -->
</dependency>
```
如果spring boot项目需要打jar包运行，则需要参考如下配置确保打包时剔除devtools：
~~~
<plugins>
    <plugin>
        <groupId>org.springframework.boot</groupId>
        <artifactId>spring-boot-maven-plugin</artifactId>
        <configuration>
            <!-- 打jar包时剔除 -->
            <excludes>
                <exclude>
                    <groupId>com.diboot</groupId>
                    <artifactId>diboot-devtools-spring-boot-starter</artifactId>
                </exclude>
            </excludes>
        </configuration>
    </plugin>
</plugins>
~~~

> diboot-devtools-spring-boot-starter 是用于开发过程的助手工具，须声明 **exclude**剔除devtools jar，以免打包至非开发环境。  

## 3. 添加配置信息
* diboot-core starter依赖的数据源配置（已配置可忽略），Mysql示例：
~~~properties
#datasource config
spring.datasource.url=jdbc:mysql://localhost:3306/diboot_example?characterEncoding=utf8&serverTimezone=GMT%2B8
spring.datasource.username=diboot
spring.datasource.password=123456
spring.datasource.hikari.maximum-pool-size=5
spring.datasource.hikari.driver-class-name=com.mysql.cj.jdbc.Driver
~~~

* diboot-devtools 配置示例：
~~~properties
# Spring 相关配置
spring.main.allow-bean-definition-overriding=true

# diboot-devtools 相关配置
# 作者等注释信息
diboot.devtools.codes-version=1.0
diboot.devtools.codes-copyright=MyCompany
diboot.devtools.codes-author=MyName
# 代码生成路径及偏好
diboot.devtools.output-path=example/src/main/java/com/diboot/example/
diboot.devtools.output-path-sql=example/src/main/resources/
diboot.devtools.enable-lombok=true
#diboot.devtools.enable-swagger=false
#diboot.devtools.generate-mapper-xml=false
# 前端项目路径（diboot-element-admin 或 diboot-antd-admin项目，此处如果与后端项目为同一项目下不同模块，可只配置模块名，否则需要配置绝对路径，即全路径）
diboot.devtools.output-path-frontend=/D:/Workspace/diboot/diboot-antd-admin/
~~~

* diboot-devtools 配置参数说明：

    * spring.main.allow-bean-definition-overriding=true：遇到同样名字的Bean时，允许覆盖。

    **以下diboot-devtools 相关配置均可根据实际情况填写**
    * codes-version：当前使用diboot-devtools的版本号。
    * codes-copyright：生成代码的版权归属，显示在每个类或接口的注释中。
    * codes-author：生成代码的作者，显示在每个类或接口的注释中。
    * output-path：当前项目代码的默认起始路径
    * output-path-*：分别定义当前项目中`Entity`、`VO`、`Service及其实现类`、`Mapper及映射文件`、`Controller`、等文件所在的路径。
    * output-path-sql：devtools生成的数据结构变更SQL存储路径，便于同步至非开发环境。
    * generate-mapper-xml：是否生成Mapper.xml文件，默认true
    * enable-lombok：是否引入`Lombok`注解，若设置true，请注意添加Lombok依赖。
    * enable-swagger：是否引入`Swagger`注解，若设置true，请注意添加Swagger依赖。
    * output-path-frontend：前端Vue项目路径，用于前端代码生成（此处如果与后端项目为同一项目下不同模块，可只配置模块名，否则需要配置绝对路径，即全路径）。前端项目下载： [diboot-element-admin](https://github.com/dibo-software/diboot-element-admin) 或  [diboot-antd-admin](https://github.com/dibo-software/diboot-antd-admin)

:::warning
如果您使用的是**PostgreSQL数据库**，那么需要额外添加两行配置，以此来适配boolean类型字段所对应的数据库的boolean类型，需添加的配置如下：
:::
```properties
mybatis-plus.global-config.db-config.logic-delete-value=true
mybatis-plus.global-config.db-config.logic-not-delete-value=false
```

## 4. 启动项目
以 Spring Boot 项目在IntelliJ IDEA中的一种启动方式为例：

在项目入口文件 `Application` 上点击右键，在弹出的菜单上点击 `RUN 'Application'`。
当出现类似下面提示时，表示启动成功：
```
: Started Application in 4.223 seconds (JVM running for 16.693)
```
diboot-devtools在初次运行中，会自动检测安装以diboot_前缀的数据库表。

## 5. 打开管理页面
在控制台(Console)上的启动日志中，找到如下日志：
```
: Diboot devtools v2.x 开始初始化 ...
: ...
: devtools UI初始化完成，URL: http://localhost:8080/example/diboot/index.html
: Diboot devtools 初始化完成。
```
其中的`URL`即是devtools页面链接，点击即可打开Devtools操作界面。

## 注意
* Devtools是用于开发过程的助手工具，切勿将其打包至非开发环境。实践准则：
    * 方式一（非开发环境取消devtools依赖）：
    * Gradle项目引入依赖
    ```
    providedCompile("com.diboot:diboot-devtools-spring-boot-starter:$dibootDevtoolsVersion")
    ```
    * Maven配置
    ```
    // dependency节点
    <dependency>
        <groupId>com.diboot</groupId>
        <artifactId>diboot-devtools-spring-boot-starter</artifactId>
        <scope>provided</scope><!-- 打war包时剔除，注: IDEA社区版请勿添加此行 -->
    </dependency>
    
    //plugins节点配置
    <plugin>
        <groupId>org.springframework.boot</groupId>
        <artifactId>spring-boot-maven-plugin</artifactId>
        <configuration>
            <!-- 打jar包时剔除 -->
            <excludes>
                <exclude>
                    <groupId>com.diboot</groupId>
                    <artifactId>diboot-devtools-spring-boot-starter</artifactId>
                </exclude>
            </excludes>
        </configuration>
    </plugin>
    ```
    
    * 方式二（为devtools创建专属项目，与代码项目隔离开）：
    单独为devtools建立一个专属项目，生成代码路径指向你的项目代码，需要使用devtools时启动这个devtools项目。
    
## 参考样例
devtools使用样例(gradle配置) [diboot-devtools-example](https://github.com/dibo-software/diboot-example/tree/master/diboot-devtools-example)
    
> 使用过程中遇到问题，可加群交流。    