# 数据表管理
* 项目开发过程中，通过数据库管理工具创建表时，可选择同时生成代码(`Entity`、`VO`、`Service及其实现类`、`Mapper及映射文件`、`Controller`)，并保存相关SQL更新历史。
* 通过数据库管理工具修改表、字段及关联关系时，也将同步地更改后端代码，让您彻底摆脱繁琐的CRUD和简单关联查询。
* 数据库管理工具中可以填写字段的样例数据，devtools会自动插入到表中作为后续生成预览等的样例展示。

## 创建数据表
>  点击数据表的列表栏上方"**+**"按钮，打开创建表窗口。可以使用**引导建表**和**SQL建表**两种方式来创建数据库表。

![创建数据表](./images/add-table-btn.png)

![创建表配置](./images/add-table-panel.jpg)

1. 引导建表

* 数据库表名：建议使用英文小写命名，多个单词以下划线分隔。
* 业务对象名：该数据库表所代表的业务对象中文名称，建议名词，将会用在后续的生成代码中。
* ID策略：可选用如下ID生成方式
    * 数据库自增ID：使用数据库的自增主键，在系统中为Long类型，ID值连续，可被猜测，建议在非敏感数据的表中使用。
    * 程序生成有序ID：程序自动生成有序的非连续Long型ID，该ID为19位，且不连续，默认以该字段对列表排序，建议在要求高效率索引的敏感数据的表中使用。 (注意：后端返回前端时，该类型的ID直接转换成前端JavaScript对象时存在失真问题，如接收到json数据后前端可使用pkString代替pk/id的值，以免造成结果错误。)
    * 程序生成无序ID：程序自动生成无序的32位无序字符串(UUID)来作为ID，该ID无规律可循，不可用作排序，非必需情况不建议使用。
* 预置字段：
    * id：
    * is_deleted：逻辑删除标记字段，用来表明该条数据是否已删除，默认为0代表未删除，1代表已删除。
    * create_time：创建时间，数据库默认值为创建时的当前系统时间。
    * create_by：创建人id。
    * update_time：更新时间，数据库默认值为更新时的当前系统时间。
    * extdata：预留扩展字段，用来存放该表各类相关冗余数据的json字符串。

2. SQL建表

在`文本框`内输入建表SQL语句，点击`确定`按钮。

## 数据设计
> 在管理页面中，点击左侧**数据库表列表**中某个表，将会加载该表的所有字段到右侧面板中。
> 点击**搜索表**输入框，输入某个表名，系统将实时搜索该表，并显示在下方的**数据库表列表**中。

### 表的相关配置

![表结构配置](./images/databases-structure.jpg)

1. 操作
    
   从左到右，有三个按钮：
   * 按住最左侧按钮，可以上下移动改行所在的位置。
   * 中间+按钮，点击可添加一行。
   * 最右侧-按钮，点击可删除该行。
2. 字段名
   * 字段名是数据库中的字段名称，建议使用英文小写命名，以下划线分割，如：name, teacher_id等。(注意请勿使用“"a_xyz"这种"单字母+下划线"形式命名，避免cglib转换问题)
   * 字段名被转化后，会自动添加到Entity类的属性中。转化过程中会将下划线去掉，并将下划线后面的首字母大写，遵循驼峰命名法。如：name, teacherId等。

3. 字段标签
   * 字段标签在数据库表中为该字段的comment备注。
   * 代码中字段标签将显示为该字段的名称，如：姓名，教师等，建议使用名词，因为该备注会用于拼接校验提示信息及前端显示等。

4. 数据类型
   * devtools提供了7种数据类型供选择，分别是：String, Long, Integer, Boolean, Date, Double, BigDecimal。
   * Entity类中使用这里所选的数据类型。数据库表中存放的Type将会根据所选择的数据类型自动进行匹配。

5. 长度
   * 长度表示该字段在数据库表中设置的长度，0表示不设置长度。
   * Entity类中的属性都会使用这里的设置进行长度校验。

6. 扩展配置

   主要提供该字段的某些可供选择的特性，说明如下：
   * unsigned 勾选该配置，表示这是个无符号数字，同时将该特性设置到数据库表中。
   * char 勾选该配置，在数据库表中会将该字段的type设置为定长char。
   * LIKE 勾选该配置，在接收前端请求转换为QueryWrapper时，会将该字段查询条件转换为LIKE查询。
   * 对于Date类型的字段，时间格式有两种供选择：yyyy-MM-dd HH:mm和yyyy-MM-dd

7. 非空
   * 勾选了该选项的复选框，表示该字段不能为空，同时在数据库表中设置该字段非空。
   * Entity类中的属性都会使用这里的设置进行非空校验。

8. 默认值
   * 可以根据字段的配置，填写或选择默认值。
   * 该默认值将会设置到数据库表字段的默认值属性中。
   * 对于非空字段，尤其要注意，是否应该设置默认值。

9. 表单类型
   
   devtools提供了常用的表单类型：`选择框`、`单行输入`、`多行输入`、`富文本编辑`、`图片上传`、`文件上传`、`忽略不显示`。
   * 表示该字段在表单页面中，以哪种方式进行数据输入，生成的代码中将包含该输入方式的相关表单元素。
   * 当一个字段选择数据类型或者关联方式后，devtools会将推荐的表单类型设置到这个字段。

10. 关联
   
    设置该字段关联关系的方式，可选择`无`、`数据表`、`数据字典`。
    * 选择关联`数据表`后，将会弹出可供选择的数据库表。依次是`关联方式`(1-1, n-1, n-n),`哪个表`(关联表名)、`哪个字段`(关联表中与该字段对应的字段)、`显示的字段`(显示关联表信息的字段)、附加选项`在目标对象中绑定`(在目标对象中绑定当前对象)。
      如果指定了`显示的字段`，则生成代码将生成@BindField；如果未指定则生成@BindEntity。
      如果n-1关联中选择了`在主对象中绑定`，则将在目标主表的VO中反向绑定当前从表的Entity集合。
      
    * 选择关联`数据字典`后，将会弹出可供选择的数据字典，选择一个元数据关联到该字段即可。

11. 样例数据
   
    填写样例数据，方便后续的开发调试。
    ::: warning
    注：在2.0.x版本中，非空字段的样例数据不能为空，并且须严格按照字段的数据类型填写。在2.1.x版本中，非空字段的样例数据可以被自动填充个，也可以自己填写。
    ::: 
    
## 关联配置

![关联配置示例](./images/ref_demo.jpg)

## 关系图
> 显示数据表之间的关联关系，方便开发人员清晰的了解项目的数据模型。

![关联配置示例](./images/er_example.jpg)
