# IAM-base: 身份认证组件 (基础版)

## 1、扩展其他登录方式
默认的登录方式为：用户名密码，如需扩展其他登录方式：
* 创建你的认证凭证对象，继承自AuthCredential
* 实现AuthService接口，定义认证方式及接口实现
* 申请token替换为你的认证方式: 
~~~java
MyAuthCredential credential = new MyAuthCredential();
String authtoken = AuthServiceFactory.getAuthService("WX_CP").applyToken(credential);
~~~

## 2、替换用户类型或扩展多种用户类型
默认的用户实体为IamUser，获取当前登录用户对象:
~~~java
IamUser currentUser = IamSecurityUtils.getCurrentUser();
~~~
如果预置属性如果不能满足业务场景需要，可替换用户为你的实体：
* 首先在登录的方法中，生成token前传入当前用户类型：
（如果有多种用户类型共用登录接口，可以从前端登录页传入"用户类型值"）
~~~java
MyAuthCredential credential = new MyAuthCredential();
credential.setUserTypeClass(Employee.class); // 用户类型为自定义
String authtoken = AuthServiceFactory.getAuthService("WX_CP").applyToken(credential);
~~~
获取用户对象相关代码改为：
~~~java
Employee currentUser = IamSecurityUtils.getCurrentUser();
~~~
或多种用户：
~~~java
// 获取当前登录用户抽象对象
BaseLoginUser currentUser = IamSecurityUtils.getCurrentUser();
// 查询用户角色
IamRoleVO roleVO = null;
if(currentUser instanceof IamUser){
    IamUser user = (IamUser) currentUser;
    // 角色权限数据
    roleVO = iamUserService.buildRoleVo4FrontEnd(user);
}
else if(currentUser instanceof Employee){
    List<IamRoleVO> roleVOList = iamUserRoleService.getAllRoleVOList(currentUser);
    roleVO = IamHelper.buildRoleVo4FrontEnd(roleVOList);
}
...
~~~

## 3、替换缓存Manager
组件默认缓存类为shiro的内存缓存实现：MemoryConstrainedCacheManager，如果需要替换为redis等自定义缓存，
需要创建缓存实现类实现CacheManager接口 (可以参考MemoryConstrainedCacheManager的源码)，并配置参数diboot.iam.cache-manager-class为你的缓存类。
```
diboot.iam.cache-manager-class=com.xxx.MyCacheManager
```

## 4. 自定义数据权限
> 某些场景下搜索查询需要绑定一些强制条件，用于数据权限控制，如只能查询本部门的数据。
#### 1. 在需要数据权限控制的Entity中的字段上添加@DataAccessCheckpoint注解，指定CheckpointType。
示例代码：
~~~java
// 数据权限检查点
@DataAccessCheckpoint(type = CheckpointType.ORG)
private Long orgId;
~~~
#### 2. 实现DataAccessInterface接口，返回当前用户可访问的对应CheckpointType的合法ID集合
~~~java
public class DataAccessPermissionImpl implements DataAccessInterface {
    @Override
    public List<Long> getAccessibleIds(CheckpointType type) {
        // 返回对应检查点的当前用户可访问的合法ID
        if(type.equals(CheckpointType.ORG)){
            return Arrays.asList(100001L, 100002L);
        }
        ...
    }
}
~~~
#### 3. Spring config类中配置Mybatis-plus数据权限拦截器，启用数据权限拦截
~~~java
@Bean
public MybatisPlusInterceptor mybatisPlusInterceptor() {
    MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
    // 添加数据权限拦截器
    interceptor.addInnerInterceptor(new DataAccessControlInteceptor());
    return interceptor;
}
~~~