#ifndef GIF_IMAGE_HEAD_FILE
#define GIF_IMAGE_HEAD_FILE

#pragma once

#include "SkinUI.h"

//////////////////////////////////////////////////////////////////////////
//GIF öٶ

//ö
enum enGIFBlockTypes
{
	BLOCK_UNKNOWN,					//δ֪
	BLOCK_APPEXT,					//ͼο
	BLOCK_COMMEXT,					//עͱǩ
	BLOCK_CONTROLEXT,				//ͼαǩ
	BLOCK_PLAINTEXT,				//ͼαǩ
	BLOCK_IMAGE,					//ͼʶ
	BLOCK_TRAILER					//ļս
};

//չö
enum enControlExtValues
{
	GCX_PACKED_DISPOSAL,			//÷
	GCX_PACKED_USERINPUT,			//־
	GCX_PACKED_TRANSPCOLOR			//͸־
};

//ʾ
enum enLSDPackedValues
{
	LSD_PACKED_GLOBALCT,			//ɫ־
	LSD_PACKED_CRESOLUTION,			//ɫ
	LSD_PACKED_SORT,				//־
	LSD_PACKED_GLOBALCTSIZE			//ȫɫ
};

//ö
enum enIDPackedValues
{
	ID_PACKED_LOCALCT,				//ɫ־
	ID_PACKED_INTERLACE,			//֯־
	ID_PACKED_SORT,					//־
	ID_PACKED_LOCALCTSIZE			//ɫС
};

//////////////////////////////////////////////////////////////////////////
//GIF ṹ

#pragma pack(1)

//ļͷṹ
struct tagGIFHeader
{
	BYTE							cbSignature[3];						//GIF 
	BYTE							cbVersion[3];						//GIF 汾
};

//߼Ļʶ
struct tagGIFLSDescriptor
{
	WORD							wWidth;								//Ļ
	WORD							wHeight;							//Ļ߶
	BYTE		 					cbPacked;							//ɫ־
	BYTE							cbBkIndex;							//ɫ
	BYTE							cbPixelAspect;						//ؿ߱
};

//ͼʶ
struct tagGIFImageDescriptor
{
	BYTE							cbImageSeparator;					//ͼʶ
	WORD							wXExcursion;						//X ƫ
	WORD							wYExcursion;						//Y ƫ
	WORD							wWidth;								//ͼ
	WORD							wHeight;							//ͼ߶
	BYTE							cbPacked;							//ɫ־
};

//ͼοչ
struct tagGIFControlExt
{
	BYTE							cbExtIntroducer;					//ʶ־
	BYTE							cbControlLabel;						//ʶ־
	BYTE							cbBlockSize;						//С
	BYTE							cbPacked;							//÷
	WORD							wDelayTime;							//ӳʱ
	BYTE							cbTColorIndex;						//͸ɫ
	BYTE							cbBlockTerm;						//ս
};

//עչ
struct tagGIFCommentExt
{
	BYTE							cbExtIntroducer;					//չʶ
	BYTE							cbCommentLabel;						//עͱǩ
};

//ͼıչ
struct tagGIFPlainTextExt
{
	BYTE							cbExtIntroducer;					//չʶ
	BYTE							cbPlainTextLabel;					//ͼαǩ
	BYTE							cbBlockSize;						//С
	WORD							wLeftPos;							//߽λ
	WORD							wTopPos;							//߽λ
	WORD							wGridWidth;							//ı
	WORD							wGridHeight;						//ı
	BYTE							cbCellWidth;						//Ԫ
	BYTE							cbCellHeight;						//Ԫ߶
	BYTE							cbForeGroundColor;					//ɫ
	BYTE							cbBackGroundColor;					//ɫ
};

//Ӧóչ
struct tagGIFAppExtension
{
	BYTE							cExtIntroducer;						//չʶ					
	BYTE							cExtLabel;							//ͼαǩ
	BYTE							cBlockSize;							//С
	char							cAppIdentifier[8];					//ʶ
	char							cAppAuth[3];						//
};

#pragma pack()

//////////////////////////////////////////////////////////////////////////
//ṹ

//ʾṹ
struct tagGIFFrameInfo
{
	UINT							nDelay;								//ʾʱ
	UINT							nDisposal;							//ʽ
	WORD							wXExcursion;						//ͼƫ
	WORD							wYExcursion;						//ͼƫ
	WORD							wImageWidth;						//ͼ
	WORD							wImageHeight;						//ͼ߶
	IPicture *						pIFramePicture;						//ͼӿ
};

//Ϣ
struct tagImageDataInfo
{
	LONG							lDataSize;							//ݴС
	LONG							lCurentPos;							//ǰָ
	LONG							lColorTableSize;					//ɫС
	LPBYTE							cbImageDataBuffer;					//ͼ
};

//鶨
typedef CArray<tagGIFFrameInfo,tagGIFFrameInfo>	CGIFFrameInfoArray;

//////////////////////////////////////////////////////////////////////////

//
class SKINUI_CLASS CGIFImage
{
	//Ա
protected:
	WORD							m_wImageWidth;						//Ļ
	WORD							m_wImageHeight;						//Ļ߶
	COLORREF						m_crBackGroundColor;				//ɫ

	//ں˱
protected:
	INT_PTR							m_nCurrentFrame;					//ǰͼ֡
	CGIFFrameInfoArray				m_GIFFrameInfoArray;				//Ƭ

	//
public:
	//캯
	CGIFImage();
	//
	virtual ~CGIFImage();

	//غ
public:
	//ض
	bool LoadFromFile(LPCTSTR pszFileName);
	//ض
	bool LoadFromMemroy(BYTE * pcbData, LONG lDataSize);
	//ض
	bool LoadFromResource(LPCTSTR pszResourceName, LPCTSTR pszResourceType);

	//ƺ
public:
	//Ƿ
	bool IsNull();
	//ͷͼ
	VOID DestroyImage();

	//Ϣ
public:
	//ͼ
	WORD GetWidth() { return m_wImageWidth; }
	//ͼ߶
	WORD GetHeight() { return m_wImageHeight; }
	//ǰͼ֡
	INT_PTR GetCurrentIndex() { return m_nCurrentFrame; }

	//ͼ֡
public:
	//ǰͼ֡
	tagGIFFrameInfo * GetCurrentFrame();
	//ͼĿ
	INT_PTR GetFrameCount() { return m_GIFFrameInfoArray.GetCount(); }

	//滭
public:
	//滭ͼ
	VOID DrawImageFrame(CDC * pDC, INT nXPos, INT nYPos);
	//滭ͼ
	VOID DrawImageFrame(CDC * pDC, INT nXPos, INT nYPos, INT_PTR nFrameIndex);

	//麯
protected:
	//л
	bool SwitchNextBlock(tagImageDataInfo & ImageDataInfo);
	//鳤
	LONG GetCurrentBlockSize(tagImageDataInfo & ImageDataInfo);
	//鳤
	LONG GetSubBlockSize(tagImageDataInfo & ImageDataInfo, LONG lBlockPos);
	//ȡ
	enGIFBlockTypes GetCurrentBlockType(tagImageDataInfo & ImageDataInfo);

	//ڲ
private:
	//ȡֵ
	inline INT GetPackedValue(const tagGIFControlExt * pGIFControlExt, enum enControlExtValues Value);
	//ȡֵ
	inline INT GetPackedValue(const tagGIFLSDescriptor * pGIFLSDescriptor, enum enLSDPackedValues Value);
	//ȡֵ
	inline INT GetPackedValue(const tagGIFImageDescriptor * pGIFControlExt, enum enIDPackedValues Value);
};

//////////////////////////////////////////////////////////////////////////

#endif