#include "Stdafx.h"
#include "SkinRichEdit.h"
#include <atlimage.h>

using namespace ImageOleLib;
//////////////////////////////////////////////////////////////////////////////////

BEGIN_MESSAGE_MAP(CSkinRichEdit, CRichEditCtrl)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_SETCURSOR()
	ON_WM_RBUTTONDOWN()
	ON_NOTIFY_REFLECT(EN_LINK,OnURLClick)
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////////////////

//캯
CDataObject::CDataObject()
{
	//ýӿ
	m_pIStorage=NULL;
	m_pIOleObject=NULL;

	//ں˱
	m_ulRefCnt=0;
	ZeroMemory(&m_StgMedium,sizeof(m_StgMedium));
	ZeroMemory(&m_FormatEtc,sizeof(m_FormatEtc));

	return;
}

//
CDataObject::~CDataObject()
{
	//ͷŶ
	SafeRelease(m_pIStorage);
	SafeRelease(m_pIOleObject);

	return;
}

//
ULONG STDMETHODCALLTYPE CDataObject::AddRef()
{
	//
	m_ulRefCnt++;

	return m_ulRefCnt;
}

//ͷŶ
ULONG STDMETHODCALLTYPE CDataObject::Release()
{
	//
	if (--m_ulRefCnt==0)
	{
		delete this;
	}

	return m_ulRefCnt;
}

//ѯӿ
HRESULT STDMETHODCALLTYPE CDataObject::QueryInterface(REFIID iid, VOID * * ppvObject)
{
	//ѯӿ
	if (iid==IID_IUnknown||iid==IID_IDataObject)
	{
		*ppvObject=this;
		AddRef();
		return S_OK;
	}
	return E_NOINTERFACE;
}

//ȡ
HRESULT STDMETHODCALLTYPE CDataObject::GetData(FORMATETC * pFormatEtcIn, STGMEDIUM * pStgMedium) 
{
	//״̬ж
	ASSERT(m_StgMedium.hBitmap!=NULL);
	if (m_StgMedium.hBitmap==NULL) return E_HANDLE;

	//ȡ
	HANDLE hHandle=OleDuplicateData(m_StgMedium.hBitmap,CF_BITMAP,0);
	if (hHandle==NULL) return E_HANDLE;

	//ñ
	pStgMedium->tymed=TYMED_GDI;
	pStgMedium->pUnkForRelease=NULL;
	pStgMedium->hBitmap=(HBITMAP)hHandle;

	return S_OK;
}

//
HRESULT STDMETHODCALLTYPE CDataObject::SetData(FORMATETC * pFormatEtc, STGMEDIUM * pStgMedium, BOOL fRelease) 
{
	//ñ
	m_FormatEtc=*pFormatEtc;
	m_StgMedium=*pStgMedium;

	return S_OK;
}

//ͼƬ
bool CDataObject::SetImage(HBITMAP hBitmap)
{
	//Ч״̬
	ASSERT((m_pIOleObject==NULL)&&(m_pIStorage==NULL));
	if ((m_pIOleObject!=NULL)||(m_pIStorage!=NULL)) return false;

	//Ϣ
	m_StgMedium.tymed=TYMED_GDI;
	m_StgMedium.hBitmap=hBitmap;
	m_StgMedium.pUnkForRelease=NULL;

	//Ϣ
	m_FormatEtc.ptd=NULL;
	m_FormatEtc.lindex=-1;
	m_FormatEtc.tymed=TYMED_GDI;
	m_FormatEtc.cfFormat=CF_BITMAP;
	m_FormatEtc.dwAspect=DVASPECT_CONTENT;

	//
	try
	{
		//
		LPLOCKBYTES lpLockBytes=NULL;

		//洢
		if (FAILED(CreateILockBytesOnHGlobal(NULL,TRUE,&lpLockBytes)))
		{
			ASSERT(FALSE);
			throw 0;
		}
		
		//
		if (FAILED(StgCreateDocfileOnILockBytes(lpLockBytes,STGM_SHARE_EXCLUSIVE|STGM_CREATE|STGM_READWRITE,0,&m_pIStorage)))
		{
			ASSERT(FALSE);
			throw 0;
		}

		//д
		if (FAILED(OleCreateStaticFromData(this,IID_IOleObject,OLERENDER_FORMAT,&m_FormatEtc,NULL,m_pIStorage,(VOID * *)&m_pIOleObject)))
		{
			ASSERT(FALSE);
			throw 0;
		}

		//ö
		if (FAILED(OleSetContainedObject(m_pIOleObject,TRUE)))
		{
			ASSERT(FALSE);
			throw 0;
		}

		return true;
	}
	catch (...)
	{
		//ͷŶ
		SafeRelease(m_pIStorage);
		SafeRelease(m_pIOleObject);
	}

	return false;
}

//ͼƬ
bool CDataObject::LoadImage(LPCTSTR pszFileName)
{
	//ͼƬ
	CImage Image;
	Image.Load(pszFileName);

	//ж
	if (Image.IsNull()==true)
	{
		ASSERT(FALSE);
		return false;
	}

	//ͼƬ
	SetImage(Image.Detach());

	return true;
}

//ͼƬ
bool CDataObject::LoadImage(HINSTANCE hInstance, LPCTSTR lpResourceName)
{
	//ͼƬ
	CImage Image;
	Image.LoadFromResource(hInstance,lpResourceName);

	//ж
	if (Image.IsNull()==true)
	{
		ASSERT(FALSE);
		return false;
	}

	//ͼƬ
	SetImage(Image.Detach());

	return true;
}

//ȡϢ
bool CDataObject::IntercalateReObject(REOBJECT & ReObject, IOleClientSite * pIOleClientSite)
{
	//Ч״̬
	ASSERT(m_StgMedium.hBitmap!=NULL);
	if (m_StgMedium.hBitmap==NULL) return false;

	//Ч״̬
	ASSERT((m_pIOleObject!=NULL)&&(m_pIStorage!=NULL));
	if ((m_pIOleObject==NULL)||(m_pIStorage==NULL)) return false;

	//ӿϢ
	ReObject.pstg=m_pIStorage;
	ReObject.poleobj=m_pIOleObject;
	ReObject.polesite=pIOleClientSite;

	//Ϣ
	ReObject.cbStruct=sizeof(ReObject);
	ReObject.cp=REO_CP_SELECTION;
	ReObject.dvaspect=DVASPECT_CONTENT;

	//ȡʶ
	m_pIOleObject->GetUserClassID(&ReObject.clsid);

	return true;
}

//////////////////////////////////////////////////////////////////////////////////

//캯
CSkinRichEdit::CSkinRichEdit()
{
	//ñ
	m_pIRichEditOLE=NULL;
	m_bCanClickMove = FALSE;

	return;
}

//
CSkinRichEdit::~CSkinRichEdit()
{
	//ͷŶ
	SafeRelease(m_pIRichEditOLE);

	return;
}

//ؼ
VOID CSkinRichEdit::PreSubclassWindow()
{
	__super::PreSubclassWindow();

	//ʼؼ
	SetEventMask(ENM_LINK);
	SetOptions(ECOOP_OR,ECO_NOHIDESEL);

	//ȡӿ
	m_pIRichEditOLE=GetIRichEditOle();

	return;
}

BOOL CSkinRichEdit::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	if(pMsg->message==WM_LBUTTONUP)//pMsg->message==WM_LBUTTONDBLCLK)//pMsg->message==WM_LBUTTONDOWN||||pMsg->message==WM_LBUTTONUP
	{	

	}
	return CRichEditCtrl::PreTranslateMessage(pMsg);
}

//Ϣ
INT CSkinRichEdit::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (__super::OnCreate(lpCreateStruct)==-1) return -1;

	//ʼؼ
	SetEventMask(ENM_LINK);
	SetOptions(ECOOP_OR,ECO_NOHIDESEL);

	//ȡӿ
	m_pIRichEditOLE=GetIRichEditOle();

	return 0;
}

//Ļ
bool CSkinRichEdit::CleanScreen()
{
	//Ļ
	SetSel(0,GetWindowTextLength());
	ReplaceSel(TEXT(""));

	return true;
}

//Ϣ
bool CSkinRichEdit::LoadMessage(LPCTSTR pszFileName)
{
	//Ч
	ASSERT(pszFileName!=NULL);
	if (pszFileName==NULL) return false;

	//ļ
	CFile File;
	if (File.Open(pszFileName,CFile::modeRead,NULL)==FALSE) return false;

	//
	EDITSTREAM EditStream;
	EditStream.pfnCallback=LoadCallBack;
	EditStream.dwCookie=(DWORD)(LONGLONG)(&File);

	//ȡļ
    StreamIn(SF_RTF,EditStream);

	return true;
}

//Ϣ
bool CSkinRichEdit::SaveMessage(LPCTSTR pszFileName)
{
	//
	CString strFileName=pszFileName;

	//ļ
	if (strFileName.IsEmpty()==true)
	{
		CFileDialog FileDlg(FALSE,TEXT("RTF"),0,OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT,TEXT("Ϣļ(*.RTF)|*.RTF||"),this);
		if (FileDlg.DoModal()==IDOK) strFileName=FileDlg.GetPathName();
		else return true;
	}

	//ļ
	CFile File;
	if (File.Open(strFileName,CFile::modeWrite|CFile::modeCreate,NULL)==FALSE) return false;

	//
	EDITSTREAM EditStream;
	EditStream.pfnCallback=SaveCallBack;
	EditStream.dwCookie=(DWORD)(LONGLONG)(&File);

	//дļ
    StreamOut(SF_RTF,EditStream);

	return true;
}

//ͼƬ
bool CSkinRichEdit::InsertImage(LPCTSTR pszImage)
{
	//
	LPOLEOBJECT	lpOleObject=NULL;
	LPOLECLIENTSITE pIOleClientSite=NULL;

	//״̬
	CHARRANGE CharRange;
	GetSel(CharRange.cpMin,CharRange.cpMax);

	//
	bool bResumeSelect=(CharRange.cpMax!=CharRange.cpMin);

	try
	{
		//
		IGifAnimatorPtr lpIGifAnimator;

		//
		if (FAILED(lpIGifAnimator.CreateInstance(CLSID_GifAnimator)))
		{
			ASSERT(FALSE);
			throw 0L;
		}

		//ͼ
		if (FAILED(lpIGifAnimator->LoadFromFile((LPCWSTR)(CT2CW(pszImage)))))
		{
			ASSERT(FALSE);
			throw 0L;
		}

		//ȡ
		if (FAILED(lpIGifAnimator->QueryInterface(IID_IOleObject,(VOID * *)&lpOleObject)))
		{
			ASSERT(FALSE);
			throw 0L;
		}

		//ѯӿ
		ASSERT(m_pIRichEditOLE!=NULL);
		m_pIRichEditOLE->GetClientSite(&pIOleClientSite);

		//
		REOBJECT ReObject;
		ZeroMemory(&ReObject,sizeof(REOBJECT));

		//ñ
		ReObject.cbStruct=sizeof(ReObject);	
		ReObject.dwUser=0;
		ReObject.cp=REO_CP_SELECTION;
		ReObject.dwFlags=REO_BELOWBASELINE;
		ReObject.dvaspect=DVASPECT_CONTENT;
		ReObject.pstg=NULL;
		ReObject.poleobj=lpOleObject;
		ReObject.polesite=pIOleClientSite;

		//ѡ
		SetSel(-1,-1);

		//
		m_pIRichEditOLE->InsertObject(&ReObject);

		//ͷŶ
		SafeRelease(pIOleClientSite);

		//״̬
		if (bResumeSelect==true)
		{
			SetSel(CharRange);
		}
		else
		{
			SendMessage(WM_VSCROLL,SB_BOTTOM,0);
		}

		//´
		RedrawWindow(NULL,NULL,RDW_ERASE|RDW_UPDATENOW|RDW_INVALIDATE);

		return true;
	}
	catch (...)
	{
		//ͷŶ
		SafeRelease(lpOleObject);
		SafeRelease(pIOleClientSite);
	}

	return false;
}

//ͼƬ
bool CSkinRichEdit::InsertImage(CBitmap * pBitmap)
{
	//
	CDataObject ImageDataObject;
	ImageDataObject.SetImage((HBITMAP)pBitmap->GetSafeHandle());

	//ͼƬ
	InsertDataObject(&ImageDataObject);

	return false;
}

//
bool CSkinRichEdit::InsertDataObject(CDataObject * pDataObject)
{
	//Ч
	ASSERT((m_pIRichEditOLE!=NULL)&&(pDataObject!=NULL));
	if ((m_pIRichEditOLE==NULL)||(pDataObject==NULL)) return false;

	//״̬
	CHARRANGE CharRange;
	GetSel(CharRange.cpMin,CharRange.cpMax);

	//
	IOleClientSite * pIOleClientSite=NULL;
	bool bResumeSelect=(CharRange.cpMax!=CharRange.cpMin);
	
	//Ϣ
	REOBJECT ReObject;
	ZeroMemory(&ReObject,sizeof(ReObject));

	//ȡ
	ASSERT(m_pIRichEditOLE!=NULL);
	m_pIRichEditOLE->GetClientSite(&pIOleClientSite);

	//ͼƬ
	if (pDataObject->IntercalateReObject(ReObject,pIOleClientSite)==true)
	{
		//ͼƬ
		SetSel(-1L,-1L);
		m_pIRichEditOLE->InsertObject(&ReObject);

		//ָϢ
		if (bResumeSelect==true)
		{
			SetSel(CharRange);
		}
		else
		{
			SendMessage(WM_VSCROLL,SB_BOTTOM,0);
		}
	}

	//ͷŶ
	SafeRelease(pIOleClientSite);

	return true;
}

//ִ
bool CSkinRichEdit::InsertString(LPCTSTR pszString, COLORREF crTextColor)
{
	//
	CHARFORMAT2 CharFormat;
	ZeroMemory(&CharFormat,sizeof(CharFormat));

	//
	CharFormat.cbSize=sizeof(CharFormat); 
	CharFormat.dwMask=CFM_COLOR|CFM_OFFSET;
	CharFormat.crTextColor=crTextColor;

	//ִ
	InsertString(pszString,CharFormat);

	return true;
}

//ִ
bool CSkinRichEdit::InsertString(LPCTSTR pszString, COLORREF crTextColor, COLORREF crBackColor)
{
	//
	CHARFORMAT2 CharFormat;
	ZeroMemory(&CharFormat,sizeof(CharFormat));

	//
	CharFormat.cbSize=sizeof(CharFormat); 
	CharFormat.dwMask=CFM_COLOR|CFM_BACKCOLOR|CFM_OFFSET;
	CharFormat.crTextColor=crTextColor;
	CharFormat.crBackColor=crBackColor;

	//ִ
	InsertString(pszString,CharFormat);

	return true;
}

//ִ
bool CSkinRichEdit::InsertHyperLink(LPCTSTR pszString)
{
	//
	CHARFORMAT2 CharFormat;
	ZeroMemory(&CharFormat,sizeof(CharFormat));

	//
	CharFormat.cbSize=sizeof(CharFormat); 
	CharFormat.dwMask=CFM_LINK|CFM_OFFSET;
	CharFormat.dwEffects=CFE_LINK;

	//ִ
	InsertString(pszString,CharFormat);

	return true;
}

//ִ
bool CSkinRichEdit::InsertHyperLink(LPCTSTR pszString, COLORREF crBackColor)
{
	//
	CHARFORMAT2 CharFormat;
	ZeroMemory(&CharFormat,sizeof(CharFormat));

	//
	CharFormat.cbSize=sizeof(CharFormat); 
	CharFormat.dwMask=CFM_BACKCOLOR|CFM_LINK;
	CharFormat.dwEffects=CFE_LINK;
	CharFormat.crBackColor=crBackColor;

	//ִ
	InsertString(pszString,CharFormat);

	return true;
}

//ù
BOOL CSkinRichEdit::OnSetCursor(CWnd * pWnd, UINT nHitTest, UINT uMessage)
{
	//ù
	if (nHitTest==HTCAPTION)
	{
		SetCursor(LoadCursor(NULL,MAKEINTRESOURCE(IDC_ARROW)));
		return TRUE;
	}

	return __super::OnSetCursor(pWnd,nHitTest,uMessage);
}

//ִ
bool CSkinRichEdit::InsertString(LPCTSTR pszString, CHARFORMAT2 & CharFormat)
{
	//
	bool bResumeSelect;
	CHARRANGE CharRange;

	//״̬
	GetSel(CharRange.cpMin,CharRange.cpMax);
	bResumeSelect=(CharRange.cpMax!=CharRange.cpMin);

	//
	LPCTSTR pszHttp=TEXT("http://");
	const INT nHttpLength=lstrlen(pszHttp);
	const INT nStringLength=lstrlen(pszString);

	//
	INT nStringStart=0;
	INT nStringPause=0;

	//ַ
	for (INT i=0;i<nStringLength;i++)
	{
		//
		INT nUrlPause=i;

		//ַж
		if (((i+nHttpLength)<nStringLength)&&(memcmp(&pszString[i],pszHttp,nHttpLength*sizeof(TCHAR))==0))
		{
			//
			nUrlPause=i+nHttpLength;

			//ַ
			while (nUrlPause<nStringLength)
			{
				//ַж
				if (EfficacyUrlChar(pszString[nUrlPause])==true)
				{
					nUrlPause++;
					continue;
				}

				break;
			}
		}

		//ַֹ
		if (nUrlPause<=(i+nHttpLength)) nStringPause=(i+1);

		//ַ
		if ((i==(nStringLength-1))||(nUrlPause>(i+nHttpLength)))
		{
			//ַͨ
			if (nStringPause>nStringStart)
			{
				//ȡ
				CString strNormalString;
				LPTSTR pszNormalString=strNormalString.GetBuffer(nStringPause-nStringStart+1);

				//ַ
				pszNormalString[nStringPause-nStringStart]=0;
				CopyMemory(pszNormalString,&pszString[nStringStart],(nStringPause-nStringStart)*sizeof(TCHAR));

				//ͷŻ
				strNormalString.ReleaseBuffer();

				//Ϣ
				SetSel(-1L,-1L);
				SetWordCharFormat(CharFormat);
				ReplaceSel((LPCTSTR)strNormalString);
			}

			//ӵַ
			if (nUrlPause>(i+nHttpLength))
			{
				//ȡ
				CString strUrlString;
				LPTSTR pszUrlString=strUrlString.GetBuffer((nUrlPause-i)+1);

				//ַ
				pszUrlString[nUrlPause-i]=0;
				CopyMemory(pszUrlString,&pszString[i],(nUrlPause-i)*sizeof(TCHAR));

				//ͷŻ
				strUrlString.ReleaseBuffer();

				//ʽ
				CHARFORMAT2 CharFormatHyper;
				CharFormatHyper=CharFormat;

				//Чַ
				if (EfficacyUrlString(strUrlString)==true)
				{
					CharFormatHyper.dwMask|=CFM_LINK;
					CharFormatHyper.dwEffects|=CFE_LINK;
				}

				//Ϣ
				SetSel(-1L,-1L);
				SetWordCharFormat(CharFormatHyper);
				ReplaceSel((LPCTSTR)strUrlString);
			}

			//
			nStringStart=__max(i,nUrlPause);
		}

		//
		i+=(nUrlPause-i);
	}

	//״̬
	if (bResumeSelect==true) SetSel(CharRange);
	else PostMessage(WM_VSCROLL,SB_BOTTOM,0);

	return true;
}

//ػص
DWORD CALLBACK CSkinRichEdit::LoadCallBack(DWORD dwCookie, LPBYTE pbBuff, LONG cb, LONG * pcb)
{
	//ȡļ
	*pcb=((CFile *)(LONGLONG)(dwCookie))->Read(pbBuff,cb);

	return 0;
}

//ص
DWORD CALLBACK CSkinRichEdit::SaveCallBack(DWORD dwCookie, LPBYTE pbBuff, LONG cb, LONG * pcb)
{
	//дļ
	((CFile *)(LONGLONG)(dwCookie))->Write(pbBuff,cb);

	return 0;
}

//ַж
bool CSkinRichEdit::EfficacyUrlChar(TCHAR chChar)
{
	//ַ
	if (chChar==TEXT('.')) return true;
	if (chChar==TEXT('=')) return true;
	if (chChar==TEXT('+')) return true;
	if (chChar==TEXT('?')) return true;
	if (chChar==TEXT('#')) return true;
	if (chChar==TEXT('%')) return true;
	if (chChar==TEXT('/')) return true;
	if (chChar==TEXT(':')) return true;
	if (chChar==TEXT('&')) return true;

	//ַΧ
	if ((chChar>=TEXT('a'))&&(chChar<=TEXT('z'))) return true;
	if ((chChar>=TEXT('A'))&&(chChar<=TEXT('Z'))) return true;
	if ((chChar>=TEXT('0'))&&(chChar<=TEXT('9'))) return true;

	return false;
}

//ַж
bool CSkinRichEdit::EfficacyUrlString(LPCTSTR pszUrl)
{
	return true;
}

//Ϣ
VOID CSkinRichEdit::OnDestroy()
{
	__super::OnDestroy();

	//ͷŽӿ
	SafeRelease(m_pIRichEditOLE);
	RemoveScorll();

	return;
}

//ҼϢ
VOID CSkinRichEdit::OnRButtonDown(UINT nFlags, CPoint Point)
{
	//ý
	SetFocus();

	CWnd *pWnd = GetParent();
	if (pWnd != NULL && pWnd->GetSafeHwnd() != NULL )
	{
		pWnd->PostMessage(WM_COMMAND,GetDlgCtrlID(),0);
	}

	return;
}

void CSkinRichEdit::OnURLClick( NMHDR *pNmhdr, LRESULT *pResult )
{
	ENLINK* pENLink = ( ENLINK* )pNmhdr ;
	*pResult = 0 ;

	if (pENLink->msg == WM_LBUTTONUP)
	{

		CString StrURL ;
		CHARRANGE l_CharRange ;

		GetSel( l_CharRange ) ;
		SetSel( pENLink->chrg ) ;
		StrURL = GetSelText() ;
		SetSel( l_CharRange ) ;

		ShellExecute( GetSafeHwnd(), TEXT( "open" ), StrURL, NULL, NULL, SW_SHOWNORMAL ) ;
		*pResult = 1 ;

	}
}

BOOL CSkinRichEdit::CreateControl( CWnd* pParentWnd )
{
	if( !Create(WS_CHILD|WS_VISIBLE | WS_VSCROLL | WS_TABSTOP | ES_MULTILINE|ES_WANTRETURN|ES_AUTOVSCROLL| WS_VSCROLL,CRect(0,0,0,0),pParentWnd,0) )
		return FALSE;

	m_pOwnWnd = this;

	return TRUE;
}

void CSkinRichEdit::SetAttribute( LPCTSTR pstrName, LPCTSTR pstrValue )
{
	ISkinControl::SetAttribute(pstrName,pstrValue);

	if( _tcscmp(pstrName, _T("scrollimage")) == 0 ) 
	{
		SetScrollImage(this,pstrValue);
	}
	else if( _tcscmp(pstrName, _T("bkcolor")) == 0 ) 
	{
		LPTSTR pstr = NULL;
		if( *pstrValue == _T('#')) pstrValue = ::CharNext(pstrValue);
		SetBackColor(_tcstoul(pstrValue, &pstr, 16)) ;
	}
}




void CSkinRichEdit::SetCanClickMove(BOOL bCanClickMove)
{
	m_bCanClickMove=bCanClickMove;
}

void CSkinRichEdit::HandleHighLightTextMsg(DWORD pos, DWORD len,DWORD curSel)
{

	CHARFORMAT cf;
	HideSelection(TRUE,FALSE);
	GetSelectionCharFormat(cf);
	SetSel(0,GetTextLength());
	cf.dwEffects &= ~CFE_AUTOCOLOR;
	cf.crTextColor=RGB(0,0,0);
	SetSelectionCharFormat(cf);
	
	SetSel(static_cast<long>(pos),static_cast<long>(pos+len));
	cf.crTextColor=RGB(0,0,255);
	SetSelectionCharFormat(cf);

	SetSel(static_cast<long>(pos),static_cast<long>(pos));
	HideSelection(FALSE,FALSE);
	
	if(curSel>=0)
		SetSel(static_cast<long>(curSel),static_cast<long>(curSel));
	else
		SetSel(static_cast<long>(pos),static_cast<long>(pos));

/*	int x=GetFirstVisibleLine();
	int i= GetLineCount();
	int p= min(i,x+26-1);
	int t = LineIndex(p);
	if (t<pos+len) 
	{
		LineScroll(26);
		HideSelection(FALSE,FALSE);
		SetSel(static_cast<long>(pos),static_cast<long>(pos));
		
	}*/
}

void CSkinRichEdit::SetRichEditColorAuto()
{
	CHARFORMAT cf;
	GetSelectionCharFormat(cf);
	SetSel(0,this->GetTextLength());
	cf.dwEffects &= ~CFE_AUTOCOLOR;
	cf.crTextColor=RGB(0,0,0);
	SetSelectionCharFormat(cf);
	//SetSel(0,0);
}

void CSkinRichEdit::SetRichEditDefaultFont()
{
	CHARFORMAT cf;
	cf.cbSize=sizeof(CHARFORMAT);
	cf.dwMask=CFM_FACE|CFM_SIZE;
	cf.dwEffects=CFE_ITALIC;//CFE_BOLD|CFM_BOLD|CFM_COLOR|CFM_ITALIC|CFE_BOLD|
	cf.yHeight=14*20;
	lstrcpy(cf.szFaceName, _T(""));
	cf.bCharSet=0;
	cf.bPitchAndFamily=1;
	SendMessage(EM_SETCHARFORMAT,SCF_ALL|SCF_DEFAULT,(LPARAM)&cf);
}