#ifndef SKIN_RICH_EDIT_HEAD_FILE
#define SKIN_RICH_EDIT_HEAD_FILE

#pragma once

#include <RichOle.h>
#include "SkinUI.h"
#include "ISkinControl.h"

//////////////////////////////////////////////////////////////////////////////////

//ͼ
class SKINUI_CLASS CDataObject : public IDataObject
{
	//ں˱
protected:
	ULONG							m_ulRefCnt;							//ü
	STGMEDIUM 						m_StgMedium;						//Ϣ
	FORMATETC 						m_FormatEtc;						//Ϣ

	//ӿڱ
protected:
	IStorage *						m_pIStorage;						//ӿ
	IOleObject *					m_pIOleObject;						//ӿ

	//
public:
	//캯
	CDataObject();
	//
	virtual ~CDataObject();

	//ӿ
public:
	//
	virtual ULONG STDMETHODCALLTYPE AddRef();
	//ͷŶ
	virtual ULONG STDMETHODCALLTYPE Release();
	//ѯӿ
	virtual HRESULT STDMETHODCALLTYPE QueryInterface(REFIID iid, VOID * * ppvObject);

	//ӿ
public:
	//ȡ
	virtual HRESULT STDMETHODCALLTYPE GetData(FORMATETC * pFormatetcIn, STGMEDIUM * pStgMedium);
	//
	virtual HRESULT STDMETHODCALLTYPE SetData(FORMATETC * pFormatEtc, STGMEDIUM * pStgMedium, BOOL fRelease);
	
	//ӿ
public:
	virtual HRESULT STDMETHODCALLTYPE DUnadvise(DWORD dwConnection) { return E_NOTIMPL; }
	virtual HRESULT STDMETHODCALLTYPE QueryGetData(FORMATETC * pFormatEtc) { return E_NOTIMPL; }
	virtual HRESULT STDMETHODCALLTYPE EnumDAdvise(IEnumSTATDATA * * ppenumAdvise) { return E_NOTIMPL; }
	virtual HRESULT STDMETHODCALLTYPE GetDataHere(FORMATETC * pFormatEtc, STGMEDIUM *  pStgMedium ) { return E_NOTIMPL; }
	virtual HRESULT STDMETHODCALLTYPE EnumFormatEtc(DWORD dwDirection, IEnumFORMATETC * * ppenumFormatEtc ) { return E_NOTIMPL; }
	virtual HRESULT STDMETHODCALLTYPE GetCanonicalFormatEtc(FORMATETC * pFormatEtcIn, FORMATETC * pFormatEtcOut) { return E_NOTIMPL; }
	virtual HRESULT STDMETHODCALLTYPE DAdvise(FORMATETC * pFormatEtc, DWORD advf, IAdviseSink * pAdvSink, DWORD * pdwConnection) { return E_NOTIMPL; }

	//ú
public:
	//ͼƬ
	bool SetImage(HBITMAP hBitmap);
	//ͼƬ
	bool LoadImage(LPCTSTR pszFileName);
	//ͼƬ
	bool LoadImage(HINSTANCE hInstance, LPCTSTR lpResourceName);

	//ͼƬ
public:
	//ȡͼƬ
	HBITMAP GetBitmap() { return m_StgMedium.hBitmap; }
	//ȡϢ
	bool IntercalateReObject(REOBJECT & ReObject, IOleClientSite * pIOleClientSite);
};

//////////////////////////////////////////////////////////////////////////////////

//Ϣ
class SKINUI_CLASS CSkinRichEdit : public CRichEditCtrl,public ISkinControl
{
	//ӿڱ
protected:
	IRichEditOle *					m_pIRichEditOLE;					//ӿָ

	//
public:
	//캯
	CSkinRichEdit();
	//
	virtual ~CSkinRichEdit();

	//غ
protected:
	//ؼ
	virtual VOID PreSubclassWindow();
	//ϢԤ
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	//
	virtual void SetAttribute(LPCTSTR pstrName, LPCTSTR pstrValue);
	//ؼ
	virtual BOOL CreateControl(CWnd* pParentWnd);

	//ܺ
public:
	//Ļ
	bool CleanScreen();
	//Ϣ
	bool LoadMessage(LPCTSTR pszFileName);
	//Ϣ
	bool SaveMessage(LPCTSTR pszFileName);

	//ͼƬ
public:
	//ͼƬ
	bool InsertImage(LPCTSTR pszImage);
	//ͼƬ
	bool InsertImage(CBitmap * pBitmap);
	//
	bool InsertDataObject(CDataObject * pDataObject);

	//ִ
public:
	//ִ
	bool InsertString(LPCTSTR pszString, COLORREF crTextColor);
	//ִ
	bool InsertString(LPCTSTR pszString, COLORREF crTextColor, COLORREF crBackColor);
	//ִ
	bool InsertString(LPCTSTR pszString, CHARFORMAT2 & CharFormat);

	//
public:
	//ִ
	bool InsertHyperLink(LPCTSTR pszString);
	//ִ
	bool InsertHyperLink(LPCTSTR pszString, COLORREF crBackColor);

	//
protected:
	//ػص
	static DWORD CALLBACK LoadCallBack(DWORD dwCookie, LPBYTE pbBuff, LONG cb, LONG * pcb);
	//ص
	static DWORD CALLBACK SaveCallBack(DWORD dwCookie, LPBYTE pbBuff, LONG cb, LONG * pcb);

	//ڲ
protected:
	//ַж
	bool EfficacyUrlChar(TCHAR chChar);
	//ַж
	bool EfficacyUrlString(LPCTSTR pszUrl);

	//Ϣӳ
protected:
	//Ϣ
	VOID OnDestroy();
	//Ϣ
	INT OnCreate(LPCREATESTRUCT lpCreateStruct);
	//ҼϢ
	VOID OnRButtonDown(UINT nFlags, CPoint point);
	//ù
	BOOL OnSetCursor(CWnd * pWnd, UINT nHitTest, UINT uMessage);
	//¼
	void OnURLClick(NMHDR *pNmhdr, LRESULT *pResult);

	DECLARE_MESSAGE_MAP()

	//չ
public:
	void SetCanClickMove(BOOL bCanClickMove);
	void HandleHighLightTextMsg(DWORD pos, DWORD len,DWORD curSel);
	void SetRichEditColorAuto();
	void SetRichEditDefaultFont();

private:
	BOOL m_bCanClickMove;
};

//////////////////////////////////////////////////////////////////////////////////

#endif