#pragma once

#include "SkinUI.h"
#include "ISkinControl.h"

// CSkinTabCtrl
#define TCN_DROPDOWN				(NM_FIRST-5)

#define STCI_STYLE_BUTTON			0x0000
#define STCI_STYLE_DROPDOWN			0x0008

class SKINUI_CLASS CSkinTabCtrlItem
{
public:
	CSkinTabCtrlItem(void);
	~CSkinTabCtrlItem(void);

public:
	int						m_nID;
	DWORD					m_dwStyle;
	int						m_nWidth, m_nHeight;
	int						m_nLeftWidth, m_nRightWidth;
	int						m_nPadding;
	CString					m_strText;
	CString					m_strToolTipText;
	CImageEx * m_lpBgImgN, * m_lpBgImgH, * m_lpBgImgD;
	CImageEx * m_lpArrowImgH, * m_lpArrowImgD;
	CImageEx * m_lpIconImg, * m_lpSelIconImg;
};

//////////////////////////////////////////////////////////////////////////
typedef vector<CSkinTabCtrlItem *>			CTabCtrlItemArray;

class SKINUI_CLASS CSkinTabCtrl : public CTabCtrl,public ISkinControl
{
	DECLARE_DYNAMIC(CSkinTabCtrl)

protected:
	CToolTipCtrl				m_ToolTipCtrl;
	CTabCtrlItemArray			m_ItemArray;
	CImageEx					* m_lpBack;
	CImageEx					* m_lpItemBgImgN, * m_lpItemBgImgH, * m_lpItemBgImgD;
	CImageEx					* m_lpArrowImgH, * m_lpArrowImgD;
	int							m_nSelIndex, m_nHoverIndex;
	BOOL						m_bPressArrow;
	BOOL						m_bMouseTracking;
	int							m_nLeft, m_nTop;
	CPoint						m_ptPaddingText;

	//
public:
	//캯
	CSkinTabCtrl();
	//
	virtual ~CSkinTabCtrl();

	//Դ
public:
	//Դ
	BOOL SetBackImage(LPCTSTR lpszFileName, CONST LPRECT lprcNinePart=NULL);
	//ڵԴ
	BOOL SetItemsImage(LPCTSTR lpNormal, LPCTSTR lpHighlight, LPCTSTR lpDown, CONST LPRECT lprcNinePart=NULL);
	//ť
	BOOL SetItemsArrowImage(LPCTSTR lpHighlight, LPCTSTR lpDown);
	
	//ڵԴ
public:
	//ڵ㱳
	BOOL SetItemBack(int nIndex, LPCTSTR lpNormal, LPCTSTR lpHighlight, LPCTSTR lpDown, CONST LPRECT lprcNinePart=NULL);
	//ť
	BOOL SetItemArrowImage(int nIndex, LPCTSTR lpHighlight, LPCTSTR lpDown);
	//ͼԴ
	BOOL SetItemIconImage(int nIndex, LPCTSTR lpIcon, LPCTSTR lpSelIcon);

	//渨
public:
	//ýڵʼ
	void SetLeftTop(int nLeft, int nTop);
	//ڵС
	CSize SetItemSize(CSize size,CONST LPSIZE lpszArrow=NULL);
	//ڵƫ
	void SetItemPadding(int nIndex, int nPadding);
	//
	int HitTest(POINT pt);
	//ƽڵ
	void DrawItem(CDC*pDC, int nIndex);

	//ܺ
public:
	//ȡڵ
	int GetItemCount();
	//ȡǰѡ
	int GetCurSel();
	//õǰѡ
	void SetCurSel(int nCurSel);
	//ӽڵ
	int AddItem(int nID, DWORD dwStyle=STCI_STYLE_BUTTON);
	//ýڵID
	void SetItemID(int nIndex, int nID);
	//ڵ
	void SetItemStyle(int nIndex, int dwStyle);
	//ڵ
	void SetItemText(int nIndex, LPCTSTR lpszText);
	//ڵʾ
	void SetItemToolTipText(int nIndex, LPCTSTR lpszText);
	//
	void SetPaddingText(int nPadding){ m_ptPaddingText = nPadding; }

	//˽гԱ
private:
	//ȡ
	BOOL GetItemRectByIndex(int nIndex, CRect& rect);
	//ȡ
	BOOL GetItemRectByID(int nID, CRect& rect);
	//ȡڵ
	CSkinTabCtrlItem * GetItemByIndex(int nIndex);
	//ȡڵ
	CSkinTabCtrlItem * GetItemByID(int nID);
	
	//Ϣ
public:
	//ػ
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	//Ϣ
	afx_msg void OnPaint();
	//
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	//ƶ
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	//ƿ
	LRESULT OnMouseLeave(WPARAM wparam, LPARAM lparam);
	//Ϣ
	afx_msg void OnDestroy();

public:
	//Ϣ
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	//
	virtual void SetAttribute(LPCTSTR pstrName, LPCTSTR pstrValue);
	//
	virtual void ParseItem(CXmlNode *root);
	//ؼ
	virtual BOOL CreateControl(CWnd* pParentWnd);

protected:
	DECLARE_MESSAGE_MAP()	
};


