#ifndef SKIN_TOOLBAR_EAD_FILE
#define SKIN_TOOLBAR_EAD_FILE

#pragma once

#include "SkinUI.h"
#include "ISkinControl.h"

// CSkinToolBar
#define STBI_STYLE_BUTTON			0x0000
#define STBI_STYLE_SEPARTOR			0x0001
#define STBI_STYLE_CHECK			0x0002
#define STBI_STYLE_DROPDOWN			0x0008
#define STBI_STYLE_WHOLEDROPDOWN	0x0080
// STBI_STYLE_WHOLEDROPDOWNҪSTBI_STYLE_CHECKһ
// STBI_STYLE_DROPDOWNҪSTBI_STYLE_WHOLEDROPDOWNһ

class CSkinToolBarItem
{
public:
	CSkinToolBarItem(void);
	~CSkinToolBarItem(void);

public:
	int							m_nID;
	DWORD						m_dwStyle;
	int							m_nWidth, m_nHeight;
	int							m_nLeftWidth, m_nRightWidth;
	int							m_nPadding;
	CString						m_strText;
	CString						m_strToolTipText;
	BOOL						m_bChecked;
	
	CImageEx * m_lpBgImgN, * m_lpBgImgH, * m_lpBgImgD;
	CImageEx * m_lpLeftH, * m_lpLeftD;
	CImageEx * m_lpRightH, * m_lpRightD;
	CImageEx * m_lpSepartorImg;
	CImageEx * m_lpArrowImg;
	CImageEx * m_lpIconImg;
};

//////////////////////////////////////////////////////////////////////////

class SKINUI_CLASS CSkinToolBar : public CWnd,public ISkinControl
{
	DECLARE_DYNAMIC(CSkinToolBar)
protected:
	CToolTipCtrl					m_ToolTipCtrl;
	std::vector<CSkinToolBarItem *> m_arrItems;
	CImageEx						* m_lpBgImg;
	int								m_nPressIndex, m_nHoverIndex;
	BOOL							m_bPressLorR, m_bHoverLorR;
	BOOL							m_bMouseTracking;
	int								m_nLeft, m_nTop;
	BOOL							m_bAutoSize;
	
	//
public:
	//캯
	CSkinToolBar();
	//
	virtual ~CSkinToolBar();

	//غ
protected:
	//
	virtual void SetAttribute(LPCTSTR pstrName, LPCTSTR pstrValue);
	//
	virtual void ParseItem(CXmlNode *root);
	//ؼ
	virtual BOOL CreateControl(CWnd* pParentWnd);

	//Դ
public:
	//Դ
	BOOL SetItemBgPic(int nIndex, LPCTSTR lpNormal, LPCTSTR lpHighlight, LPCTSTR lpDown, CONST LPRECT lprcNinePart);
	//߱
	BOOL SetItemLeftBgPic(int nIndex, LPCTSTR lpHighlight, LPCTSTR lpDown, CONST LPRECT lprcNinePart);
	//ұ߱
	BOOL SetItemRightBgPic(int nIndex, LPCTSTR lpHighlight, LPCTSTR lpDown, CONST LPRECT lprcNinePart);
	//ͼƬ
	BOOL SetItemSepartorPic(int nIndex, LPCTSTR lpszFileName);
	//ͷͼƬ
	BOOL SetItemArrowPic(int nIndex, LPCTSTR lpszFileName);
	//ͼԴ
	BOOL SetItemIconPic(int nIndex, LPCTSTR lpszFileName);
	//Դ
	BOOL SetBgPic(LPCTSTR lpszFileName, CONST LPRECT lprcNinePart);

	//ܺ
public:
	//Ͻλ
	void SetLeftTop(int nLeft, int nTop);
	//Զߴ
	void SetAutoSize(BOOL bAutoSize);
	//ӽڵ
	int AddItem(int nID, DWORD dwStyle);
	//÷
	void SetItemStyle(int nIndex, int dwStyle);
	//ڵID
	void SetItemID(int nIndex, int nID);
	//ڵС
	void SetItemSize(int nIndex, int nWidth, int nHeight, int nLeftWidth = 0, int nRightWidth = 0);
	//ڵƫ
	void SetItemPadding(int nIndex, int nPadding);
	//ڵı
	void SetItemText(int nIndex, LPCTSTR lpszText);
	//ʾǩ
	void SetItemToolTipText(int nIndex, LPCTSTR lpszText);
	//ȡ
	BOOL GetItemRectByIndex(int nIndex, CRect& rect);
	//ȡ
	BOOL GetItemRectByID(int nID, CRect& rect);
	//ȡcheck
	BOOL GetItemCheckState(int nIndex);
	//check
	void SetItemCheckState(int nIndex, BOOL bChecked);
	//ȡڵ
	CSkinToolBarItem * GetItemByIndex(int nIndex);
	//ȡڵ
	CSkinToolBarItem * GetItemByID(int nID);
	//
	int HitTest(POINT pt);
	//ͼڵ
	void DrawItem(CDC*pDC, int nIndex);

	//Ϣ
public:
	//
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	//ػϢ
	afx_msg void OnPaint();
	//
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	//̧
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	//ƶ
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	//뿪
	afx_msg LRESULT OnMouseLeave(WPARAM wparam, LPARAM lparam);
	//
	afx_msg void OnDestroy();
	//Ϣѭ
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	//ؼ
	virtual BOOL Create(DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID);

protected:
	DECLARE_MESSAGE_MAP()
};

#endif