#ifndef SKIN_MENU_HEAD_FILE
#define SKIN_MENU_HEAD_FILE

#pragma once

#include "SkinUI.h"
#include "ISkinControl.h"
//////////////////////////////////////////////////////////////////////////////////

//
enum enMenuItemType
{
	MenuItemType_String,			//ַ
	MenuItemType_Separator,			//
};

//////////////////////////////////////////////////////////////////////////////////

//˵
class CSkinMenuItem
{
	//
public:
	const enMenuItemType			m_MenuItemType;						//
	HMENU							m_hSubMenu;							//Ӳ˵

	//
public:
	//캯
	CSkinMenuItem(enMenuItemType MenuItemType) : m_MenuItemType(MenuItemType) {m_hSubMenu = NULL;}
	//
	virtual ~CSkinMenuItem() {}
};

//ַ˵
class CSkinMenuString : public CSkinMenuItem
{
	//
public:
	CString							m_strString;						//˵ַ
	CImageEx						*m_pImageN;							//ͼ
	CImageEx						*m_pImageH;							//ͼ

	//
public:
	//캯
	CSkinMenuString() : CSkinMenuItem(MenuItemType_String) {m_pImageN=m_pImageH=NULL;}
	//
	virtual ~CSkinMenuString() {}
};

//ֲ˵
class CSkinMenuSeparator : public CSkinMenuItem
{
	//
public:
	//캯
	CSkinMenuSeparator() : CSkinMenuItem(MenuItemType_Separator) {}
	//
	virtual ~CSkinMenuSeparator() {}
};

//////////////////////////////////////////////////////////////////////////////////

//˵
typedef CArray<CSkinMenuItem *,CSkinMenuItem *>			CMenuItemArray;					//
typedef CArray<CSkinMenuString *,CSkinMenuString *>		CMenuStringArray;				//
typedef CArray<CSkinMenuSeparator *,CSkinMenuSeparator *>	CMenuSeparatorArray;			//

//////////////////////////////////////////////////////////////////////////////////

//˵ں
class SKINUI_CLASS CSkinUIMenu : public CMenu,public ISkinControl
{
	//ͼƬԴ
protected:
	CImageEx						*m_pMenuBar;
	CImageEx						*m_pMenuBack;
	CImageEx						*m_pMenuHoven;
	CImageEx						*m_pSeparator;
	CImageEx						*m_pCheck;
	CImageEx						*m_pArrow;

	//ں˱
protected:
	CMenuItemArray					m_MenuItemActive;					//
	
	//̬
protected:
	static CMenuStringArray			m_MenuItemString;					//ַ
	static CMenuSeparatorArray		m_MenuItemSeparator;				//
	static HHOOK					m_hMenuHook;

protected:
	COLORREF						m_crSeparator;
	int								m_nItemHeight;

	//
public:
	//캯
	CSkinUIMenu();
	//
	virtual ~CSkinUIMenu();

	//غ
public:
	//滭
	virtual VOID DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	//λ
	virtual VOID MeasureItem(LPMEASUREITEMSTRUCT lpMeasureItemStruct);

	//
public:
	//˵
	bool CreatePopupMenu();
	//ٲ˵
	BOOL DestroyMenu();
	//˵
	bool TrackPopupMenu(CWnd * pWnd);
	//˵
	bool TrackPopupMenu(INT nXPos, INT nYPos, CWnd * pWnd);

	//Դ
public:
	//Դ
	BOOL SetMenuBarImage(LPCTSTR lpszFileName,CONST LPRECT lprcNinePart=NULL);
	//Դ
	BOOL SetMenuBackImage(LPCTSTR lpszFileName,CONST LPRECT lprcNinePart=NULL);
	//Դ
	BOOL SetMenuHovenImage(LPCTSTR lpszFileName,CONST LPRECT lprcNinePart=NULL);
	//Դ
	BOOL SetSeparatorImage(LPCTSTR lpszFileName,CONST LPRECT lprcNinePart=NULL);
	//Դ
	BOOL SetCheckImage(LPCTSTR lpszFileName);
	//Դ
	BOOL SetArrowImage(LPCTSTR lpszFileName);
	//ø߶
	void SetItemHeight(int nHeight){ m_nItemHeight = nHeight; }

	//Ӻ
public:
	//
	bool AppendSeparator();
	//ַ
	bool AppendMenu(UINT nMenuID, LPCTSTR pszString, LPCTSTR lpszIconN=NULL, LPCTSTR lpszIconH=NULL, UINT nFlags=0);

	//뺯
public:
	//
	bool InsertSeparator(UINT nPosition);
	//ַ
	bool InsertMenu(UINT nMenuID, LPCTSTR pszString, UINT nPosition,  LPCTSTR lpszIconN=NULL, LPCTSTR lpszIconH=NULL, UINT nFlags=0);

	//޸ĺ
public:
	//ɾ˵
	bool RemoveMenu(UINT nPosition, UINT nFlags);
	//޸Ĳ˵
	bool ModifyMenu(UINT nMenuID, LPCTSTR pszString, UINT nPosition,  LPCTSTR lpszIconN=NULL, LPCTSTR lpszIconH=NULL, UINT nFlags=0);

	//ڲ
private:
	//
	int GetSeparatorCount();
	//ͷ
	VOID FreeMenuItem(CSkinMenuItem * pSkinMenuItem);
	//ȡ
	CSkinMenuItem * AcitveMenuItem(enMenuItemType MenuItemType);

	static LRESULT CALLBACK WindowsHook(int code,WPARAM wParam,LPARAM lParam);

};

//////////////////////////////////////////////////////////////////////////////////

#endif