﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.cart, ims.web" trace="false" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html>
<html id="cart">
<head runat="server">
    <title>我的购物车</title><meta http-equiv="X-UA-Compatible" content="IE=edge" /><meta name="viewport" content="width=device-width,initial-scale=1">
</head>
<body>
    <form id="form1" runat="server">
        <asp:ScriptManager ID="ScriptManager1" runat="server" OnAsyncPostBackError="AsyncError">
            <CompositeScript Path="js/msajax.js" ScriptMode="Release">
                <Scripts>
                    <asp:ScriptReference Name="WebForms.js" Assembly="System.Web" /><asp:ScriptReference Name="MicrosoftAjax.js" /><asp:ScriptReference Name="MicrosoftAjaxWebForms.js" />
                </Scripts>
            </CompositeScript>
        </asp:ScriptManager>

        <asp:UpdatePanel ID="upCart" runat="server" OnPreRender="AddClientProcess" UpdateMode="Conditional">
        <ContentTemplate>
        <asp:GridView ID="gvCart" runat="server"
        GridLines="None"
        AutoGenerateColumns="False"
        AllowPaging="True"
        PageSize="10"
        CssClass="normal sm"
        RowStyle-HorizontalAlign="center"
        FooterStyle-HorizontalAlign="center"
        OnDataBound="GvDataBound"
        OnPageIndexChanging="GvPageChanging"
        OnRowEditing="GvRowEditing"
        OnRowCancelingEdit="CancelEdit"
        OnRowDeleting="GvRowDeleting"
        OnRowUpdating="GvRowUpdating"
        OnRowDataBound="GvRowBound">
        <PagerTemplate>
            <asp:LinkButton ID="lbFirst" runat="server" CommandArgument="First" CommandName="Page" Text="首页"></asp:LinkButton>&nbsp;
            <asp:LinkButton ID="lbPrev" runat="server" CommandArgument="Prev" CommandName="Page" Text="上页"></asp:LinkButton>&nbsp;
            <asp:LinkButton ID="lbNext" runat="server" CommandArgument="Next" CommandName="Page" Text="下页"></asp:LinkButton>&nbsp;
            <asp:LinkButton ID="lbLast" runat="server" CommandArgument="Last" CommandName="Page" Text="末页"></asp:LinkButton>
        </PagerTemplate>
            <FooterStyle HorizontalAlign="Center" />
            <RowStyle HorizontalAlign="Center" />
            <Columns>
                <asp:TemplateField HeaderText="商品" ItemStyle-CssClass="ov">
                </asp:TemplateField>
                <asp:TemplateField HeaderText="缩略图" ItemStyle-CssClass="ov hide2">
                    <HeaderStyle Width="100" CssClass="hide2" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="单价" />
                <asp:TemplateField HeaderText="数量" />
                <asp:BoundField HeaderText="金额" />
                <asp:TemplateField HeaderText="备注" HeaderStyle-CssClass="hide2">
                    <ItemStyle HorizontalAlign="Left" CssClass="hide2" />
                </asp:TemplateField>
                <asp:CommandField ShowEditButton="True" ShowDeleteButton="true" EditText="修改" HeaderText="操作" >
                    <HeaderStyle />
                </asp:CommandField>
            </Columns>
        </asp:GridView>
        <div id="total" runat="server" style="text-align:right;margin-top:1em"></div>
        <div class="footBtnArea">
            <asp:Button ID="preSubmit" runat="server" Text="提交订单" CssClass="btn" OnClick="PreSubmit" />
            <asp:Button ID="clearCart" runat="server" Text="清空购物车" CssClass="btn" OnClientClick="return confirm('确定要清除购物车中所有项目吗？');" OnClick="ClearCart" />
        </div>
         </ContentTemplate>
         <Triggers>
            <asp:PostBackTrigger ControlID="clearCart" />
         </Triggers>
        </asp:UpdatePanel>
        <script src="js/comm.js"></script>
        <script>
            function CartRendered() {
                $("#gvCart td.ov").poshytip({
                    content: function () {
                        return $(this).find("div.hide").html();
                    }
                });
            }
        </script>
    </form>
</body>
</html>