﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.Filters, ims.web" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html>
<html id="filters">
<head runat="server">
    <title>过滤器</title><meta http-equiv="X-UA-Compatible" content="IE=edge" /><meta name="viewport" content="width=device-width,initial-scale=1">
</head>
<body>
    <form id="form1" runat="server">
        <asp:ScriptManager ID="sm" runat="server" OnAsyncPostBackError="AsyncError">
            <CompositeScript Path="js/msajax.js" ScriptMode="Release">
                <Scripts>
                    <asp:ScriptReference Name="WebForms.js" Assembly="System.Web" /><asp:ScriptReference Name="MicrosoftAjax.js" /><asp:ScriptReference Name="MicrosoftAjaxWebForms.js" />
                </Scripts>
            </CompositeScript>
        </asp:ScriptManager>
        <asp:validationsummary id="ValSum" runat="server" ShowMessageBox="True" ShowSummary="False" ValidationGroup="add"></asp:validationsummary>
        <div runat="server" id="pageTitle" class="pageTitle"></div>
        <asp:UpdatePanel ID="up" runat="server" RenderMode="inline" OnPreRender="AddScript" UpdateMode="Conditional">
        <ContentTemplate>
            <div runat="server" id="EmptyPrompt" visible="false" class="highlight"></div>
            <table class="hr">
            <asp:Repeater ID="rptFilters" runat="server" OnItemCommand="rptFilters_Command" OnItemDataBound="rptFilters_ItemBound">
            <HeaderTemplate><tr><th style="width:32px">序号</th><th style="width:110px">名称</th><th class="hide2">筛选条件</th><th style="width:36px">隐藏</th><th style="width:62px">操作</th></tr></HeaderTemplate>
            <ItemTemplate>
                <tr runat="server" id="ItemTr">
                    <td runat="server"></td>
                    <td runat="server"></td>
                    <td runat="server" class="hide2"></td>
                    <td runat="server"></td>
                    <td runat="server"><asp:LinkButton CommandName="showRefed" ToolTip="查看引用" CssClass="pointer f-ref skyblue fb1" ID="ibRef" runat="server" /> <asp:LinkButton CommandName="edit" ToolTip="编辑" CssClass="pointer f-write green fb1" ID="ibEdit" runat="server" /> <asp:LinkButton CommandName="del" ID="ibDel" CssClass="pointer f-bin red fb1" ToolTip="删除" runat="server" OnClientClick="return toDel();" /></td>
                </tr>
            </ItemTemplate>
            </asp:Repeater>
            </table>
        </ContentTemplate>
        </asp:UpdatePanel>
        <div class="footBtnArea">
            <asp:Button runat="server" ID="btnAdd" Text="添加过滤器" OnClick="toAdd" CssClass="btn" />
            <input type="button" onclick="back();" value="返回" class="btn" />
            <asp:Button runat="server" id="btnSort" OnClick="SaveOrder" CssClass="hide" />
        </div>
        <ims:Pop runat="server" ID="refs" ShowOkButton="false" CanelButtonText="关闭" Width="440">
            <ContentTemplate>
                <div runat="server" id="divRefs" class="mtop_m"></div>
            </ContentTemplate>
        </ims:Pop>
    <script src="js/comm.js"></script>
    <script>
        function Init() {
            if (isPc) {
                $("table.hr").sortable({
                    items: "tr[FilterName]",
                    opacity: 0.7,
                    handle: "td:lt(3)",
                    ghosting: true,
                    scroll: false,
                    update: function () {
                        var orders = "";
                        $("table.hr:first tr[FilterName]").each(function () {
                            orders += $.base64.encode($(this).attr("FilterName")) + ",";
                        });
                        __doPostBack("btnSort", orders);
                        reloadBar();
                    }
                });
                var trs = $("table.hr tr:gt(0)").hover(function () { $(this).addClass("RowMouseOver"); }, function () { $(this).removeClass("RowMouseOver"); });
                trs.dblclick(function () {
                    var aEdit = $(".f-write", this);
                    if (aEdit.length) aEdit[0].click();
                }).find("td:lt(3)").addClass("moveable").attr("title", "双击编辑过滤器；拖动调整顺序");
            }
        }
        function toDel() {
            return confirm('删除过滤器将导致引用它的数据无法打开，建议先查看并修改引用。\n\n确定删除吗？');
        }
        function reloadBar() {
            setTimeout(function () {
                try {
                    parent.leftFrame.reloadTabs('browse');
                } catch (e) { }
            }, 100);
        }
    </script>
    </form>
</body>
</html>