struct VS_INPUT
{
	vector position  : POSITION;
	vector diffuse :  COLOR0;
	float2  uv : TEXCOORD0;
};

struct VS_OUTPUT
{
	vector position : POSITION;
	vector diffuse  : COLOR0;
	float2  uv : TEXCOORD0;
	float2 bkuv:TEXCOORD1;
};

matrix modelViewProj;
float txwidth;
float txheight;

VS_OUTPUT main(VS_INPUT input)
{
	VS_OUTPUT Output = (VS_OUTPUT)0;
	Output.position  = mul(input.position, modelViewProj);
	Output.diffuse = input.diffuse;
	Output.uv = input.uv;
	
	float2 pos2 = Output.position.xy;
	pos2 = Output.position.xy*0.5f + 0.5f;
	pos2.y = 1.0f -pos2.y ;
	pos2.x+=0.5f/txwidth;
	pos2.y+=0.5f/txheight;
	Output.bkuv = pos2;
	return Output;
}
