/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.image;

import com.group_finity.mascot.image.ImagePair;
import com.group_finity.mascot.image.ImagePairs;
import com.group_finity.mascot.image.MascotImage;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImagePairLoader {
    public static void load(String name, Point center) throws IOException {
        if (ImagePairs.contains(name)) {
            return;
        }
        BufferedImage leftImage = ImageIO.read(ImagePairLoader.class.getResource(name));
        BufferedImage rightImage = ImagePairLoader.flip(leftImage);
        ImagePair ip = new ImagePair(new MascotImage(leftImage, center), new MascotImage(rightImage, new Point(rightImage.getWidth() - center.x, center.y)));
        ImagePairs.load(name, ip);
    }

    private static BufferedImage flip(BufferedImage src) {
        BufferedImage copy = new BufferedImage(src.getWidth(), src.getHeight(), src.getType() == 0 ? 2 : src.getType());
        for (int y = 0; y < src.getHeight(); ++y) {
            for (int x = 0; x < src.getWidth(); ++x) {
                copy.setRGB(copy.getWidth() - x - 1, y, src.getRGB(x, y));
            }
        }
        return copy;
    }
}

