# -*- coding:utf-8 -*-

# Speedflow Add-on
# Copyright (C) 2018 Cedric Lepiller aka Pitiwazou & Legigan Jeremy AKA Pistiwique and Stephen Leger
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# <pep8 compliant>

import bpy
from bpy.props import BoolProperty, StringProperty, IntProperty, PointerProperty, EnumProperty


class ModalPieMenuCollectionGroup(bpy.types.PropertyGroup):

    # active modifier index for companion
    active_index : IntProperty()

    # ref_object_name = StringProperty()
    # ref_object : bpy.props.PointerProperty(type=bpy.types.Object)
    ref_object = []
    ref_object_name = StringProperty()
    override_solidify_z_o : BoolProperty(default=False)



    # --------------------------------
    # Array 
    # --------------------------------
    array_name : StringProperty()
    
    # # --------------------------------
    # # Boolean
    # # --------------------------------
    #
    # previous_solver : StringProperty()
    
    # --------------------------------
    # Mirror 
    # --------------------------------
     
    mirror_name : StringProperty()
    
    # --------------------------------
    # Symmetrize 
    # --------------------------------
    symmetrize_dict = {}
    
    modal_name : StringProperty()

    # --------------------------------
    # Check Update
    # --------------------------------
    sf_update_check: BoolProperty(
        name="",
        default=False,
        description="Check For Updates"
    )

    sf_update_new_version: StringProperty(
        description="Updates Version"
    )

    update_available: BoolProperty(default=False)

    doc_intro: BoolProperty(
        name="",
        default=True
    )

    doc_workflow: BoolProperty(
        name="",
        default=False
    )

    doc_tutos: BoolProperty(
        name="",
        default=False
    )

    doc_youtube_tutos: BoolProperty(
        name="",
        default=False
    )

    doc_gum_market_tutos: BoolProperty(
        name="",
        default=False
    )

    doc_basics: BoolProperty(
        name="",
        default=False
    )

    doc_modals: BoolProperty(
        name="",
        default=False
    )

    doc_modals_array: BoolProperty(
        name="",
        default=False
    )

    doc_modals_bevel: BoolProperty(
        name="",
        default=False
    )

    doc_modals_boolean: BoolProperty(
        name="",
        default=False
    )

    doc_modals_curve: BoolProperty(
        name="",
        default=False
    )

    doc_modals_decimate: BoolProperty(
        name="",
        default=False
    )

    doc_modals_displace: BoolProperty(
        name="",
        default=False
    )

    doc_modals_edge_split: BoolProperty(
        name="",
        default=False
    )

    doc_modals_mirror: BoolProperty(
        name="",
        default=False
    )

    doc_modals_screw: BoolProperty(
        name="",
        default=False
    )

    doc_modals_shrinkwrap: BoolProperty(
        name="",
        default=False
    )

    doc_modals_simple_deform: BoolProperty(
        name="",
        default=False
    )

    doc_modals_solidify: BoolProperty(
        name="",
        default=False
    )

    doc_modals_subsurf: BoolProperty(
        name="",
        default=False
    )

    doc_modals_triangulate: BoolProperty(
        name="",
        default=False
    )

    doc_modals_wireframe: BoolProperty(
        name="",
        default=False
    )

    doc_modals_tubify: BoolProperty(
        name="",
        default=False
    )

def register():
    try:
        bpy.utils.register_class(ModalPieMenuCollectionGroup)
    except:
        print("ModalPieMenuCollectionGroup already registred")

    bpy.types.WindowManager.SF = PointerProperty(type=ModalPieMenuCollectionGroup)

def unregister():
    bpy.utils.unregister_class(ModalPieMenuCollectionGroup)
    del bpy.types.WindowManager.SF