import bpy
import bmesh
from bpy.types import Menu, Panel
from bpy.props import PointerProperty, StringProperty, BoolProperty, \
    EnumProperty, IntProperty, FloatProperty, FloatVectorProperty, \
    CollectionProperty, BoolVectorProperty


def primitives_default(default_enum):
    if default_enum == 'plane':
        bpy.ops.mesh.primitive_plane_add(True, size=2, enter_editmode=False)
    elif default_enum == 'cube':
        bpy.ops.mesh.primitive_cube_add(True, size=2, enter_editmode=False)
    elif default_enum == 'circle':
        bpy.ops.mesh.primitive_circle_add(True, vertices=16, radius=1, enter_editmode=False)
    elif default_enum == 'uv_sphere':
        bpy.ops.mesh.primitive_uv_sphere_add(True, segments=24, ring_count=12, radius=1, enter_editmode=False)
    elif default_enum == 'ico_sphere':
        bpy.ops.mesh.primitive_ico_sphere_add(True, radius=1, enter_editmode=False)
    elif default_enum == 'cylinder':
        bpy.ops.mesh.primitive_cylinder_add(True, vertices=24, radius=1, depth=2, enter_editmode=False)
    elif default_enum == 'cone':
        bpy.ops.mesh.primitive_cone_add(True, vertices=24, radius1=1, radius2=0, depth=2, enter_editmode=False)
    elif default_enum == 'torus':
        bpy.ops.mesh.primitive_torus_add(True, major_radius=1, minor_radius=0.25, abso_major_rad=1.25,abso_minor_rad=0.75)
    elif default_enum == 'grid':
        bpy.ops.mesh.primitive_grid_add(True, size=2, enter_editmode=False)
    elif default_enum == 'monkey':
        bpy.ops.mesh.primitive_monkey_add(True, size=2, enter_editmode=False)
    elif default_enum == 'bezier_curve':
        bpy.ops.curve.primitive_bezier_curve_add(True, radius=1)
    elif default_enum == 'bezier_circle':
        bpy.ops.curve.primitive_bezier_circle_add(True, radius=1)
    elif default_enum == 'empty':
        bpy.ops.object.empty_add(type='PLAIN_AXES')
    if default_enum == 'vertex':
        bpy.ops.mesh.primitive_plane_add(True, size=2, enter_editmode=False)
        bpy.ops.object.mode_set(mode='EDIT')
        bpy.ops.mesh.select_mode(use_extend=False, use_expand=False, type='VERT')
        bpy.ops.mesh.merge(type='CENTER')



def primitives_editable(editable_enum):
    # ---CUBE
    if editable_enum == 'cube':
        # Create vertex
        bpy.ops.mesh.primitive_plane_add(size=2, enter_editmode=False)
        new_prim = bpy.context.active_object
        new_prim.name = "Editable Cube"

        # Add Solidify
        solidify_modifier = new_prim.modifiers.new("Solidify", 'SOLIDIFY')
        solidify_modifier.thickness = 2
        solidify_modifier.use_even_offset = True
        solidify_modifier.use_quality_normals = True
        solidify_modifier.offset = 0

    # ---QUAD SPHERE
    if editable_enum == 'quad_sphere':
        # Create vertex
        bpy.ops.mesh.primitive_cube_add(size=1, enter_editmode=False)
        bpy.ops.object.mode_set(mode='EDIT')
        bpy.ops.mesh.select_mode(use_extend=False, use_expand=False, type='VERT')
        new_prim = bpy.context.active_object
        new_prim.name = "Editable Quad Sphere"

        # Add Vgroup
        bpy.ops.object.vertex_group_add()
        bpy.context.scene.tool_settings.vertex_group_weight = 1
        bpy.ops.object.vertex_group_assign()
        vgroups = new_prim.vertex_groups

        bpy.ops.object.mode_set(mode='OBJECT')

        # Add Displace Modifier
        disp_modifier = new_prim.modifiers.new("Displace", 'DISPLACE')
        disp_modifier.direction = 'NORMAL'
        disp_modifier.name = "Displace - %s" % (disp_modifier.direction)
        disp_modifier.strength = 1
        disp_modifier.mid_level = 0
        disp_modifier.vertex_group = vgroups.active.name
        disp_modifier.show_on_cage = True
        disp_modifier.show_in_editmode = True

        # Add Subsurf
        subsurf_modifier = new_prim.modifiers.new("Subsurf", 'SUBSURF')
        subsurf_modifier.levels = 3
        subsurf_modifier.name = "Subsurf - %s" % (subsurf_modifier.levels)

        # Add Solidify
        cast_modifier = new_prim.modifiers.new("Cast", 'CAST')
        cast_modifier.factor = 1

    # ---GRID
    elif editable_enum == 'grid':
        # Create vertex
        bpy.ops.mesh.primitive_plane_add(size=2, enter_editmode=False)
        new_prim = bpy.context.active_object
        new_prim.name = "Editable Grid"

        # Add Subsurf Modifier
        subsurf_modifier = new_prim.modifiers.new("Subsurf", 'SUBSURF')
        subsurf_modifier.levels = 3
        subsurf_modifier.name = "Subsurf - %s" % (subsurf_modifier.levels)
        subsurf_modifier.subdivision_type = 'SIMPLE'

        bpy.context.object.data.use_auto_smooth = True
        bpy.context.object.data.auto_smooth_angle = 0.523599

    # ---CIRCLE
    elif editable_enum == 'circle':
        # Create vertex
        bpy.ops.mesh.primitive_plane_add(size=2, enter_editmode=False)
        bpy.ops.object.mode_set(mode='EDIT')
        bpy.ops.mesh.select_mode(use_extend=False, use_expand=False, type='VERT')
        bpy.ops.mesh.merge(type='CENTER')
        new_prim = bpy.context.active_object
        new_prim.name = "Editable Circle"

        # Add Vgroup
        bpy.ops.object.vertex_group_add()
        bpy.context.scene.tool_settings.vertex_group_weight = 1
        bpy.ops.object.vertex_group_assign()
        vgroups = new_prim.vertex_groups

        bpy.ops.object.mode_set(mode='OBJECT')

        # Add Displace Modifier
        disp_modifier = new_prim.modifiers.new("Displace", 'DISPLACE')
        disp_modifier.direction = 'X'
        disp_modifier.name = "Displace - %s" % (disp_modifier.direction)
        disp_modifier.strength = 1
        disp_modifier.mid_level = 0
        disp_modifier.vertex_group = vgroups.active.name
        disp_modifier.show_on_cage = True
        disp_modifier.show_in_editmode = True

        # Add Screw Modifier
        screw_modifier = new_prim.modifiers.new("Screw", 'SCREW')
        screw_modifier.axis = 'Z'
        screw_modifier.name = "Screw_%s" % (screw_modifier.axis)
        screw_modifier.angle = 6.28319
        screw_modifier.use_normal_calculate = True
        screw_modifier.use_normal_flip = True
        screw_modifier.use_merge_vertices = True
        screw_modifier.render_steps = 32
        screw_modifier.steps = 32

    # ---SPHERE
    elif editable_enum == 'sphere':
        # Create vertex
        bpy.ops.mesh.primitive_plane_add(size=2, enter_editmode=False)
        bpy.ops.object.mode_set(mode='EDIT')
        bpy.ops.mesh.select_mode(use_extend=False, use_expand=False, type='VERT')
        bpy.ops.mesh.merge(type='CENTER')
        new_prim = bpy.context.active_object
        new_prim.name = "Editable Sphere"

        # Add Vgroup
        bpy.ops.object.vertex_group_add()
        bpy.context.scene.tool_settings.vertex_group_weight = 1
        bpy.ops.object.vertex_group_assign()
        vgroups = new_prim.vertex_groups

        bpy.ops.object.mode_set(mode='OBJECT')

        # Add Displace Modifier
        disp_modifier = new_prim.modifiers.new("Displace", 'DISPLACE')
        disp_modifier.name = "Displace - %s" % (disp_modifier.direction)
        disp_modifier.direction = 'Z'
        disp_modifier.mid_level = 0
        disp_modifier.vertex_group = vgroups.active.name
        disp_modifier.show_on_cage = True
        disp_modifier.show_in_editmode = True

        # Add Screw Modifier X
        screw_modifier = new_prim.modifiers.new("Screw", 'SCREW')
        screw_modifier.axis = 'X'
        screw_modifier.name = "Screw - %s" % (screw_modifier.axis)
        screw_modifier.angle = 3.14159
        screw_modifier.use_normal_calculate = True
        screw_modifier.use_normal_flip = False
        screw_modifier.use_merge_vertices = True
        screw_modifier.render_steps = 16
        screw_modifier.steps = 16

        # Add Screw Modifier Z
        screw_modifier = new_prim.modifiers.new("Screw", 'SCREW')
        screw_modifier.axis = 'Z'
        screw_modifier.name = "Screw - %s" % (screw_modifier.axis)
        screw_modifier.angle = 6.28319
        screw_modifier.use_normal_calculate = True
        screw_modifier.use_normal_flip = False
        screw_modifier.use_merge_vertices = True
        screw_modifier.render_steps = 24
        screw_modifier.steps = 24

    # ---CYLINDER
    elif editable_enum == 'cylinder':
        # Create vertex
        bpy.ops.mesh.primitive_plane_add(size=2, enter_editmode=False)
        bpy.ops.object.mode_set(mode='EDIT')
        bpy.ops.mesh.select_mode(use_extend=False, use_expand=False, type='VERT')
        bpy.ops.mesh.merge(type='CENTER')
        new_prim = bpy.context.active_object
        new_prim.name = "Editable Cylinder"

        bpy.ops.mesh.extrude_region_move(MESH_OT_extrude_region={"use_normal_flip": False, "mirror": False},
                                         TRANSFORM_OT_translate={"value": (0, 0, 0), "orient_type": 'GLOBAL',
                                                                 "orient_matrix": ((1, 0, 0), (0, 1, 0), (0, 0, 1)),
                                                                 "orient_matrix_type": 'GLOBAL',
                                                                 "constraint_axis": (True, False, False),
                                                                 "mirror": False, "use_proportional_edit": False,
                                                                 "proportional_edit_falloff": 'SMOOTH',
                                                                 "proportional_size": 1,
                                                                 "use_proportional_connected": False,
                                                                 "use_proportional_projected": False, "snap": False,
                                                                 "snap_target": 'CLOSEST', "snap_point": (0, 0, 0),
                                                                 "snap_align": False, "snap_normal": (0, 0, 0),
                                                                 "gpencil_strokes": False, "cursor_transform": False,
                                                                 "texture_space": False, "remove_on_cancel": False,
                                                                 "release_confirm": False, "use_accurate": False})

        # Add Vgroup
        bpy.ops.object.vertex_group_add()
        bpy.context.scene.tool_settings.vertex_group_weight = 1
        bpy.ops.object.vertex_group_assign()
        vgroups = new_prim.vertex_groups

        bpy.ops.object.mode_set(mode='OBJECT')

        # Add Displace Modifier
        disp_modifier = new_prim.modifiers.new("Displace", 'DISPLACE')
        disp_modifier.direction = 'X'
        disp_modifier.name = "Displace - %s" % (disp_modifier.direction)
        disp_modifier.strength = 1
        disp_modifier.mid_level = 0
        disp_modifier.vertex_group = vgroups.active.name
        disp_modifier.show_on_cage = True
        disp_modifier.show_in_editmode = True

        # Add Screw Modifier Z
        screw_modifier = new_prim.modifiers.new("Screw", 'SCREW')
        screw_modifier.axis = 'Z'
        screw_modifier.name = "Screw - %s" % (screw_modifier.axis)
        screw_modifier.angle = 6.28319
        screw_modifier.use_normal_calculate = True
        screw_modifier.use_normal_flip = True
        screw_modifier.use_merge_vertices = True
        screw_modifier.render_steps = 32
        screw_modifier.steps = 32

        # Add Solidify
        solidify_modifier = new_prim.modifiers.new("Solidify", 'SOLIDIFY')
        solidify_modifier.thickness = 2
        solidify_modifier.use_even_offset = True
        solidify_modifier.use_quality_normals = True
        solidify_modifier.offset = 0

    # ---TORUS
    elif editable_enum == 'torus':
        # Create vertex
        bpy.ops.mesh.primitive_plane_add(size=2, enter_editmode=False)
        bpy.ops.object.mode_set(mode='EDIT')
        bpy.ops.mesh.select_mode(use_extend=False, use_expand=False, type='VERT')
        bpy.ops.mesh.merge(type='CENTER')
        new_prim = bpy.context.active_object
        new_prim.name = "Editable Torus"

        # Add Vgroup
        bpy.ops.object.vertex_group_add()
        bpy.context.scene.tool_settings.vertex_group_weight = 1
        bpy.ops.object.vertex_group_assign()
        vgroups = new_prim.vertex_groups

        bpy.ops.object.mode_set(mode='OBJECT')

        # Add Displace Modifier
        disp_modifier = new_prim.modifiers.new("Displace", 'DISPLACE')
        disp_modifier.direction = 'X'
        disp_modifier.name = "Displace - %s" % (disp_modifier.direction)
        disp_modifier.strength = 0.25
        disp_modifier.mid_level = 0
        disp_modifier.vertex_group = vgroups.active.name
        disp_modifier.show_on_cage = True
        disp_modifier.show_in_editmode = True

        # Add Screw Modifier Y
        screw_modifier = new_prim.modifiers.new("Screw", 'SCREW')
        screw_modifier.axis = 'Y'
        screw_modifier.name = "Screw - %s" % (screw_modifier.axis)
        screw_modifier.angle = 6.28319
        screw_modifier.use_normal_calculate = True
        screw_modifier.use_normal_flip = False
        screw_modifier.use_merge_vertices = True
        screw_modifier.render_steps = 16
        screw_modifier.steps = 16

        # Add Displace Modifier 2
        disp_modifier = new_prim.modifiers.new("Displace", 'DISPLACE')
        disp_modifier.direction = 'X'
        disp_modifier.name = "Displace - %s" % (disp_modifier.direction)
        disp_modifier.strength = 1
        disp_modifier.mid_level = 0
        disp_modifier.vertex_group = vgroups.active.name
        disp_modifier.show_on_cage = True
        disp_modifier.show_in_editmode = True

        # Add Screw Modifier Z
        screw_modifier = new_prim.modifiers.new("Screw", 'SCREW')
        screw_modifier.axis = 'Z'
        screw_modifier.name = "Screw - %s" % (screw_modifier.axis)
        screw_modifier.angle = 6.28319
        screw_modifier.use_normal_calculate = True
        screw_modifier.use_normal_flip = False
        screw_modifier.use_merge_vertices = True
        screw_modifier.render_steps = 32
        screw_modifier.steps = 32

    # ---CONE
    elif editable_enum == 'cone':
        # Create vertex
        bpy.ops.mesh.primitive_plane_add(size=2, enter_editmode=False)
        bpy.ops.object.mode_set(mode='EDIT')
        bpy.ops.mesh.select_mode(use_extend=False, use_expand=False, type='VERT')
        bpy.ops.mesh.merge(type='CENTER')
        new_prim = bpy.context.active_object
        new_prim.name = "Editable Cone"

        bpy.ops.mesh.extrude_region_move(MESH_OT_extrude_region={"use_normal_flip": False, "mirror": False},
                                         TRANSFORM_OT_translate={"value": (1, 0, 0), "orient_type": 'GLOBAL',
                                                                 "orient_matrix": ((1, 0, 0), (0, 1, 0), (0, 0, 1)),
                                                                 "orient_matrix_type": 'GLOBAL',
                                                                 "constraint_axis": (True, False, False),
                                                                 "mirror": False, "use_proportional_edit": False,
                                                                 "proportional_edit_falloff": 'SMOOTH',
                                                                 "proportional_size": 1,
                                                                 "use_proportional_connected": False,
                                                                 "use_proportional_projected": False, "snap": False,
                                                                 "snap_target": 'CLOSEST', "snap_point": (0, 0, 0),
                                                                 "snap_align": False, "snap_normal": (0, 0, 0),
                                                                 "gpencil_strokes": False, "cursor_transform": False,
                                                                 "texture_space": False, "remove_on_cancel": False,
                                                                 "release_confirm": False, "use_accurate": False})

        # Add Vgroup
        bpy.ops.object.vertex_group_add()
        bpy.context.scene.tool_settings.vertex_group_weight = 1
        bpy.ops.object.vertex_group_assign()
        vgroup_x = new_prim.vertex_groups

        # Add Displace Modifier
        disp_modifier = new_prim.modifiers.new("Displace", 'DISPLACE')
        disp_modifier.direction = 'X'
        disp_modifier.name = "Displace - %s" % (disp_modifier.direction)
        disp_modifier.strength = 0
        disp_modifier.mid_level = 0
        disp_modifier.vertex_group = vgroup_x.active.name
        disp_modifier.show_on_cage = True
        disp_modifier.show_in_editmode = True

        bpy.ops.mesh.extrude_region_move(MESH_OT_extrude_region={"use_normal_flip": False, "mirror": False},
                                         TRANSFORM_OT_translate={"value": (0, 0, 2), "orient_type": 'GLOBAL',
                                                                 "orient_matrix": ((1, 0, 0), (0, 1, 0), (0, 0, 1)),
                                                                 "orient_matrix_type": 'GLOBAL',
                                                                 "constraint_axis": (False, False, True),
                                                                 "mirror": False, "use_proportional_edit": False,
                                                                 "proportional_edit_falloff": 'SMOOTH',
                                                                 "proportional_size": 1,
                                                                 "use_proportional_connected": False,
                                                                 "use_proportional_projected": False, "snap": False,
                                                                 "snap_target": 'CLOSEST', "snap_point": (0, 0, 0),
                                                                 "snap_align": False, "snap_normal": (0, 0, 0),
                                                                 "gpencil_strokes": False, "cursor_transform": False,
                                                                 "texture_space": False, "remove_on_cancel": False,
                                                                 "release_confirm": False, "use_accurate": False})

        bpy.ops.transform.translate(value=(-1, 0, 0), orient_type='GLOBAL',
                                    orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL',
                                    constraint_axis=(True, False, False), mirror=True, use_proportional_edit=False,
                                    proportional_edit_falloff='SMOOTH', proportional_size=1,
                                    use_proportional_connected=False, use_proportional_projected=False)

        bpy.ops.object.vertex_group_remove_from()

        # Add Vgroup
        bpy.ops.object.vertex_group_add()
        bpy.context.scene.tool_settings.vertex_group_weight = 1
        bpy.ops.object.vertex_group_assign()
        vgroup_z = new_prim.vertex_groups

        # Add Displace Modifier
        disp_modifier_deux = new_prim.modifiers.new("Displace", 'DISPLACE')
        disp_modifier_deux.direction = 'Z'
        disp_modifier.name = "Displace - %s" % (disp_modifier.direction)
        disp_modifier_deux.strength = 0
        disp_modifier_deux.mid_level = 0
        disp_modifier_deux.vertex_group = vgroup_z.active.name
        disp_modifier_deux.show_on_cage = True
        disp_modifier_deux.show_in_editmode = True

        bpy.ops.object.mode_set(mode='OBJECT')

        # Add Screw Modifier Z
        screw_modifier = new_prim.modifiers.new("Screw", 'SCREW')
        screw_modifier.axis = 'Z'
        screw_modifier.name = "Screw - %s" % (screw_modifier.axis)
        screw_modifier.angle = 6.28319
        screw_modifier.use_normal_calculate = True
        screw_modifier.use_normal_flip = True
        screw_modifier.use_merge_vertices = True
        screw_modifier.use_smooth_shade = True
        screw_modifier.render_steps = 32
        screw_modifier.steps = 32

    # ---TUBE
    elif editable_enum == 'tube':
        # Create vertex
        bpy.ops.mesh.primitive_plane_add(size=2, enter_editmode=False)
        bpy.ops.object.mode_set(mode='EDIT')
        bpy.ops.mesh.select_mode(use_extend=False, use_expand=False, type='VERT')
        bpy.ops.mesh.merge(type='CENTER')
        new_prim = bpy.context.active_object
        new_prim.name = "Editable Tube"

        # Add Vgroup
        bpy.ops.object.vertex_group_add()
        bpy.context.scene.tool_settings.vertex_group_weight = 1
        bpy.ops.object.vertex_group_assign()
        vgroup_min = new_prim.vertex_groups

        # Add Displace Modifier
        disp_modifier = new_prim.modifiers.new("Displace", 'DISPLACE')
        disp_modifier.direction = 'X'
        disp_modifier.name = "Displace - %s" % (disp_modifier.direction)
        disp_modifier.strength = 0
        disp_modifier.mid_level = 0
        disp_modifier.vertex_group = vgroup_min.active.name
        disp_modifier.show_on_cage = True
        disp_modifier.show_in_editmode = True

        bpy.ops.mesh.extrude_region_move(MESH_OT_extrude_region={"use_normal_flip": False, "mirror": False},
                                         TRANSFORM_OT_translate={"value": (0.5, 0, 0), "orient_type": 'GLOBAL',
                                                                 "orient_matrix": ((1, 0, 0), (0, 1, 0), (0, 0, 1)),
                                                                 "orient_matrix_type": 'GLOBAL',
                                                                 "constraint_axis": (True, False, False),
                                                                 "mirror": False, "use_proportional_edit": False,
                                                                 "proportional_edit_falloff": 'SMOOTH',
                                                                 "proportional_size": 1,
                                                                 "use_proportional_connected": False,
                                                                 "use_proportional_projected": False, "snap": False,
                                                                 "snap_target": 'CLOSEST', "snap_point": (0, 0, 0),
                                                                 "snap_align": False, "snap_normal": (0, 0, 0),
                                                                 "gpencil_strokes": False, "cursor_transform": False,
                                                                 "texture_space": False, "remove_on_cancel": False,
                                                                 "release_confirm": False, "use_accurate": False})

        bpy.ops.object.vertex_group_remove_from()

        # Add Vgroup
        bpy.ops.object.vertex_group_add()
        bpy.context.scene.tool_settings.vertex_group_weight = 1
        bpy.ops.object.vertex_group_assign()
        vgroup_max = new_prim.vertex_groups

        # Add Displace Modifier
        disp_modifier_deux = new_prim.modifiers.new("Displace", 'DISPLACE')
        disp_modifier_deux.direction = 'X'
        disp_modifier.name = "Displace - %s" % (disp_modifier.direction)
        disp_modifier_deux.strength = 0
        disp_modifier_deux.mid_level = 0
        disp_modifier_deux.vertex_group = vgroup_max.active.name
        disp_modifier_deux.show_on_cage = True
        disp_modifier_deux.show_in_editmode = True

        bpy.ops.mesh.select_all(action='SELECT')

        # Add Vgroup
        bpy.ops.object.vertex_group_add()
        bpy.context.scene.tool_settings.vertex_group_weight = 1
        bpy.ops.object.vertex_group_assign()
        vgroup_all = new_prim.vertex_groups

        # Add Displace Modifier
        disp_modifier_deux = new_prim.modifiers.new("Displace", 'DISPLACE')
        disp_modifier_deux.direction = 'X'
        disp_modifier.name = "Displace - %s" % (disp_modifier.direction)
        disp_modifier_deux.strength = 0.5
        disp_modifier_deux.mid_level = 0
        disp_modifier_deux.vertex_group = vgroup_all.active.name
        disp_modifier_deux.show_on_cage = True
        disp_modifier_deux.show_in_editmode = True

        bpy.ops.object.mode_set(mode='OBJECT')

        # Add Screw Modifier Z
        screw_modifier = new_prim.modifiers.new("Screw", 'SCREW')
        screw_modifier.axis = 'Z'
        screw_modifier.name = "Screw - %s" % (screw_modifier.axis)
        screw_modifier.angle = 6.28319
        screw_modifier.use_normal_calculate = True
        screw_modifier.use_normal_flip = True
        screw_modifier.use_merge_vertices = True
        screw_modifier.render_steps = 32
        screw_modifier.steps = 32

        # Add Solidify
        solidify_modifier = new_prim.modifiers.new("Solidify", 'SOLIDIFY')
        solidify_modifier.thickness = 2
        solidify_modifier.use_even_offset = True
        solidify_modifier.use_quality_normals = True
        solidify_modifier.offset = 0


    # ---CAPSULE
    elif editable_enum == 'capsule':
        # Create vertex
        bpy.ops.mesh.primitive_plane_add(size=2, enter_editmode=False)
        bpy.ops.object.mode_set(mode='EDIT')
        bpy.ops.mesh.select_mode(use_extend=False, use_expand=False, type='VERT')
        bpy.ops.mesh.merge(type='CENTER')
        new_prim = bpy.context.active_object
        new_prim.name = "Editable Capsule"

        bpy.ops.mesh.extrude_region_move(MESH_OT_extrude_region={"use_normal_flip": False, "mirror": False},
                                         TRANSFORM_OT_translate={"value": (0, 0, 0), "orient_type": 'GLOBAL',
                                                                 "orient_matrix": ((1, 0, 0), (0, 1, 0), (0, 0, 1)),
                                                                 "orient_matrix_type": 'GLOBAL',
                                                                 "constraint_axis": (True, False, False),
                                                                 "mirror": False, "use_proportional_edit": False,
                                                                 "proportional_edit_falloff": 'SMOOTH',
                                                                 "proportional_size": 1,
                                                                 "use_proportional_connected": False,
                                                                 "use_proportional_projected": False, "snap": False,
                                                                 "snap_target": 'CLOSEST', "snap_point": (0, 0, 0),
                                                                 "snap_align": False, "snap_normal": (0, 0, 0),
                                                                 "gpencil_strokes": False, "cursor_transform": False,
                                                                 "texture_space": False, "remove_on_cancel": False,
                                                                 "release_confirm": False, "use_accurate": False})

        # Add Vgroup
        bpy.ops.object.vertex_group_add()
        bpy.context.scene.tool_settings.vertex_group_weight = 1
        bpy.ops.object.vertex_group_assign()
        vgroups = new_prim.vertex_groups

        bpy.ops.object.mode_set(mode='OBJECT')

        # Add Displace Modifier
        disp_modifier = new_prim.modifiers.new("Displace", 'DISPLACE')
        disp_modifier.direction = 'X'
        disp_modifier.name = "Displace - %s" % (disp_modifier.direction)
        disp_modifier.strength = 0.5
        disp_modifier.mid_level = 0
        disp_modifier.vertex_group = vgroups.active.name
        disp_modifier.show_on_cage = True
        disp_modifier.show_in_editmode = True

        # Add Screw Modifier Z
        screw_modifier = new_prim.modifiers.new("Screw", 'SCREW')
        screw_modifier.axis = 'Z'
        screw_modifier.name = "Screw - %s" % (screw_modifier.axis)
        screw_modifier.angle = 6.28319
        screw_modifier.use_normal_calculate = True
        screw_modifier.use_normal_flip = True
        screw_modifier.use_merge_vertices = True
        screw_modifier.render_steps = 32
        screw_modifier.steps = 32

        # Add Solidify
        solidify_modifier = new_prim.modifiers.new("Solidify", 'SOLIDIFY')
        solidify_modifier.thickness = 2
        solidify_modifier.use_even_offset = True
        solidify_modifier.use_quality_normals = True
        solidify_modifier.offset = 0

        # bevel
        new_bevel = new_prim.modifiers.new("Bevel", 'BEVEL')
        new_bevel.limit_method = 'ANGLE'
        new_bevel.name = "Bevel - %s" % (new_bevel.limit_method)
        new_bevel.width = 0.48
        new_bevel.segments = 6
        new_bevel.profile = 0.5
        new_bevel.use_only_vertices = False
        new_bevel.angle_limit = 1.535889744758606
        new_bevel.use_clamp_overlap = False

    # ---LINE
    elif editable_enum == 'line':
        bpy.ops.mesh.primitive_plane_add(size=2, enter_editmode=False)
        bpy.ops.object.mode_set(mode='EDIT')
        bpy.ops.mesh.select_mode(use_extend=False, use_expand=False, type='VERT')

        bpy.ops.transform.resize(value=(1, 0, 1), orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)),
                                 orient_matrix_type='GLOBAL', constraint_axis=(False, True, False), mirror=True,
                                 use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1,
                                 use_proportional_connected=False, use_proportional_projected=False)
        bpy.ops.mesh.dissolve_verts()
        bpy.ops.object.mode_set(mode='OBJECT')
        new_prim = bpy.context.active_object
        new_prim.name = "Editable Line"

        # Add Screw Modifier Z
        screw_modifier = new_prim.modifiers.new("Screw", 'SCREW')
        screw_modifier.axis = 'Z'
        screw_modifier.name = "Screw - %s" % (screw_modifier.axis)
        screw_modifier.screw_offset = 1
        screw_modifier.angle = 0
        screw_modifier.use_normal_calculate = True
        screw_modifier.use_normal_flip = True
        screw_modifier.use_merge_vertices = True
        screw_modifier.render_steps = 1
        screw_modifier.steps = 1

        # Add Solidify
        solidify_modifier = new_prim.modifiers.new("Solidify", 'SOLIDIFY')
        solidify_modifier.thickness = 0.2
        solidify_modifier.use_even_offset = True
        solidify_modifier.use_quality_normals = True
        solidify_modifier.offset = 0

        # Add Displace Modifier
        disp_modifier = new_prim.modifiers.new("Displace", 'DISPLACE')
        disp_modifier.direction = 'Z'
        disp_modifier.name = "Displace - %s" % (disp_modifier.direction)
        disp_modifier.strength = -0.2
        disp_modifier.mid_level = 0
        disp_modifier.show_on_cage = True
        disp_modifier.show_in_editmode = True

    # Normals
    bpy.context.object.data.use_auto_smooth = True
    bpy.context.object.data.auto_smooth_angle = 0.523599
    bpy.ops.object.shade_smooth()

    return editable_enum


def primitives_screw(screw_enum):
    SFC_prim = bpy.context.window_manager.SFC_prim

    # Mesh Creation
    verts = []
    faces = []
    edges = []
    mesh_data = bpy.data.meshes.new("cube_mesh_data")

    if screw_enum == 'screw_1':
        verts = [(0, 0, -1), (1, 0, -1), (1, 0, 1), (0, 0, 1)]
        mesh_data.from_pydata(verts, [(0, 1), (1, 2), (2, 3)], faces)

    if screw_enum == 'screw_2':
        verts = [(0, 0, 0), (1, 0, 0), (1, 0, 2), (2, 0, 3), (2, 0, 4), (0, 0, 4)]
        mesh_data.from_pydata(verts, [(0, 1), (1, 2), (2, 3), (3, 4), (4, 5)], faces)

    if screw_enum == 'screw_3':
        verts = [(0, 0, 0), (1, 0, 0), (1, 0, 2), (2, 0, 2), (2, 0, 3), (0, 0, 3)]
        mesh_data.from_pydata(verts, [(0, 1), (1, 2), (2, 3), (3, 4), (4, 5)], faces)

    if screw_enum == 'screw_4':
        verts = [(0, 0, 0), (1, 0, 0), (1, 0, 1), (2, 0, 2), (0, 0, 2)]
        mesh_data.from_pydata(verts, [(0, 1), (1, 2), (2, 3), (3, 4)], faces)

    if screw_enum == 'screw_5':
        verts = [(0, 0, 0), (1, 0, 0), (2, 0, 1), (0, 0, 1)]
        mesh_data.from_pydata(verts, [(0, 1), (1, 2), (2, 3)], faces)
    #        mesh_data.from_pydata(verts, [(0,1), (1,2), (2,3)], [(0,1,2,3)]) # pour faire une face

    if screw_enum == 'screw_6':
        verts = [(0, 0, 0)]
        mesh_data.from_pydata(verts, edges, faces)
        SFC_prim.screw_mode = True

    if screw_enum == 'screw_7':
        verts = [(0, 0, 0)]
        mesh_data.from_pydata(verts, edges, faces)

    mesh_data.update()

    screw = bpy.data.objects.new("Screw", mesh_data)

    scene = bpy.context.scene
    scene = bpy.context.view_layer.active_layer_collection.collection
    scene.objects.link(screw)

    screw.select_set(state=True)
    bpy.context.view_layer.objects.active = screw

    if screw_enum == 'screw_1':
        bpy.ops.transform.resize(value=(0.5, 0.5, 0.5), orient_type='GLOBAL',
                                 orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL')
        bpy.ops.transform.translate(value=(0, 0, -0.4), orient_type='GLOBAL',
                                    orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL',
                                    constraint_axis=(False, False, True))

    elif screw_enum == 'screw_2':
        bpy.ops.transform.resize(value=(0.5, 0.5, 0.5), orient_type='GLOBAL',
                                 orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL')
        bpy.ops.transform.translate(value=(0, 0, -1.8), orient_type='GLOBAL',
                                    orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL',
                                    constraint_axis=(False, False, True))

    elif screw_enum == 'screw_3':
        bpy.ops.transform.resize(value=(0.5, 0.5, 0.5), orient_type='GLOBAL',
                                 orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL')
        bpy.ops.transform.translate(value=(0, 0, -1.4), orient_type='GLOBAL',
                                    orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL',
                                    constraint_axis=(False, False, True))

    elif screw_enum == 'screw_4':
        bpy.ops.transform.resize(value=(0.5, 0.5, 0.5), orient_type='GLOBAL',
                                 orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL')
        bpy.ops.transform.translate(value=(0, 0, -0.7), orient_type='GLOBAL',
                                    orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL',
                                    constraint_axis=(False, False, True))

    elif screw_enum == 'screw_5':
        bpy.ops.transform.resize(value=(0.5, 0.5, 0.5), orient_type='GLOBAL',
                                 orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL')
        bpy.ops.transform.translate(value=(0, 0, -0.2), orient_type='GLOBAL',
                                    orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL',
                                    constraint_axis=(False, False, True))
    bpy.ops.object.transform_apply(location=True, rotation=False, scale=True)

    new_screw = screw.modifiers.new("Screw", 'SCREW')
    new_screw.axis = 'Z'
    new_screw.name = "Screw - %s" % (new_screw.axis)
    new_screw.use_normal_calculate = True
    new_screw.use_smooth_shade = True
    new_screw.use_normal_flip = True
    new_screw.steps = 32
    new_screw.render_steps = 32
    new_screw.use_merge_vertices = True
    new_screw.show_expanded = False

    if SFC_prim.screw_mode:
        new_solidify = screw.modifiers.new("Solidify", 'SOLIDIFY')
        new_solidify.thickness = 0.2
        new_solidify.offset = 0.9
        new_solidify.use_even_offset = True

        bpy.ops.object.mode_set(mode='EDIT')

        bpy.ops.mesh.extrude_region_move(MESH_OT_extrude_region={"use_normal_flip": False, "mirror": False},
                                         TRANSFORM_OT_translate={"value": (0.1, 0, 0), "orient_type": 'GLOBAL',
                                                                 "orient_matrix": ((1, 0, 0), (0, 1, 0), (0, 0, 1)),
                                                                 "orient_matrix_type": 'GLOBAL',
                                                                 "constraint_axis": (True, False, False),
                                                                 "mirror": False, "use_proportional_edit": False,
                                                                 "proportional_edit_falloff": 'SMOOTH',
                                                                 "proportional_size": 1,
                                                                 "use_proportional_connected": False,
                                                                 "use_proportional_projected": False, "snap": False,
                                                                 "snap_target": 'CLOSEST', "snap_point": (0, 0, 0),
                                                                 "snap_align": False, "snap_normal": (0, 0, 0),
                                                                 "gpencil_strokes": False, "cursor_transform": False,
                                                                 "texture_space": False, "remove_on_cancel": False,
                                                                 "release_confirm": False, "use_accurate": False})

        # Add Vgroup
        bpy.ops.object.vertex_group_add()
        bpy.context.scene.tool_settings.vertex_group_weight = 1
        bpy.ops.object.vertex_group_assign()
        vgroups = screw.vertex_groups

        bpy.ops.object.mode_set(mode='OBJECT')

        # Add Displace Modifier
        disp_modifier = screw.modifiers.new("Displace", 'DISPLACE')
        disp_modifier.direction = 'X'
        disp_modifier.name = "Displace - %s" % (disp_modifier.direction)
        disp_modifier.strength = 0.01
        disp_modifier.mid_level = 0
        disp_modifier.vertex_group = vgroups.active.name
        disp_modifier.show_on_cage = True
        disp_modifier.show_in_editmode = True
        disp_modifier.show_viewport = True

        bpy.ops.object.modifier_move_up(modifier=disp_modifier.name)
        bpy.ops.object.modifier_move_up(modifier=disp_modifier.name)

    bpy.context.object.data.use_auto_smooth = True
    bpy.context.object.data.auto_smooth_angle = 0.523599
    bpy.ops.object.shade_smooth()

    return screw_enum


def primitives_custom(custom_enum):
    # Rounded Cube
    if custom_enum == 'rounded_cube':
        bpy.ops.mesh.primitive_cube_add(True, enter_editmode=False)
        new_prim = bpy.context.active_object
        new_prim.name = "Custom Rounded Cube"

        # bevel
        new_bevel = new_prim.modifiers.new("Bevel", 'BEVEL')
        new_bevel.limit_method = 'ANGLE'
        new_bevel.name = "Bevel - %s" % (new_bevel.limit_method)
        new_bevel.width = 0.3
        new_bevel.segments = 6
        new_bevel.profile = 0.5
        new_bevel.use_only_vertices = False
        new_bevel.angle_limit = 1.535889744758606
        new_bevel.use_clamp_overlap = False

    # Rounded Plane
    if custom_enum == 'rounded_plane':
        bpy.ops.mesh.primitive_plane_add(True, enter_editmode=False)
        new_prim = bpy.context.active_object
        new_prim.name = "Custom Rounded Plane"

        bpy.ops.object.mode_set(mode='EDIT')
        bpy.ops.mesh.select_all(action='SELECT')
        bpy.ops.mesh.subdivide(quadcorner='INNERVERT')
        bpy.ops.mesh.region_to_loop()
        bpy.ops.mesh.select_less(use_face_step=False)

        # Add Vgroup
        bpy.ops.object.vertex_group_add()
        bpy.context.scene.tool_settings.vertex_group_weight = 1
        bpy.ops.object.vertex_group_assign()
        vgroup = new_prim.vertex_groups

        # bevel
        new_bevel = new_prim.modifiers.new("Bevel", 'BEVEL')
        new_bevel.limit_method = 'VGROUP'
        new_bevel.name = "Bevel - %s" % (new_bevel.limit_method)
        new_bevel.width = 0.4
        new_bevel.segments = 6
        new_bevel.profile = 0.5
        new_bevel.use_only_vertices = True
        new_bevel.angle_limit = 1.535889744758606
        new_bevel.use_clamp_overlap = False
        new_bevel.vertex_group = vgroup.active.name

        # Solidify
        new_solidify = new_prim.modifiers.new("Solidify", 'SOLIDIFY')
        new_solidify.thickness = 2
        new_solidify.use_even_offset = True
        new_solidify.use_quality_normals = True
        new_solidify.offset = 0

    # Rounded Plane Round
    if custom_enum == 'rounded_plane_round':
        bpy.ops.mesh.primitive_plane_add(True, enter_editmode=False)
        new_prim = bpy.context.active_object
        new_prim.name = "Custom Rounded Plane Round"

        bpy.ops.object.mode_set(mode='EDIT')
        bpy.ops.mesh.select_all(action='SELECT')
        bpy.ops.mesh.subdivide(quadcorner='INNERVERT')
        bpy.ops.mesh.region_to_loop()
        bpy.ops.mesh.select_less(use_face_step=False)

        # Add Vgroup
        bpy.ops.object.vertex_group_add()
        bpy.context.scene.tool_settings.vertex_group_weight = 1
        bpy.ops.object.vertex_group_assign()
        vgroup = new_prim.vertex_groups

        # bevel
        new_bevel = new_prim.modifiers.new("Bevel", 'BEVEL')
        new_bevel.limit_method = 'VGROUP'
        new_bevel.name = "Bevel - %s" % (new_bevel.limit_method)
        new_bevel.width = 0.4
        new_bevel.segments = 6
        new_bevel.profile = 0.5
        new_bevel.use_only_vertices = True
        new_bevel.angle_limit = 1.535889744758606
        new_bevel.use_clamp_overlap = False
        new_bevel.vertex_group = vgroup.active.name

        # Solidify
        new_solidify = new_prim.modifiers.new("Solidify", 'SOLIDIFY')
        new_solidify.thickness = 2
        new_solidify.use_even_offset = True
        new_solidify.use_quality_normals = True
        new_solidify.offset = 0

        # bevel round
        new_bevel_round = new_prim.modifiers.new("Bevel", 'BEVEL')
        new_bevel_round.limit_method = 'ANGLE'
        new_bevel.name = "Bevel - %s" % (new_bevel.limit_method)
        new_bevel_round.width = 0.15
        new_bevel_round.segments = 4
        new_bevel_round.profile = 0.5
        new_bevel_round.use_only_vertices = False
        new_bevel_round.angle_limit = 1.535889744758606
        new_bevel_round.use_clamp_overlap = False

    # Rounded Plane 2
    if custom_enum == 'rounded_plane_2':
        bpy.ops.mesh.primitive_plane_add(True, enter_editmode=False)
        new_prim = bpy.context.active_object
        new_prim.name = "Custom Rounded Plane 2"

        bpy.ops.object.mode_set(mode='EDIT')
        bpy.ops.mesh.select_all(action='SELECT')
        bpy.ops.mesh.subdivide(quadcorner='INNERVERT')
        bpy.ops.mesh.region_to_loop()
        bpy.ops.mesh.select_less(use_face_step=False)

        # Add Vgroup
        bpy.ops.object.vertex_group_add()
        bpy.context.scene.tool_settings.vertex_group_weight = 1
        bpy.ops.object.vertex_group_assign()
        vgroup = new_prim.vertex_groups

        # bevel
        new_bevel = new_prim.modifiers.new("Bevel", 'BEVEL')
        new_bevel.limit_method = 'VGROUP'
        new_bevel.name = "Bevel - %s" % (new_bevel.limit_method)
        new_bevel.width = 0.4
        new_bevel.segments = 6
        new_bevel.profile = 0.5
        new_bevel.use_only_vertices = True
        # new_bevel.angle_limit = 1.535889744758606
        new_bevel.use_clamp_overlap = False
        new_bevel.vertex_group = vgroup.active.name

        # Solidify
        new_solidify = new_prim.modifiers.new("Solidify", 'SOLIDIFY')
        new_solidify.thickness = 2
        new_solidify.use_even_offset = True
        new_solidify.use_quality_normals = True
        new_solidify.offset = 0.9

        # bevel round
        new_bevel_round = new_prim.modifiers.new("Bevel", 'BEVEL')
        new_bevel_round.limit_method = 'ANGLE'
        new_bevel.name = "Bevel - %s" % (new_bevel.limit_method)
        new_bevel_round.width = 0.15
        new_bevel_round.segments = 1
        new_bevel_round.profile = 0.5
        new_bevel_round.use_only_vertices = False
        new_bevel_round.angle_limit = 1.535889744758606
        new_bevel_round.use_clamp_overlap = False

    # Cross
    if custom_enum == 'cross':
        bpy.ops.mesh.primitive_plane_add(True, enter_editmode=False)
        new_prim = bpy.context.active_object
        new_prim.name = "Custom Cross"

        # bevel
        new_bevel = new_prim.modifiers.new("Bevel", 'BEVEL')
        new_bevel.limit_method = 'ANGLE'
        new_bevel.name = "Bevel - %s" % (new_bevel.limit_method)
        new_bevel.width = 0.6
        new_bevel.segments = 2
        new_bevel.profile = 0.0
        new_bevel.use_only_vertices = True
        new_bevel.angle_limit = 1.535889744758606
        new_bevel.use_clamp_overlap = False

        # Solidify
        new_solidify = new_prim.modifiers.new("Solidify", 'SOLIDIFY')
        new_solidify.thickness = 2
        new_solidify.use_even_offset = True
        new_solidify.use_quality_normals = True
        new_solidify.offset = 0

    # Rounded Cross
    if custom_enum == 'rounded_cross':
        bpy.ops.mesh.primitive_plane_add(True, enter_editmode=False)
        new_prim = bpy.context.active_object
        new_prim.name = "Custom Rounded Cross"

        # bevel
        new_bevel = new_prim.modifiers.new("Bevel", 'BEVEL')
        new_bevel.limit_method = 'ANGLE'
        new_bevel.name = "Bevel - %s" % (new_bevel.limit_method)
        new_bevel.width = 0.6
        new_bevel.segments = 2
        new_bevel.profile = 0.0
        new_bevel.use_only_vertices = True
        new_bevel.angle_limit = 1.535889744758606
        new_bevel.use_clamp_overlap = False

        # bevel round
        new_bevel_round = new_prim.modifiers.new("Bevel", 'BEVEL')
        new_bevel_round.limit_method = 'ANGLE'
        new_bevel.name = "Bevel - %s" % (new_bevel.limit_method)
        new_bevel_round.width = 0.15
        new_bevel_round.segments = 4
        new_bevel_round.profile = 0.5
        new_bevel_round.use_only_vertices = True
        new_bevel_round.angle_limit = 1.535889744758606
        new_bevel_round.use_clamp_overlap = False

        # Solidify
        new_solidify = new_prim.modifiers.new("Solidify", 'SOLIDIFY')
        new_solidify.thickness = 2
        new_solidify.use_even_offset = True
        new_solidify.use_quality_normals = True
        new_solidify.offset = 0

    # Long Cylinder
    if custom_enum == 'long_cylinder':
        bpy.ops.mesh.primitive_plane_add(True, enter_editmode=False)
        new_prim = bpy.context.active_object
        new_prim.name = "Custom Long Rounded Plane"

        bpy.ops.transform.resize(value=(1, 2, 1))
        bpy.ops.object.transform_apply(location=False, rotation=False, scale=True)

        bpy.ops.object.mode_set(mode='EDIT')
        bpy.ops.mesh.select_all(action='SELECT')
        bpy.ops.mesh.subdivide(quadcorner='INNERVERT')
        bpy.ops.mesh.region_to_loop()
        bpy.ops.mesh.select_less(use_face_step=False)

        # Add Vgroup
        bpy.ops.object.vertex_group_add()
        bpy.context.scene.tool_settings.vertex_group_weight = 1
        bpy.ops.object.vertex_group_assign()
        vgroup = new_prim.vertex_groups

        # bevel
        new_bevel = new_prim.modifiers.new("Bevel", 'BEVEL')
        new_bevel.limit_method = 'VGROUP'
        new_bevel.name = "Bevel - %s" % (new_bevel.limit_method)
        new_bevel.width = 0.888
        new_bevel.segments = 14
        new_bevel.profile = 0.5
        new_bevel.use_only_vertices = True
        # new_bevel.angle_limit = 1.535889744758606
        new_bevel.use_clamp_overlap = True
        new_bevel.vertex_group = vgroup.active.name

        # Solidify
        new_solidify = new_prim.modifiers.new("Solidify", 'SOLIDIFY')
        new_solidify.thickness = 2
        new_solidify.use_even_offset = True
        new_solidify.use_quality_normals = True
        new_solidify.offset = 0

    new_prim = bpy.context.object
    if new_prim.mode == 'EDIT':
        bpy.ops.mesh.select_all(action='SELECT')
    bpy.ops.object.mode_set(mode='OBJECT')
    bpy.context.object.data.use_auto_smooth = True
    bpy.context.object.data.auto_smooth_angle = 0.523599
    bpy.ops.object.shade_smooth()
    return custom_enum


###################
## ALIGN TO VIEW ##
###################
# def view3d_find(return_area=False):
#     # returns first 3d view, normally we get from context
#     for area in bpy.context.window.screen.areas:
#         if area.type == 'VIEW_3D':
#             v3d = area.spaces[0]
#             rv3d = v3d.region_3d
#             for region in area.regions:
#                 if region.type == 'WINDOW':
#                     if return_area: return region, rv3d, v3d, area
#                     return region, rv3d, v3d
#     return None, None
#
#
# r3d, rv3d, v3d = view3d_find()

# Cursor Tools
class SFC_OT_curve_line(bpy.types.Operator):
    bl_idname = "sfc.cursor_line"
    bl_label = "Cursor Tools"
    bl_description = "Cursor Line"
    bl_options = {"REGISTER"}

    @classmethod
    def poll(cls, context):
        return True

    def execute(self, context):
        bpy.ops.curve.primitive_bezier_curve_add(radius=1, enter_editmode=True, align='WORLD')
        bpy.ops.curve.delete(type='VERT')
        bpy.ops.object.mode_set(mode = 'OBJECT')
        bpy.ops.object.transform_apply(location=True, rotation=True, scale=True)
        bpy.ops.object.mode_set(mode = 'EDIT')

        bpy.context.space_data.overlay.show_curve_normals = False

        # bpy.ops.curve.draw('INVOKE_DEFAULT')
        bpy.ops.curve.draw('INVOKE_DEFAULT', error_threshold=0.15, fit_method='REFIT', corner_angle=70, use_cyclic=False, stroke=[],
                           wait_for_input=True)

        return {"FINISHED"}


# Cursor Tools
class SFC_OT_cursor_tools(bpy.types.Operator):
    bl_idname = "sfc.cursor_tools"
    bl_label = "Cursor Tools"
    bl_description = "Cursor Tools"
    bl_options = {"REGISTER"}

    @classmethod
    def poll(cls, context):
        return True

    cursor_tools: EnumProperty(
        items=(('copy_cursor_rot', "copy Cursor Rotation", ""),
               ('selection_to_cursor', "Selection To Cursor", ""),
               ('cursor_to_selection_rot', "Cursor To Selection + Rot", ""),
               ('align_view_to_cursor_rot', "Align View To Cursor Rotation", ""),
               ('align_cursor_to_object_rot', "Align Cursor To Object Rotation", ""),),
        default='copy_cursor_rot')

    def execute(self, context):
        act_obj = context.active_object
        mode = act_obj.mode
        cursor_rot = bpy.context.scene.cursor.rotation_euler.copy()

        if self.cursor_tools == 'copy_cursor_rot':
            bpy.context.object.rotation_euler = cursor_rot

        elif self.cursor_tools == 'selection_to_cursor':
            bpy.context.object.rotation_euler = cursor_rot
            bpy.ops.view3d.snap_selected_to_cursor(use_offset=False)

        elif self.cursor_tools == 'align_view_to_cursor_rot':

            edit_mode = False
            if act_obj.mode !='OBJECT':
                edit_mode = True
                bpy.ops.object.mode_set(mode='OBJECT')
            bpy.ops.object.select_all(action='DESELECT')

            bpy.ops.mesh.primitive_plane_add(size=2, enter_editmode=False)
            new_prim = bpy.context.active_object
            bpy.context.object.rotation_euler = cursor_rot
            bpy.ops.object.mode_set(mode='EDIT')
            bpy.ops.mesh.select_mode(use_extend=False, use_expand=False, type='FACE')

            bpy.ops.object.mode_set(mode='OBJECT')
            bpy.ops.view3d.view_axis(type='TOP', align_active=True)
            bpy.ops.view3d.view_persportho()

            bpy.data.objects.remove(new_prim, do_unlink=True)

            bpy.ops.object.delete(use_global=False)

            bpy.context.view_layer.objects.active = act_obj
            act_obj.select_set(state=True)
            if edit_mode:
                bpy.ops.object.mode_set(mode='EDIT')

        elif self.cursor_tools == 'align_cursor_to_object_rot':
            bpy.context.scene.cursor.rotation_euler[0:3] = act_obj.rotation_euler[0:3]

        elif self.cursor_tools == 'cursor_to_selection_rot':
            bpy.ops.view3d.snap_cursor_to_selected()
            bpy.context.scene.cursor.rotation_euler[0:3] = act_obj.rotation_euler[0:3]

        return {"FINISHED"}


def sfc_prim_change_mirror_name(self):

    if self.act_mod.use_axis[0] and self.act_mod.use_axis[1] and self.act_mod.use_axis[2]:
        self.act_mod.name = "Mirror - X Y Z"

    elif self.act_mod.use_axis[0] and self.act_mod.use_axis[1]:
        self.act_mod.name = "Mirror - X Y"

    elif self.act_mod.use_axis[0] and self.act_mod.use_axis[2]:
        self.act_mod.name = "Mirror - X Z"

    elif self.act_mod.use_axis[1] and self.act_mod.use_axis[2]:
        self.act_mod.name = "Mirror - Y Z"

    elif self.act_mod.use_axis[0]:
        self.act_mod.name = "Mirror - X"
    elif self.act_mod.use_axis[1]:
        self.act_mod.name = "Mirror - Z"
    elif self.act_mod.use_axis[2]:
        self.act_mod.name = "Mirror - Z"
    else:
        self.act_mod.name = "Mirror"

class SFC_OT_primitives_new(bpy.types.Operator):
    """
    PRIMITIVES

    SHIFT - On Selection
    CTRL  - On Mouse
    ALT    - Scale

    """
    bl_idname = "sfc.primitives_new"
    bl_label = "Speedfow Companion Primitives"
    bl_options = {"REGISTER"}

    @classmethod
    def poll(cls, context):
        return True

    primitives_enum: EnumProperty(
        items=(('default_prim', "Default Primitives", ""),
               ('screw_prim', "Screw Primitives", ""),
               ('editable_prim', "Editable Primitives", ""),
               ('custom_prim', "Custom Primitives", ""),),
        default='default_prim')

    screw_enum: EnumProperty(
        items=(('screw_1', "Screw 1", ""),
               ('screw_2', "Screw 2", ""),
               ('screw_3', "Screw 3", ""),
               ('screw_4', "Screw 4", ""),
               ('screw_5', "Screw 5", ""),
               ('screw_6', "Screw 6", ""),
               ('screw_7', "Screw 7", ""),),
        default='screw_1')

    editable_enum: EnumProperty(
        items=(('cube', "Cube", ""),
               ('grid', "Grid", ""),
               ('sphere', "Sphere", ""),
               ('torus', "Torus", ""),
               ('cone', "Cone", ""),
               ('cylinder', "Cylinder", ""),
               ('circle', "Circle", ""),
               ('capsule', "Capsule", ""),
               ('quad_sphere', "Quad Sphere", ""),
               ('tube', "Tube", ""),
               ('line', "Line", ""),),
        default='cube')

    default_enum: EnumProperty(
        items=(('plane', "Plane", ""),
               ('cube', "Cube", ""),
               ('circle', "Circle", ""),
               ('uv_sphere', "UV Sphere", ""),
               ('ico_sphere', "Ico Sphere", ""),
               ('cylinder', "Cylinder", ""),
               ('cone', "Cone", ""),
               ('torus', "Torus", ""),
               ('grid', "Grid", ""),
               ('monkey', "Monkey", ""),
               ('vertex', "Vertex", ""),
               ('bezier_curve', "Bezier Curve", ""),
               ('bezier_circle', "Bezier Circle", ""),
               ('empty', "Empty", ""),
               ),
        default='plane')

    custom_enum: EnumProperty(
        items=(('rounded_cube', "Rounded Cube", ""),
               ('rounded_plane', "Rounded Plane", ""),
               ('rounded_plane_round', "Rounded Plane Round", ""),
               ('rounded_plane_2', "Rounded Plane 2", ""),
               ('cross', "cross", ""),
               ('rounded_cross', "Rounded cross", ""),
               ('long_cylinder', "Long cylinder", ""),),
        default='rounded_cube'
    )

    def invoke(self, context, event):
        #        view3d = bpy.ops.view3d
        # region3d = bpy.ops.view3d.region_3d

        SFC_prim = context.window_manager.SFC_prim
        act_obj = context.object

        bpy.context.scene.tool_settings.use_mesh_automerge = False

        saved_location = bpy.context.scene.cursor.location.copy()
        cursor_rot = bpy.context.scene.cursor.rotation_euler.copy()

        if event.ctrl:
            bpy.ops.view3d.cursor3d('INVOKE_DEFAULT')

        # if act_obj:
        if event.shift:
            bpy.ops.view3d.snap_cursor_to_selected()

        if context.object is not None:
            act_obj = context.active_object
            bpy.ops.object.mode_set(mode='OBJECT')
            bpy.ops.object.select_all(action='DESELECT')

        # Mesh Creation
        if self.primitives_enum == 'default_prim':
            primitives_default(self.default_enum)

        elif self.primitives_enum == 'editable_prim':
            primitives_editable(self.editable_enum)

        elif self.primitives_enum == 'screw_prim':
            primitives_screw(self.screw_enum)

        elif self.primitives_enum == 'custom_prim':
            primitives_custom(self.custom_enum)

        new_prim = context.active_object
        other = False
        if new_prim.type in {'EMPTY', 'CURVE'}:
            other = True

        bpy.ops.view3d.snap_selected_to_cursor(use_offset=False)

        if not other :
            if act_obj:

                if SFC_prim.add_boolean or SFC_prim.add_rebool:
                    if SFC_prim.add_rebool:
                        SFC_prim.add_boolean = True

                    if act_obj.type == 'MESH':

                        # Check si collection existe, si non, on la cree
                        if not bpy.data.collections.get('Bool_Objects'):
                            coll = bpy.data.collections.new("Bool_Objects")
                            bpy.context.collection.children.link(coll)

                        bpy.context.object.display_type = 'BOUNDS'
                        bpy.context.object.hide_render = True

                        if context.object.mode == 'EDIT':
                            bpy.ops.object.mode_set(mode='OBJECT')

                        bpy.ops.object.select_all(action='DESELECT')
                        act_obj.select_set(state=True)
                        bpy.context.view_layer.objects.active = act_obj

                        # Add Boolean
                        boolean_modifier = act_obj.modifiers.new("Boolean", 'BOOLEAN')
                        boolean_modifier.name = "Boolean - %s" % (boolean_modifier.operation)
                        boolean_modifier.object = new_prim
                        boolean_modifier.show_expanded = False
                        boolean_modifier.operation = SFC_prim.boolean_enum

                        bevel_angle = False
                        weigthed_normals = False
                        triangulate = False
                        for mod in act_obj.modifiers:
                            if mod.type == 'BEVEL' and mod.limit_method == 'ANGLE':
                                bevel_angle = True
                            if mod.type == 'WEIGHTED_NORMAL':
                                weigthed_normals = True
                            if mod.type == 'TRIANGULATE':
                                triangulate = True

                        if bevel_angle:
                            bpy.ops.object.modifier_move_up(modifier=boolean_modifier.name)

                        if weigthed_normals:
                            bpy.ops.object.modifier_move_up(modifier=boolean_modifier.name)

                        if triangulate:
                            bpy.ops.object.modifier_move_up(modifier=boolean_modifier.name)

                        if SFC_prim.add_rebool:
                            bpy.ops.object.duplicate()
                            new_rebool = context.object

                            for mod in new_rebool.modifiers:
                                if not mod.type == 'BOOLEAN':
                                    continue
                                if mod.name == boolean_modifier.name:
                                    mod.operation = 'INTERSECT'
                                    print(mod.object)

                        bpy.data.collections['Bool_Objects'].objects.link(new_prim)
                        bpy.context.collection.objects.unlink(new_prim)
                        new_prim.hide_render = True

                # Add Mirror
                if SFC_prim.add_mirror:
                    mirror_modifier = new_prim.modifiers.new("Mirror", 'MIRROR')
                    # mirror_modifier.name = "Mirror - %s" % (mirror_modifier.mirror_object)
                    mirror_modifier.mirror_object = act_obj
                    axis = SFC_prim.mirror_axis_xyz
                    mirror_modifier.use_axis[:] =  ('X' in axis, 'Y' in axis, 'Z' in axis)

                bpy.ops.object.mode_set(mode='OBJECT')
                bpy.ops.object.select_all(action='DESELECT')
                new_prim.select_set(state=True)
                bpy.context.view_layer.objects.active = new_prim


        if SFC_prim.align_cursor_rot:
            bpy.context.object.rotation_euler = cursor_rot


        if self.primitives_enum == 'default_prim':
            if event.alt and event.shift:
                bpy.ops.object.mode_set(mode='EDIT')


        if event.ctrl:
            bpy.ops.transform.translate('INVOKE_DEFAULT')

        if event.alt:
            if act_obj:
                if not SFC_prim.screw_mode:
                    bpy.ops.transform.resize('INVOKE_DEFAULT')

        if SFC_prim.screw_mode:
            if act_obj:
                bpy.ops.object.mode_set(mode='OBJECT')
                if not event.shift or event.ctrl or event.alt:
                    bpy.ops.speedflow.displace('INVOKE_DEFAULT', True)

        # Si un modifier 'BOOLEAN' ne possede pas d'objet, on le supprime
        if act_obj:
            for mod in act_obj.modifiers:
                if mod.type == 'BOOLEAN' and not mod.object:
                    act_obj.modifiers.remove(mod)


        SFC_prim.screw_mode = False
        bpy.context.scene.cursor.location = saved_location

        return {"FINISHED"}


CLASSES = [SFC_OT_primitives_new,
           SFC_OT_cursor_tools,
           SFC_OT_curve_line,
           ]


# Register
def register():
    for cls in CLASSES:
        try:
            bpy.utils.register_class(cls)
        except:
            print(f"{cls.__name__} already registred")


# Unregister
def unregister():
    for cls in CLASSES:
        bpy.utils.unregister_class(cls)


if __name__ == "__main__":
    register()




