/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jackhuang.hellominecraft.launcher.Main$$Lambda$1;
import org.jackhuang.hellominecraft.launcher.Main$$Lambda$2;
import org.jackhuang.hellominecraft.launcher.Main$$Lambda$3;
import org.jackhuang.hellominecraft.launcher.api.PluginManager;
import org.jackhuang.hellominecraft.launcher.core.launch.GameLauncher;
import org.jackhuang.hellominecraft.launcher.setting.Settings;
import org.jackhuang.hellominecraft.launcher.ui.MainFrame;
import org.jackhuang.hellominecraft.launcher.util.CrashReporter;
import org.jackhuang.hellominecraft.launcher.util.upgrade.IUpgrader;
import org.jackhuang.hellominecraft.lookandfeel.HelloMinecraftLookAndFeel;
import org.jackhuang.hellominecraft.util.MathUtils;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.VersionNumber;
import org.jackhuang.hellominecraft.util.lang.SupportedLocales;
import org.jackhuang.hellominecraft.util.logging.Configuration;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.logging.appender.ConsoleAppender;
import org.jackhuang.hellominecraft.util.logging.layout.DefaultLayout;
import org.jackhuang.hellominecraft.util.system.ProcessManager;
import org.jackhuang.hellominecraft.util.ui.LogWindow;

public final class Main
implements Runnable {
    private static final X509TrustManager XTM = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    };
    private static final HostnameVerifier HNV = Main$$Lambda$3.lambdaFactory$();
    public static final String LAUNCHER_NAME = "Hello Minecraft! Launcher";
    public static final String LAUNCHER_VERSION = "2.4.1.233";
    public static final int MINIMUM_LAUNCHER_VERSION = 16;
    public static final Main INSTANCE;
    private static HelloMinecraftLookAndFeel LOOK_AND_FEEL;
    private static final Logger LOGGER;

    public static VersionNumber getVersionNumber() {
        return VersionNumber.check(LAUNCHER_VERSION);
    }

    public static String makeTitle() {
        return "Hello Minecraft! Launcher 2.4.1.233";
    }

    public static String shortTitle() {
        return "HMCL 2.4.1.233";
    }

    public static void main(String[] args) throws IOException {
        if (IUpgrader.NOW_UPGRADER.parseArguments(Main.getVersionNumber(), args)) {
            return;
        }
        System.setProperty("awt.useSystemAAFontSettings", "on");
        System.setProperty("swing.aatext", "true");
        System.setProperty("sun.java2d.noddraw", "true");
        System.setProperty("sun.java2d.dpiaware", "false");
        Thread.setDefaultUncaughtExceptionHandler(new CrashReporter(true));
        try {
            File file = new File("hmcl.log");
            if (!file.exists() && !file.createNewFile()) {
                HMCLog.warn("Failed to create log file " + file);
            }
            Configuration.DEFAULT.appenders.add(new ConsoleAppender("File", new DefaultLayout(), true, new FileOutputStream(file), true));
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Failed to add log appender File because an error occurred while creating or opening hmcl.log", ex);
        }
        HMCLog.log("*** " + Main.makeTitle() + " ***");
        String s = Settings.getInstance().getLocalization();
        for (SupportedLocales sl : SupportedLocales.values()) {
            if (!sl.name().equals(s)) continue;
            SupportedLocales.NOW_LOCALE = sl;
            Locale.setDefault(sl.self);
        }
        LogWindow.INSTANCE.clean();
        ProcessManager processManager = GameLauncher.PROCESS_MANAGER;
        processManager.getClass();
        LogWindow.INSTANCE.setTerminateGame(Main$$Lambda$1.lambdaFactory$(processManager));
        try {
            LOOK_AND_FEEL = new HelloMinecraftLookAndFeel(Settings.getInstance().getTheme().settings);
            UIManager.setLookAndFeel(LOOK_AND_FEEL);
        }
        catch (ParseException | UnsupportedLookAndFeelException ex) {
            HMCLog.warn("Failed to set look and feel...", ex);
        }
        Settings.UPDATE_CHECKER.outdated.register(IUpgrader.NOW_UPGRADER);
        Settings.UPDATE_CHECKER.process(false).reg(Main$$Lambda$2.lambdaFactory$()).execute();
        if (StrUtils.isNotBlank(Settings.getInstance().getProxyHost()) && StrUtils.isNotBlank(Settings.getInstance().getProxyPort()) && MathUtils.canParseInt(Settings.getInstance().getProxyPort())) {
            HMCLog.log("Initializing customized proxy");
            System.setProperty("http.proxyHost", Settings.getInstance().getProxyHost());
            System.setProperty("http.proxyPort", Settings.getInstance().getProxyPort());
            if (StrUtils.isNotBlank(Settings.getInstance().getProxyUserName()) && StrUtils.isNotBlank(Settings.getInstance().getProxyPassword())) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(Settings.getInstance().getProxyUserName(), Settings.getInstance().getProxyPassword().toCharArray());
                    }
                });
            }
        }
        try {
            PluginManager.plugin().showUI();
        }
        catch (Throwable t) {
            new CrashReporter(false).uncaughtException(Thread.currentThread(), t);
            System.exit(1);
        }
    }

    @Override
    public void run() {
        GameLauncher.PROCESS_MANAGER.stopAllProcesses();
    }

    public static void invokeUpdate() {
        MainFrame.INSTANCE.invokeUpdate();
    }

    public static ImageIcon getIcon(String path) {
        try {
            return new ImageIcon(Main.class.getResource("/org/jackhuang/hellominecraft/launcher/" + path));
        }
        catch (Exception e) {
            HMCLog.err("Failed to load icon", e);
            return null;
        }
    }

    private static /* synthetic */ boolean lambda$static$0(String hostname, SSLSession session) {
        return true;
    }

    static {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            TrustManager[] xtmArray = new X509TrustManager[]{XTM};
            sslContext.init(null, xtmArray, new SecureRandom());
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        if (sslContext != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        }
        HttpsURLConnection.setDefaultHostnameVerifier(HNV);
        INSTANCE = new Main();
        LOGGER = Logger.getLogger(Main.class.getName());
    }

    static /* synthetic */ void access$lambda$0(VersionNumber versionNumber) {
        Main.invokeUpdate();
    }

    static /* synthetic */ boolean access$lambda$1(String string, SSLSession sSLSession) {
        return Main.lambda$static$0(string, sSLSession);
    }
}

