/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core;

import java.io.File;
import java.io.IOException;
import org.jackhuang.hellominecraft.util.system.FileUtils;
import org.jackhuang.hellominecraft.util.system.OS;

public final class MCUtils {
    public static final String PROFILE = "{\"selectedProfile\": \"(Default)\",\"profiles\": {\"(Default)\": {\"name\": \"(Default)\"}},\"clientToken\": \"88888888-8888-8888-8888-888888888888\"}";

    public static File getWorkingDirectory(String baseName) {
        File file;
        String userhome = System.getProperty("user.home", ".");
        switch (OS.os()) {
            case LINUX: {
                file = new File(userhome, '.' + baseName + '/');
                break;
            }
            case WINDOWS: {
                String appdata = System.getenv("APPDATA");
                if (appdata != null) {
                    file = new File(appdata, "." + baseName + '/');
                    break;
                }
                file = new File(userhome, '.' + baseName + '/');
                break;
            }
            case OSX: {
                file = new File(userhome, "Library/Application Support/" + baseName);
                break;
            }
            default: {
                file = new File(userhome, baseName + '/');
            }
        }
        return file;
    }

    public static File getLocation() {
        return MCUtils.getWorkingDirectory("minecraft");
    }

    public static String minecraft() {
        if (OS.os() == OS.OSX) {
            return "minecraft";
        }
        return ".minecraft";
    }

    public static File getInitGameDir() {
        File newFile;
        File gameDir = new File(MCUtils.minecraft());
        if (!gameDir.exists() && (newFile = MCUtils.getLocation()).exists()) {
            gameDir = newFile;
        }
        return gameDir;
    }

    public static void tryWriteProfile(File gameDir) throws IOException {
        File file = new File(gameDir, "launcher_profiles.json");
        if (!file.exists()) {
            FileUtils.write(file, PROFILE);
        }
    }
}

