/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.asset;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jackhuang.hellominecraft.launcher.core.asset.AssetsIndex;
import org.jackhuang.hellominecraft.launcher.core.asset.AssetsObject;
import org.jackhuang.hellominecraft.launcher.core.asset.Contents;
import org.jackhuang.hellominecraft.launcher.core.asset.IAssetsHandler;
import org.jackhuang.hellominecraft.launcher.core.download.IDownloadProvider;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftAssetService;
import org.jackhuang.hellominecraft.launcher.core.version.MinecraftVersion;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.Utils;
import org.jackhuang.hellominecraft.util.VersionNumber;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.FileUtils;
import org.jackhuang.hellominecraft.util.system.IOUtils;
import org.jackhuang.hellominecraft.util.tasks.Task;
import org.jackhuang.hellominecraft.util.tasks.TaskInfo;

public class AssetsMojangLoader
extends IAssetsHandler {
    public AssetsMojangLoader(String name) {
        super(name);
    }

    @Override
    public Task getList(final MinecraftVersion mv, final IMinecraftAssetService mp) {
        Utils.requireNonNull(mv);
        String assetsId = mv.getAssetsIndex().getId();
        final File assets = mp.getAssets();
        HMCLog.log("Gathering asset index: " + assetsId);
        final File f = IOUtils.tryGetCanonicalFile(new File(assets, "indexes/" + assetsId + ".json"));
        return new TaskInfo("Gather asset index"){

            @Override
            public Collection<Task> getDependTasks() {
                if (!f.exists()) {
                    return Arrays.asList(mp.downloadMinecraftAssetsIndex(mv.getAssetsIndex()));
                }
                return null;
            }

            @Override
            public void executeTask() throws Throwable {
                if (!this.areDependTasksSucceeded) {
                    throw new IllegalStateException("Failed to get asset index");
                }
                String result = FileUtils.read(f);
                if (StrUtils.isBlank(result)) {
                    throw new IllegalStateException("Index json is empty, please redownload it!");
                }
                AssetsIndex o = C.GSON.fromJson(result, AssetsIndex.class);
                AssetsMojangLoader.this.assetsDownloadURLs = new ArrayList();
                AssetsMojangLoader.this.assetsLocalNames = new ArrayList();
                ArrayList<String> al = new ArrayList<String>();
                AssetsMojangLoader.this.contents = new ArrayList();
                HashSet<String> loadedHashes = new HashSet<String>();
                int pgs = 0;
                if (o != null && o.getFileMap() != null) {
                    for (Map.Entry<String, AssetsObject> e : o.getFileMap().entrySet()) {
                        if (loadedHashes.contains(e.getValue().getHash())) continue;
                        loadedHashes.add(e.getValue().getHash());
                        Contents c = new Contents();
                        c.eTag = e.getValue().getHash();
                        c.key = c.eTag.substring(0, 2) + "/" + e.getValue().getHash();
                        c.size = e.getValue().getSize();
                        AssetsMojangLoader.this.contents.add(c);
                        AssetsMojangLoader.this.assetsDownloadURLs.add(c.key);
                        AssetsMojangLoader.this.assetsLocalNames.add(new File(assets, "objects" + File.separator + c.key.replace("/", File.separator)));
                        al.add(e.getKey());
                        if (this.ppl == null) continue;
                        this.ppl.setProgress(this, ++pgs, o.getFileMap().size());
                    }
                }
            }
        };
    }

    @Override
    public Task getDownloadTask(IDownloadProvider sourceType) {
        return new IAssetsHandler.AssetsTask(this, sourceType.getAssetsDownloadURL());
    }

    @Override
    public boolean isVersionAllowed(String formattedVersion) {
        VersionNumber ur = VersionNumber.check(formattedVersion);
        if (ur == null) {
            return false;
        }
        return VersionNumber.check("1.6.0").compareTo(ur) <= 0;
    }
}

