/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.asset;

import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jackhuang.hellominecraft.launcher.core.asset.AssetsIndex;
import org.jackhuang.hellominecraft.launcher.core.asset.AssetsObject;
import org.jackhuang.hellominecraft.launcher.core.asset.IAssetsHandler;
import org.jackhuang.hellominecraft.launcher.core.asset.MinecraftAssetService$$Lambda$1;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftAssetService;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftService;
import org.jackhuang.hellominecraft.launcher.core.version.AssetIndexDownloadInfo;
import org.jackhuang.hellominecraft.launcher.core.version.MinecraftVersion;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.MessageBox;
import org.jackhuang.hellominecraft.util.func.BiFunction;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.FileUtils;
import org.jackhuang.hellominecraft.util.system.IOUtils;
import org.jackhuang.hellominecraft.util.tasks.Task;
import org.jackhuang.hellominecraft.util.tasks.TaskInfo;
import org.jackhuang.hellominecraft.util.tasks.TaskWindow;
import org.jackhuang.hellominecraft.util.tasks.download.FileDownloadTask;

public class MinecraftAssetService
extends IMinecraftAssetService {
    public final BiFunction<MinecraftVersion, Boolean, String> ASSET_PROVIDER_IMPL = MinecraftAssetService$$Lambda$1.lambdaFactory$(this);

    public MinecraftAssetService(IMinecraftService service) {
        super(service);
    }

    @Override
    public Task downloadAssets(String mcVersion) {
        return this.downloadAssets(this.service.version().getVersionById(mcVersion));
    }

    public Task downloadAssets(MinecraftVersion mv) {
        if (mv == null) {
            return null;
        }
        return IAssetsHandler.ASSETS_HANDLER.getList(mv, this.service.asset()).after(IAssetsHandler.ASSETS_HANDLER.getDownloadTask(this.service.getDownloadType().getProvider()));
    }

    @Override
    public boolean refreshAssetsIndex(String id) {
        MinecraftVersion mv = this.service.version().getVersionById(id);
        if (mv == null) {
            return false;
        }
        return this.downloadMinecraftAssetsIndexAsync(mv.getAssetsIndex());
    }

    @Override
    public Task downloadMinecraftAssetsIndex(final AssetIndexDownloadInfo assets) {
        File assetsLocation = this.getAssets();
        if (!assetsLocation.exists() && !assetsLocation.mkdirs()) {
            HMCLog.warn("Failed to make directories: " + assetsLocation);
        }
        final File assetsIndex = new File(assetsLocation, "indexes/" + assets.getId() + ".json");
        File renamed = null;
        if (assetsIndex.exists() && assetsIndex.renameTo(renamed = new File(assetsLocation, "indexes/" + assets.getId() + "-renamed.json"))) {
            HMCLog.warn("Failed to rename " + assetsIndex + " to " + renamed);
        }
        final File renamedFinal = renamed;
        return new TaskInfo("Download Asset Index"){

            @Override
            public Collection<Task> getDependTasks() {
                return Arrays.asList(new FileDownloadTask(assets.getUrl(MinecraftAssetService.this.service.getDownloadType()), IOUtils.tryGetCanonicalFile(assetsIndex), assets.sha1).setTag(assets.getId() + ".json"));
            }

            @Override
            public void executeTask() throws Throwable {
                if (this.areDependTasksSucceeded) {
                    if (renamedFinal != null && !renamedFinal.delete()) {
                        HMCLog.warn("Failed to delete " + renamedFinal + ", maybe you should do it.");
                    }
                } else if (renamedFinal != null && !renamedFinal.renameTo(assetsIndex)) {
                    HMCLog.warn("Failed to rename " + renamedFinal + " to " + assetsIndex);
                }
            }
        };
    }

    @Override
    public boolean downloadMinecraftAssetsIndexAsync(AssetIndexDownloadInfo assets) {
        File assetsLocation = this.getAssets();
        if (!assetsLocation.exists() && !assetsLocation.mkdirs()) {
            HMCLog.warn("Failed to make directories: " + assetsLocation);
        }
        File assetsIndex = new File(assetsLocation, "indexes/" + assets.getId() + ".json");
        File renamed = null;
        if (assetsIndex.exists() && assetsIndex.renameTo(renamed = new File(assetsLocation, "indexes/" + assets.getId() + "-renamed.json"))) {
            HMCLog.warn("Failed to rename " + assetsIndex + " to " + renamed);
        }
        if (TaskWindow.factory().append(new FileDownloadTask(assets.getUrl(this.service.getDownloadType()), IOUtils.tryGetCanonicalFile(assetsIndex), assets.sha1).setTag(assets.getId() + ".json")).create()) {
            if (renamed != null && !renamed.delete()) {
                HMCLog.warn("Failed to delete " + renamed + ", maybe you should do it.");
            }
            return true;
        }
        if (renamed != null && !renamed.renameTo(assetsIndex)) {
            HMCLog.warn("Failed to rename " + renamed + " to " + assetsIndex);
        }
        return false;
    }

    @Override
    public File getAssets() {
        return new File(this.service.baseDirectory(), "assets");
    }

    @Override
    public File getAssetObject(String assetVersion, String name) throws IOException {
        File assetsDir = this.getAssets();
        File indexDir = new File(assetsDir, "indexes");
        File objectsDir = new File(assetsDir, "objects");
        File indexFile = new File(indexDir, assetVersion + ".json");
        try {
            AssetsIndex index = C.GSON.fromJson(FileUtils.read(indexFile, "UTF-8"), AssetsIndex.class);
            String hash = index.getFileMap().get(name).getHash();
            return new File(objectsDir, hash.substring(0, 2) + "/" + hash);
        }
        catch (JsonSyntaxException e) {
            throw new IOException("Assets file format malformed.", e);
        }
    }

    private boolean checkAssetsExistance(AssetIndexDownloadInfo assetIndex) {
        File assetsDir = this.getAssets();
        File indexDir = new File(assetsDir, "indexes");
        File objectDir = new File(assetsDir, "objects");
        File indexFile = new File(indexDir, assetIndex.getId() + ".json");
        if (!assetsDir.exists() || !indexFile.isFile()) {
            return false;
        }
        try {
            String assetIndexContent = FileUtils.read(indexFile, "UTF-8");
            AssetsIndex index = C.GSON.fromJson(assetIndexContent, AssetsIndex.class);
            if (index == null) {
                return false;
            }
            for (Map.Entry<String, AssetsObject> entry : index.getFileMap().entrySet()) {
                if (new File(new File(objectDir, entry.getValue().getHash().substring(0, 2)), entry.getValue().getHash()).exists()) continue;
                return false;
            }
            return true;
        }
        catch (JsonSyntaxException | IOException e) {
            return false;
        }
    }

    private File reconstructAssets(AssetIndexDownloadInfo assetIndex) {
        File assetsDir = this.getAssets();
        File indexDir = new File(assetsDir, "indexes");
        File objectDir = new File(assetsDir, "objects");
        String assetVersion = assetIndex.getId();
        File indexFile = new File(indexDir, assetVersion + ".json");
        File virtualRoot = new File(new File(assetsDir, "virtual"), assetVersion);
        if (!indexFile.isFile()) {
            HMCLog.warn("No assets index file " + virtualRoot + "; can't reconstruct assets");
            return assetsDir;
        }
        try {
            String assetIndexContent = FileUtils.read(indexFile, "UTF-8");
            AssetsIndex index = C.GSON.fromJson(assetIndexContent, AssetsIndex.class);
            if (index == null) {
                return assetsDir;
            }
            if (index.isVirtual()) {
                int cnt = 0;
                HMCLog.log("Reconstructing virtual assets folder at " + virtualRoot);
                int tot = index.getFileMap().entrySet().size();
                for (Map.Entry<String, AssetsObject> entry : index.getFileMap().entrySet()) {
                    File target = new File(virtualRoot, entry.getKey());
                    File original = new File(new File(objectDir, entry.getValue().getHash().substring(0, 2)), entry.getValue().getHash());
                    if (!original.exists()) continue;
                    ++cnt;
                    if (target.isFile()) continue;
                    FileUtils.copyFile(original, target);
                }
                if (cnt * 10 < tot) {
                    return assetsDir;
                }
            }
        }
        catch (JsonSyntaxException | IOException e) {
            HMCLog.warn("Failed to create virutal assets.", e);
        }
        return virtualRoot;
    }

    private /* synthetic */ String lambda$new$5(MinecraftVersion t, Boolean allow) {
        if (allow.booleanValue() && !this.checkAssetsExistance(t.getAssetsIndex()) && MessageBox.Show(C.i18n("assets.no_assets", new Object[0]), 10) == 0) {
            TaskWindow.execute(this.downloadAssets(t));
        }
        return this.reconstructAssets(t.getAssetsIndex()).getAbsolutePath();
    }

    static /* synthetic */ String access$lambda$0(MinecraftAssetService minecraftAssetService, MinecraftVersion minecraftVersion, Boolean bl) {
        return minecraftAssetService.lambda$new$5(minecraftVersion, bl);
    }
}

