/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.auth;

import java.util.HashMap;
import java.util.Map;
import org.jackhuang.hellominecraft.launcher.core.auth.AuthenticationException;
import org.jackhuang.hellominecraft.launcher.core.auth.IAuthenticator;
import org.jackhuang.hellominecraft.launcher.core.auth.LoginInfo;
import org.jackhuang.hellominecraft.launcher.core.auth.UserProfileProvider;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.code.DigestUtils;

public final class OfflineAuthenticator
extends IAuthenticator {
    Map<String, String> uuidMap = new HashMap<String, String>();

    public OfflineAuthenticator(String clientToken) {
        super(clientToken);
    }

    @Override
    public void onLoadSettings(Map m) {
        super.onLoadSettings(m);
        if (m == null) {
            return;
        }
        Object o = m.get("uuidMap");
        if (o != null && o instanceof Map) {
            this.uuidMap = (Map)o;
        }
    }

    @Override
    public Map onSaveSettings() {
        Map m = super.onSaveSettings();
        m.put("uuidMap", this.uuidMap);
        return m;
    }

    @Override
    public UserProfileProvider login(LoginInfo info) throws AuthenticationException {
        if (StrUtils.isBlank(info.username)) {
            throw new AuthenticationException(C.i18n("login.no_Player007", new Object[0]));
        }
        UserProfileProvider result = new UserProfileProvider();
        result.setUserName(info.username);
        String uuid = OfflineAuthenticator.getUUIDFromUserName(info.username);
        if (this.uuidMap != null && this.uuidMap.containsKey(uuid)) {
            uuid = this.uuidMap.get(info.username);
        } else {
            if (this.uuidMap == null) {
                this.uuidMap = new HashMap<String, String>();
            }
            this.uuidMap.put(info.username, uuid);
        }
        result.setSession(uuid);
        result.setUserId(uuid);
        result.setAccessToken(uuid);
        result.setUserType("Legacy");
        return result;
    }

    public static String getUUIDFromUserName(String str) {
        return DigestUtils.md5Hex(str);
    }

    @Override
    public String id() {
        return "offline";
    }

    @Override
    public String getName() {
        return C.i18n("login.methods.offline", new Object[0]);
    }

    @Override
    public boolean hasPassword() {
        return false;
    }

    @Override
    public UserProfileProvider loginBySettings() {
        return null;
    }

    @Override
    public void logOut() {
    }
}

