/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.auth;

import org.jackhuang.hellominecraft.launcher.core.auth.AuthenticationException;
import org.jackhuang.hellominecraft.launcher.core.auth.IAuthenticator;
import org.jackhuang.hellominecraft.launcher.core.auth.LoginInfo;
import org.jackhuang.hellominecraft.launcher.core.auth.UserProfileProvider;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.NetUtils;
import org.jackhuang.hellominecraft.util.code.DigestUtils;
import org.jackhuang.hellominecraft.util.lang.SupportedLocales;
import org.jackhuang.hellominecraft.util.ui.SwingUtils;

public final class SkinmeAuthenticator
extends IAuthenticator {
    public SkinmeAuthenticator(String clientToken) {
        super(clientToken);
    }

    public String[] parseType1(String s) {
        return s.split(",");
    }

    public String getCharacter(String user, String hash, String $char) throws Exception {
        return NetUtils.get("http://www.skinme.cc/api/login.php?user=" + user + "&hash=" + hash + ($char == null ? "" : "&char=" + $char));
    }

    @Override
    public UserProfileProvider login(LoginInfo info) throws AuthenticationException {
        UserProfileProvider req = new UserProfileProvider();
        if (info.username == null || !info.username.contains("@")) {
            throw new AuthenticationException(C.i18n("login.not_email", new Object[0]));
        }
        try {
            String usr = info.username.toLowerCase(SupportedLocales.NOW_LOCALE.self);
            String pwd = info.password;
            String str = DigestUtils.sha1Hex(usr);
            String hashCode = DigestUtils.sha1Hex(DigestUtils.md5Hex(DigestUtils.sha1Hex(pwd) + pwd) + str);
            String data = this.getCharacter(usr, hashCode, null);
            String[] sl = data.split(":");
            if (null != sl[0]) {
                String string = sl[0];
                int n = -1;
                switch (string.hashCode()) {
                    case 48: {
                        if (!string.equals("0")) break;
                        n = 0;
                        break;
                    }
                    case 49: {
                        if (!string.equals("1")) break;
                        n = 1;
                        break;
                    }
                    case 50: {
                        if (!string.equals("2")) break;
                        n = 2;
                    }
                }
                switch (n) {
                    case 0: {
                        if (sl[1].contains("No Valid Character")) {
                            sl[1] = C.i18n("login.no_valid_character", new Object[0]);
                        }
                        throw new AuthenticationException(sl[1]);
                    }
                    case 1: {
                        String[] s = this.parseType1(sl[1]);
                        req.setUserName(s[0]);
                        req.setSession(s[1]);
                        req.setUserId(s[1]);
                        req.setAccessToken(s[1]);
                        break;
                    }
                    case 2: {
                        String[] charators = sl[1].split(";");
                        int len = charators.length;
                        String[] $char = new String[len];
                        String[] user = new String[len];
                        System.out.println(sl[1]);
                        for (int i = 0; i < len; ++i) {
                            String[] charator = charators[i].split(",");
                            $char[i] = charator[0];
                            user[i] = charator[1];
                        }
                        int index = SwingUtils.select(user, C.i18n("login.choose_charactor", new Object[0]));
                        if (index == -1) {
                            throw new AuthenticationException(C.i18n("message.cancelled", new Object[0]));
                        }
                        String character = $char[index];
                        sl = this.getCharacter(usr, hashCode, character).split(":");
                        String[] s2 = this.parseType1(sl[1]);
                        req.setUserName(s2[0]);
                        req.setSession(s2[1]);
                        req.setUserId(s2[1]);
                        req.setAccessToken(s2[1]);
                    }
                }
            }
            req.setUserType("Legacy");
            return req;
        }
        catch (Exception e) {
            throw new AuthenticationException(e);
        }
    }

    @Override
    public String id() {
        return "skinme";
    }

    @Override
    public String getName() {
        return "Skinme";
    }

    @Override
    public UserProfileProvider loginBySettings() {
        return null;
    }

    @Override
    public void logOut() {
    }
}

