/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.auth;

import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.util.Map;
import javax.swing.JOptionPane;
import org.jackhuang.hellominecraft.launcher.core.auth.AuthenticationException;
import org.jackhuang.hellominecraft.launcher.core.auth.IAuthenticator;
import org.jackhuang.hellominecraft.launcher.core.auth.LoginInfo;
import org.jackhuang.hellominecraft.launcher.core.auth.OfflineAuthenticator;
import org.jackhuang.hellominecraft.launcher.core.auth.UserProfileProvider;
import org.jackhuang.hellominecraft.launcher.core.auth.yggdrasil.GameProfile;
import org.jackhuang.hellominecraft.launcher.core.auth.yggdrasil.PropertyMap;
import org.jackhuang.hellominecraft.launcher.core.auth.yggdrasil.UUIDTypeAdapter;
import org.jackhuang.hellominecraft.launcher.core.auth.yggdrasil.YggdrasilAuthentication;
import org.jackhuang.hellominecraft.util.ArrayUtils;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.ui.SwingUtils;

public final class YggdrasilAuthenticator
extends IAuthenticator {
    YggdrasilAuthentication ua;

    public YggdrasilAuthenticator(String clientToken) {
        super(clientToken);
        this.ua = new YggdrasilAuthentication(Proxy.NO_PROXY, clientToken);
    }

    @Override
    public UserProfileProvider login(LoginInfo info) throws AuthenticationException {
        UserProfileProvider result = new UserProfileProvider();
        result.setUserType("mojang");
        if (this.ua.canPlayOnline()) {
            result.setUserName(info.username);
            result.setUserId(UUIDTypeAdapter.fromUUID(this.ua.getSelectedProfile().id));
        } else {
            String username;
            String usr = info.username;
            if (info.username == null || !info.username.contains("@")) {
                throw new AuthenticationException(C.i18n("login.not_email", new Object[0]));
            }
            String pwd = info.password;
            if (!this.ua.isLoggedIn()) {
                this.ua.setPassword(pwd);
            }
            this.ua.setUserName(usr);
            this.ua.logIn();
            if (!this.ua.isLoggedIn()) {
                throw new AuthenticationException(C.i18n("login.wrong_password", new Object[0]));
            }
            GameProfile selectedProfile = this.ua.getSelectedProfile();
            GameProfile[] profiles = this.ua.getAvailableProfiles();
            if (selectedProfile == null) {
                if (ArrayUtils.isNotEmpty(profiles)) {
                    String[] names = new String[profiles.length];
                    for (int i = 0; i < profiles.length; ++i) {
                        names[i] = profiles[i].name;
                    }
                    int sel = SwingUtils.select(names, C.i18n("login.choose_charactor", new Object[0]));
                    if (sel == -1) {
                        throw new AuthenticationException("No selection");
                    }
                    selectedProfile = profiles[sel];
                    username = names[sel];
                } else {
                    username = JOptionPane.showInputDialog(C.i18n("login.no_charactor", new Object[0]));
                }
            } else {
                username = selectedProfile.name;
            }
            if (username == null) {
                throw new AuthenticationException("No player");
            }
            result.setUserName(username);
            result.setUserId(selectedProfile == null ? OfflineAuthenticator.getUUIDFromUserName(username) : UUIDTypeAdapter.fromUUID(selectedProfile.id));
        }
        result.setUserProperties(new GsonBuilder().registerTypeAdapter((Type)((Object)PropertyMap.class), new PropertyMap.LegacySerializer()).create().toJson(this.ua.getUserProperties()));
        result.setUserPropertyMap(new GsonBuilder().registerTypeAdapter((Type)((Object)PropertyMap.class), new PropertyMap.Serializer()).create().toJson(this.ua.getUserProperties()));
        result.setAccessToken(this.ua.getAuthenticatedToken());
        result.setSession(this.ua.getAuthenticatedToken());
        return result;
    }

    @Override
    public boolean isLoggedIn() {
        return this.ua.isLoggedIn();
    }

    @Override
    public String id() {
        return "yggdrasil";
    }

    @Override
    public String getName() {
        return C.i18n("login.methods.yggdrasil", new Object[0]);
    }

    @Override
    public Map onSaveSettings() {
        Map<String, Object> m = this.ua.saveForStorage();
        m.putAll(super.onSaveSettings());
        return m;
    }

    @Override
    public void onLoadSettings(Map settings) {
        super.onLoadSettings(settings);
        if (settings == null) {
            return;
        }
        this.ua.loadFromStorage(settings);
    }

    @Override
    public UserProfileProvider loginBySettings() throws AuthenticationException {
        UserProfileProvider result = new UserProfileProvider();
        this.ua.logIn();
        if (!this.ua.isLoggedIn()) {
            throw new AuthenticationException(C.i18n("login.wrong_password", new Object[0]));
        }
        GameProfile profile = this.ua.getSelectedProfile();
        result.setUserName(profile.name);
        result.setUserId(profile.id.toString());
        result.setUserProperties(new GsonBuilder().registerTypeAdapter((Type)((Object)PropertyMap.class), new PropertyMap.LegacySerializer()).create().toJson(this.ua.getUserProperties()));
        result.setUserPropertyMap(new GsonBuilder().registerTypeAdapter((Type)((Object)PropertyMap.class), new PropertyMap.Serializer()).create().toJson(this.ua.getUserProperties()));
        result.setAccessToken(this.ua.getAuthenticatedToken());
        result.setSession(this.ua.getAuthenticatedToken());
        return result;
    }

    @Override
    public void logOut() {
        this.ua.logOut();
    }
}

