/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.auth.yggdrasil;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jackhuang.hellominecraft.launcher.core.auth.yggdrasil.Property;
import org.jackhuang.hellominecraft.util.logging.HMCLog;

public class PropertyMap
extends HashMap<String, Property> {
    private static final long serialVersionUID = 362498820763181265L;

    public List<Map<String, String>> list() {
        ArrayList<Map<String, String>> properties = new ArrayList<Map<String, String>>();
        for (Property profileProperty : this.values()) {
            HashMap<String, String> property = new HashMap<String, String>();
            property.put("name", profileProperty.name);
            property.put("value", profileProperty.value);
            properties.add(property);
        }
        return properties;
    }

    public void fromList(List<Map<String, String>> list) {
        try {
            for (Map<String, String> propertyMap : list) {
                String name = propertyMap.get("name");
                String value = propertyMap.get("value");
                this.put(name, new Property(name, value));
            }
        }
        catch (Throwable t) {
            HMCLog.warn("Failed to deserialize properties", t);
        }
    }

    public static class LegacySerializer
    implements JsonSerializer<PropertyMap> {
        @Override
        public JsonElement serialize(PropertyMap src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject result = new JsonObject();
            for (Map.Entry entry : src.entrySet()) {
                JsonArray values = new JsonArray();
                values.add(new JsonPrimitive(((Property)entry.getValue()).value));
                result.add((String)entry.getKey(), values);
            }
            return result;
        }
    }

    public static class Serializer
    implements JsonSerializer<PropertyMap>,
    JsonDeserializer<PropertyMap> {
        @Override
        public PropertyMap deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            PropertyMap result;
            block4: {
                block3: {
                    result = new PropertyMap();
                    if (!(json instanceof JsonObject)) break block3;
                    JsonObject object = (JsonObject)json;
                    for (Map.Entry<String, JsonElement> entry : object.entrySet()) {
                        if (!(entry.getValue() instanceof JsonArray)) continue;
                        for (JsonElement element : (JsonArray)entry.getValue()) {
                            result.put(entry.getKey(), new Property(entry.getKey(), element.getAsString()));
                        }
                    }
                    break block4;
                }
                if (!(json instanceof JsonArray)) break block4;
                for (JsonElement element : (JsonArray)json) {
                    if (!(element instanceof JsonObject)) continue;
                    JsonObject object = (JsonObject)element;
                    String name = object.getAsJsonPrimitive("name").getAsString();
                    String value = object.getAsJsonPrimitive("value").getAsString();
                    result.put(name, new Property(name, value));
                }
            }
            return result;
        }

        @Override
        public JsonElement serialize(PropertyMap src, Type typeOfSrc, JsonSerializationContext context) {
            JsonArray result = new JsonArray();
            for (Property property : src.values()) {
                JsonObject object = new JsonObject();
                object.addProperty("name", property.name);
                object.addProperty("value", property.value);
                result.add(object);
            }
            return result;
        }
    }
}

