/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.download;

import org.jackhuang.hellominecraft.launcher.core.install.InstallerType;
import org.jackhuang.hellominecraft.launcher.core.install.InstallerVersionList;

public abstract class IDownloadProvider {
    public InstallerVersionList getInstallerByType(InstallerType type) {
        switch (type) {
            case Forge: {
                return this.getForgeInstaller();
            }
            case LiteLoader: {
                return this.getLiteLoaderInstaller();
            }
            case OptiFine: {
                return this.getOptiFineInstaller();
            }
        }
        return null;
    }

    public abstract InstallerVersionList getForgeInstaller();

    public abstract InstallerVersionList getLiteLoaderInstaller();

    public abstract InstallerVersionList getOptiFineInstaller();

    public abstract String getLibraryDownloadURL();

    public abstract String getVersionsDownloadURL();

    public abstract String getIndexesDownloadURL();

    public abstract String getVersionsListDownloadURL();

    public abstract String getAssetsDownloadURL();

    public abstract String getParsedDownloadURL(String var1);

    public abstract boolean isAllowedToUseSelfURL();
}

