/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.download;

import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jackhuang.hellominecraft.launcher.core.GameException;
import org.jackhuang.hellominecraft.launcher.core.download.DownloadLibraryJob;
import org.jackhuang.hellominecraft.launcher.core.download.DownloadType;
import org.jackhuang.hellominecraft.launcher.core.download.MinecraftRemoteVersion;
import org.jackhuang.hellominecraft.launcher.core.download.MinecraftRemoteVersions;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftDownloadService;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftService;
import org.jackhuang.hellominecraft.launcher.core.version.GameDownloadInfo;
import org.jackhuang.hellominecraft.launcher.core.version.IMinecraftLibrary;
import org.jackhuang.hellominecraft.launcher.core.version.MinecraftVersion;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.func.Function;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.FileUtils;
import org.jackhuang.hellominecraft.util.tasks.Task;
import org.jackhuang.hellominecraft.util.tasks.TaskInfo;
import org.jackhuang.hellominecraft.util.tasks.download.FileDownloadTask;

public class MinecraftDownloadService
extends IMinecraftDownloadService {
    public MinecraftDownloadService(IMinecraftService service) {
        super(service);
    }

    @Override
    public List<DownloadLibraryJob> getDownloadLibraries(MinecraftVersion mv) throws GameException {
        ArrayList<DownloadLibraryJob> downloadLibraries = new ArrayList<DownloadLibraryJob>();
        if (mv == null) {
            return downloadLibraries;
        }
        MinecraftVersion v = mv.resolve(this.service.version());
        for (IMinecraftLibrary l : v.getLibraries()) {
            String libURL;
            File ff;
            if (l == null || !l.allow() || l.getDownloadInfo() == null || (ff = l.getFilePath(this.service.baseDirectory())).exists() || (libURL = l.getDownloadInfo().getUrl(this.service.getDownloadType())) == null) continue;
            downloadLibraries.add(new DownloadLibraryJob(l, libURL, ff));
        }
        return downloadLibraries;
    }

    @Override
    public Task downloadMinecraft(final String id) {
        return new TaskInfo("Download Minecraft"){
            Collection<Task> afters;
            {
                super(x0);
                this.afters = new HashSet<Task>();
            }

            @Override
            public Collection<Task> getDependTasks() {
                return Arrays.asList(MinecraftDownloadService.this.downloadMinecraftVersionJson(id));
            }

            @Override
            public void executeTask() throws Throwable {
                File vpath = new File(MinecraftDownloadService.this.service.baseDirectory(), "versions/" + id);
                if (!this.areDependTasksSucceeded) {
                    FileUtils.deleteDirectory(vpath);
                    throw new RuntimeException("Cannot continue because of download failing.");
                }
                File mvj = new File(vpath, id + ".jar");
                if (mvj.exists() && !mvj.delete()) {
                    HMCLog.warn("Failed to delete " + mvj);
                }
                try {
                    MinecraftVersion mv = C.GSON.fromJson(FileUtils.readQuietly(new File(vpath, id + ".json")), MinecraftVersion.class);
                    if (mv == null) {
                        throw new JsonSyntaxException("incorrect version");
                    }
                    this.afters.add(MinecraftDownloadService.this.downloadMinecraftJar(mv, mvj));
                }
                catch (JsonSyntaxException ex) {
                    HMCLog.err("Failed to parse minecraft version json.", ex);
                    FileUtils.deleteDirectory(vpath);
                }
            }

            @Override
            public Collection<Task> getAfterTasks() {
                return this.afters;
            }
        };
    }

    @Override
    public Task downloadMinecraftJar(MinecraftVersion mv, File mvj) {
        GameDownloadInfo i = mv.getClientDownloadInfo();
        return new FileDownloadTask(i.getUrl(this.service.getDownloadType()), mvj, i.sha1).setFailedCallbackReturnsNewURL(new DownloadTypeSwitcher(mv.id + "/" + mv.id + ".jar")).setTag(mv.id + ".jar");
    }

    @Override
    public Task downloadMinecraftVersionJson(final String id) {
        return new TaskInfo("Download Minecraft Json"){
            Collection<Task> afters;
            {
                super(x0);
                this.afters = new HashSet<Task>();
            }

            @Override
            public void executeTask() throws Throwable {
                List versions = MinecraftRemoteVersions.getRemoteVersions(MinecraftDownloadService.this.service.getDownloadType()).justDo();
                MinecraftRemoteVersion currentVersion = null;
                for (MinecraftRemoteVersion v : versions) {
                    if (!id.equals(v.id)) continue;
                    currentVersion = v;
                    break;
                }
                if (currentVersion == null) {
                    throw new RuntimeException("Cannot find version: " + id + " in remote repository.");
                }
                String jsonURL = currentVersion.getUrl(MinecraftDownloadService.this.service.getDownloadType());
                File vpath = new File(MinecraftDownloadService.this.service.baseDirectory(), "versions/" + id);
                File mvt = new File(vpath, id + ".json");
                if (!vpath.exists() && !vpath.mkdirs()) {
                    HMCLog.warn("Failed to make directories: " + vpath);
                }
                if (mvt.exists() && !mvt.delete()) {
                    HMCLog.warn("Failed to delete " + mvt);
                }
                this.afters.add(new FileDownloadTask(jsonURL, mvt).setTag(id + ".json"));
            }

            @Override
            public Collection<Task> getAfterTasks() {
                return this.afters;
            }
        };
    }

    private static class DownloadTypeSwitcher
    implements Function<Integer, String> {
        String suffix;

        public DownloadTypeSwitcher(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public String apply(Integer t) {
            return DownloadType.values()[t / 2].getProvider().getVersionsDownloadURL() + this.suffix;
        }
    }
}

