/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.download;

import java.util.Locale;
import org.jackhuang.hellominecraft.launcher.core.download.IDownloadProvider;
import org.jackhuang.hellominecraft.launcher.core.install.InstallerVersionList;
import org.jackhuang.hellominecraft.launcher.core.install.forge.MinecraftForgeVersionList;
import org.jackhuang.hellominecraft.launcher.core.install.liteloader.LiteLoaderVersionList;
import org.jackhuang.hellominecraft.launcher.core.install.optifine.vanilla.OptiFineVersionList;
import org.jackhuang.hellominecraft.util.lang.SupportedLocales;

public class MojangDownloadProvider
extends IDownloadProvider {
    @Override
    public InstallerVersionList getForgeInstaller() {
        return MinecraftForgeVersionList.getInstance();
    }

    @Override
    public InstallerVersionList getLiteLoaderInstaller() {
        return LiteLoaderVersionList.getInstance();
    }

    @Override
    public InstallerVersionList getOptiFineInstaller() {
        return OptiFineVersionList.getInstance();
    }

    @Override
    public String getLibraryDownloadURL() {
        return "https://libraries.minecraft.net";
    }

    @Override
    public String getVersionsDownloadURL() {
        return "http://s3.amazonaws.com/Minecraft.Download/versions/";
    }

    @Override
    public String getIndexesDownloadURL() {
        return "http://s3.amazonaws.com/Minecraft.Download/indexes/";
    }

    @Override
    public String getVersionsListDownloadURL() {
        return "https://launchermeta.mojang.com/mc/game/version_manifest.json";
    }

    @Override
    public String getAssetsDownloadURL() {
        return "https://resources.download.minecraft.net/";
    }

    @Override
    public boolean isAllowedToUseSelfURL() {
        return true;
    }

    @Override
    public String getParsedDownloadURL(String str) {
        if (str == null) {
            return null;
        }
        if (str.contains("scala-swing") || str.contains("scala-xml") || str.contains("scala-parser-combinators")) {
            return str.replace("http://files.minecraftforge.net/maven", "http://ftb.cursecdn.com/FTB2/maven/");
        }
        if (str.contains("typesafe") || str.contains("scala")) {
            if (SupportedLocales.NOW_LOCALE.self == Locale.CHINA) {
                return str.replace("http://files.minecraftforge.net/maven", "http://maven.oschina.net/content/groups/public");
            }
            return str.replace("http://files.minecraftforge.net/maven", "http://repo1.maven.org/maven2");
        }
        return str;
    }
}

