/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.install;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jackhuang.hellominecraft.util.tasks.Task;

public abstract class InstallerVersionList {
    public abstract Task refresh(String[] var1);

    public abstract String getName();

    protected abstract List<InstallerVersion> getVersionsImpl(String var1);

    public List<InstallerVersion> getVersions(String mcVersion) {
        List<InstallerVersion> a = this.getVersionsImpl(mcVersion);
        if (a == null) {
            return null;
        }
        return new ArrayList<InstallerVersion>(a);
    }

    public static class InstallerVersionComparator
    implements Comparator<InstallerVersion>,
    Serializable {
        private static final long serialVersionUID = 3276198781795213723L;
        public static final InstallerVersionComparator INSTANCE = new InstallerVersionComparator();

        @Override
        public int compare(InstallerVersion o1, InstallerVersion o2) {
            return o2.compareTo(o1);
        }
    }

    public static class InstallerVersion
    implements Comparable<InstallerVersion> {
        public String selfVersion;
        public String mcVersion;
        public String installer;
        public String universal;
        public String changelog;

        public InstallerVersion(String selfVersion, String mcVersion) {
            this.selfVersion = selfVersion;
            this.mcVersion = mcVersion;
        }

        @Override
        public int compareTo(InstallerVersion o) {
            return this.selfVersion.compareTo(o.selfVersion);
        }

        public int hashCode() {
            return this.selfVersion.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InstallerVersion other = (InstallerVersion)obj;
            return Objects.equals(this.selfVersion, other.selfVersion);
        }
    }
}

