/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.install.liteloader;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.jackhuang.hellominecraft.launcher.core.install.liteloader.LiteLoaderVersionList;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftService;
import org.jackhuang.hellominecraft.launcher.core.version.MinecraftLibrary;
import org.jackhuang.hellominecraft.launcher.core.version.MinecraftVersion;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.FileUtils;
import org.jackhuang.hellominecraft.util.tasks.Task;
import org.jackhuang.hellominecraft.util.tasks.communication.PreviousResult;
import org.jackhuang.hellominecraft.util.tasks.communication.PreviousResultRegistrar;

public class LiteLoaderInstaller
extends Task
implements PreviousResultRegistrar<File> {
    public LiteLoaderVersionList.LiteLoaderInstallerVersion version;
    public File installer;
    public String installId;
    public IMinecraftService service;
    ArrayList<PreviousResult<File>> pre = new ArrayList();

    public LiteLoaderInstaller(IMinecraftService service, String installId, LiteLoaderVersionList.LiteLoaderInstallerVersion v) {
        this(service, installId, v, null);
    }

    public LiteLoaderInstaller(IMinecraftService service, String installId, LiteLoaderVersionList.LiteLoaderInstallerVersion v, File installer) {
        this.service = service;
        this.installId = installId;
        this.version = v;
        this.installer = installer;
    }

    @Override
    public void executeTask() throws Exception {
        if (this.installId == null) {
            throw new IllegalStateException(C.i18n("install.no_version", new Object[0]));
        }
        if (this.pre.size() != 1 && this.installer == null) {
            throw new IllegalStateException("No registered previous task.");
        }
        if (this.installer == null) {
            this.installer = this.pre.get(this.pre.size() - 1).getResult();
        }
        MinecraftVersion mv = (MinecraftVersion)this.service.version().getVersionById(this.installId).clone();
        mv.inheritsFrom = mv.id;
        mv.jar = mv.jar == null ? mv.id : mv.jar;
        mv.libraries = new ArrayList<MinecraftLibrary>(Arrays.asList(this.version.libraries));
        MinecraftLibrary ml = new MinecraftLibrary("com.mumfrey:liteloader:" + this.version.selfVersion);
        mv.libraries.add(0, ml);
        FileUtils.copyFile(this.installer, new File(this.service.baseDirectory(), "libraries/com/mumfrey/liteloader/" + this.version.selfVersion + "/liteloader-" + this.version.selfVersion + ".jar"));
        mv.id = mv.id + "-LiteLoader" + this.version.selfVersion;
        mv.mainClass = "net.minecraft.launchwrapper.Launch";
        mv.minecraftArguments = mv.minecraftArguments + " --tweakClass " + this.version.tweakClass;
        File folder = new File(this.service.baseDirectory(), "versions/" + mv.id);
        if (!folder.exists() && folder.mkdirs()) {
            HMCLog.warn("Failed to create new liteloader version " + folder);
        }
        File json = new File(folder, mv.id + ".json");
        HMCLog.log("Creating new version profile..." + mv.id + ".json");
        FileUtils.write(json, C.GSON.toJson(mv));
        this.service.version().refreshVersions();
    }

    @Override
    public String getInfo() {
        return C.i18n("install.liteloader.install", new Object[0]);
    }

    @Override
    public Task registerPreviousResult(PreviousResult pr) {
        this.pre.add(pr);
        return this;
    }
}

