/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.install.optifine;

import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.zip.ZipFile;
import org.jackhuang.hellominecraft.launcher.core.install.InstallerVersionList;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftService;
import org.jackhuang.hellominecraft.launcher.core.version.MinecraftLibrary;
import org.jackhuang.hellominecraft.launcher.core.version.MinecraftVersion;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.FileUtils;
import org.jackhuang.hellominecraft.util.tasks.Task;
import org.jackhuang.hellominecraft.util.tasks.communication.PreviousResult;
import org.jackhuang.hellominecraft.util.tasks.communication.PreviousResultRegistrar;

public class OptiFineInstaller
extends Task
implements PreviousResultRegistrar<File> {
    public File installer;
    public IMinecraftService service;
    public InstallerVersionList.InstallerVersion version;
    public String installId;
    ArrayList<PreviousResult<File>> pre = new ArrayList();

    public OptiFineInstaller(IMinecraftService service, String installId, InstallerVersionList.InstallerVersion version) {
        this(service, installId, version, null);
    }

    public OptiFineInstaller(IMinecraftService service, String installId, InstallerVersionList.InstallerVersion version, File installer) {
        this.service = service;
        this.installId = installId;
        this.installer = installer;
        this.version = version;
    }

    @Override
    public void executeTask() throws Exception {
        if (this.installId == null) {
            throw new Exception(C.i18n("install.no_version", new Object[0]));
        }
        String selfId = this.version.selfVersion;
        MinecraftVersion mv = (MinecraftVersion)this.service.version().getVersionById(this.installId).clone();
        mv.inheritsFrom = mv.id;
        mv.jar = mv.jar == null ? mv.id : mv.jar;
        mv.libraries.clear();
        mv.libraries.add(0, new MinecraftLibrary("optifine:OptiFine:" + selfId));
        FileUtils.copyFile(this.installer, new File(this.service.baseDirectory(), "libraries/optifine/OptiFine/" + selfId + "/OptiFine-" + selfId + ".jar"));
        mv.id = mv.id + "-" + selfId;
        ZipFile zipFile = new ZipFile(this.installer);
        Throwable throwable = null;
        try {
            if (zipFile.getEntry("optifine/OptiFineTweaker.class") != null) {
                if (!mv.mainClass.startsWith("net.minecraft.launchwrapper.")) {
                    mv.mainClass = "net.minecraft.launchwrapper.Launch";
                    mv.libraries.add(1, new MinecraftLibrary("net.minecraft:launchwrapper:1.7"));
                }
                mv.minecraftArguments = mv.minecraftArguments + " --tweakClass optifine.OptiFineTweaker";
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (zipFile != null) {
                if (throwable != null) {
                    try {
                        zipFile.close();
                    }
                    catch (Throwable throwable3) {
                    }
                } else {
                    zipFile.close();
                }
            }
        }
        File loc = new File(this.service.baseDirectory(), "versions/" + mv.id);
        if (!loc.exists() && loc.mkdirs()) {
            HMCLog.warn("Failed to make directories: " + loc);
        }
        File json = new File(loc, mv.id + ".json");
        FileUtils.write(json, C.GSON.toJson((Object)mv, (Type)((Object)MinecraftVersion.class)));
        this.service.version().refreshVersions();
    }

    @Override
    public String getInfo() {
        return "OptiFine Installer";
    }

    @Override
    public Task registerPreviousResult(PreviousResult pr) {
        this.pre.add(pr);
        return this;
    }
}

