/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.install.optifine.vanilla;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jackhuang.hellominecraft.launcher.core.install.InstallerVersionList;
import org.jackhuang.hellominecraft.launcher.core.install.optifine.OptiFineVersion;
import org.jackhuang.hellominecraft.util.ArrayUtils;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.tasks.Task;
import org.jackhuang.hellominecraft.util.tasks.TaskInfo;
import org.jackhuang.hellominecraft.util.tasks.download.HTTPGetTask;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OptiFineVersionList
extends InstallerVersionList {
    private static OptiFineVersionList instance;
    public ArrayList<OptiFineVersion> root = new ArrayList();
    public Map<String, List<InstallerVersionList.InstallerVersion>> versionMap;
    public List<InstallerVersionList.InstallerVersion> versions;

    public static OptiFineVersionList getInstance() {
        if (null == instance) {
            instance = new OptiFineVersionList();
        }
        return instance;
    }

    @Override
    public Task refresh(String[] sss) {
        if (this.versions != null) {
            return null;
        }
        return new TaskInfo(C.i18n("install.optifine.get_list", new Object[0])){
            HTTPGetTask task;
            {
                this.task = new HTTPGetTask("http://optifine.net/downloads");
            }

            @Override
            public Collection<Task> getDependTasks() {
                return Arrays.asList(this.task);
            }

            @Override
            public void executeTask() throws Throwable {
                if (!this.areDependTasksSucceeded) {
                    return;
                }
                String content = this.task.getResult();
                OptiFineVersionList.this.versionMap = new HashMap<String, List<InstallerVersionList.InstallerVersion>>();
                OptiFineVersionList.this.versions = new ArrayList<InstallerVersionList.InstallerVersion>();
                content = content.replace("&nbsp;", " ").replace("&gt;", ">").replace("&lt;", "<").replace("<br>", "<br />");
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = factory.newDocumentBuilder();
                    Document doc = db.parse(new ByteArrayInputStream(content.getBytes("UTF-8")));
                    Element r = doc.getDocumentElement();
                    NodeList tables = r.getElementsByTagName("table");
                    for (int i = 0; i < tables.getLength(); ++i) {
                        Element e = (Element)tables.item(i);
                        if (!"downloadTable".equals(e.getAttribute("class"))) continue;
                        NodeList tr = e.getElementsByTagName("tr");
                        for (int k = 0; k < tr.getLength(); ++k) {
                            NodeList downloadLine = ((Element)tr.item(k)).getElementsByTagName("td");
                            OptiFineVersion v = new OptiFineVersion();
                            for (int j = 0; j < downloadLine.getLength(); ++j) {
                                Element td = (Element)downloadLine.item(j);
                                if (StrUtils.startsWith(td.getAttribute("class"), "downloadLineMirror")) {
                                    v.setMirror(((Element)td.getElementsByTagName("a").item(0)).getAttribute("href"));
                                }
                                if (StrUtils.startsWith(td.getAttribute("class"), "downloadLineDownload")) {
                                    v.setDownloadLink(((Element)td.getElementsByTagName("a").item(0)).getAttribute("href"));
                                }
                                if (StrUtils.startsWith(td.getAttribute("class"), "downloadLineDate")) {
                                    v.setDate(td.getTextContent());
                                }
                                if (!StrUtils.startsWith(td.getAttribute("class"), "downloadLineFile")) continue;
                                v.setVersion(td.getTextContent());
                            }
                            if (StrUtils.isBlank(v.getMCVersion())) {
                                Pattern p = Pattern.compile("OptiFine (.*?) ");
                                Matcher m = p.matcher(v.getVersion());
                                while (m.find()) {
                                    v.setMCVersion(StrUtils.formatVersion(m.group(1)));
                                }
                            }
                            InstallerVersionList.InstallerVersion iv = new InstallerVersionList.InstallerVersion(v.getVersion(), StrUtils.formatVersion(v.getMCVersion()));
                            iv.installer = iv.universal = v.getMirror();
                            OptiFineVersionList.this.root.add(v);
                            OptiFineVersionList.this.versions.add(iv);
                            List ivl = ArrayUtils.tryGetMapWithList(OptiFineVersionList.this.versionMap, StrUtils.formatVersion(v.getMCVersion()));
                            ivl.add(iv);
                        }
                    }
                }
                catch (IOException | ParserConfigurationException | DOMException | SAXException ex) {
                    throw new RuntimeException(ex);
                }
                Collections.sort(OptiFineVersionList.this.versions, InstallerVersionList.InstallerVersionComparator.INSTANCE);
            }
        };
    }

    @Override
    public String getName() {
        return "OptiFine - OptiFine Official Site";
    }

    @Override
    public List<InstallerVersionList.InstallerVersion> getVersionsImpl(String mcVersion) {
        if (this.versions == null || this.versionMap == null) {
            return null;
        }
        if (StrUtils.isBlank(mcVersion)) {
            return this.versions;
        }
        List<InstallerVersionList.InstallerVersion> c = this.versionMap.get(mcVersion);
        if (c == null) {
            return this.versions;
        }
        Collections.sort(c, InstallerVersionList.InstallerVersionComparator.INSTANCE);
        return c;
    }
}

