/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jackhuang.hellominecraft.launcher.core.GameException;
import org.jackhuang.hellominecraft.launcher.core.auth.UserProfileProvider;
import org.jackhuang.hellominecraft.launcher.core.launch.LaunchOptions;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftLoader;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftService;
import org.jackhuang.hellominecraft.launcher.core.version.MinecraftVersion;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.MathUtils;
import org.jackhuang.hellominecraft.util.MessageBox;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.JdkVersion;
import org.jackhuang.hellominecraft.util.system.OS;
import org.jackhuang.hellominecraft.util.system.Platform;

public abstract class AbstractMinecraftLoader
implements IMinecraftLoader {
    protected LaunchOptions options;
    protected UserProfileProvider lr;
    protected File gameDir;
    protected IMinecraftService service;
    protected final MinecraftVersion version;

    public AbstractMinecraftLoader(LaunchOptions options, IMinecraftService service, String versionId, UserProfileProvider lr) throws GameException {
        if (service.version().getVersionById(versionId) == null) {
            throw new GameException("No version: " + versionId);
        }
        this.lr = lr;
        this.options = options;
        this.service = service;
        this.gameDir = service.baseDirectory();
        this.version = service.version().getVersionById(versionId).resolve(service.version());
    }

    @Override
    public MinecraftVersion getMinecraftVersion() {
        return this.version;
    }

    public void makeHeadCommand(List<String> res) {
        HMCLog.log("On making head command.");
        if (StrUtils.isNotBlank(this.options.getWrapper())) {
            res.add(this.options.getWrapper());
        }
        JdkVersion jv = this.options.getJava();
        res.add(this.options.getJavaDir());
        if (this.options.hasJavaArgs()) {
            res.addAll(Arrays.asList(StrUtils.tokenize(this.options.getJavaArgs())));
        }
        if (!this.options.isNoJVMArgs()) {
            this.appendJVMArgs(res);
            if (jv == null || !jv.isEarlyAccess()) {
                if (OS.os() == OS.WINDOWS) {
                    res.add("-XX:HeapDumpPath=MojangTricksIntelDriversForPerformance_javaw.exe_minecraft.exe.heapdump");
                }
                if (jv != null && jv.getParsedVersion() >= 4) {
                    res.add("-XX:+UseG1GC");
                } else {
                    res.add("-Xincgc");
                }
                res.add("-XX:-UseAdaptiveSizePolicy");
                res.add("-XX:-OmitStackTraceInFastThrow");
                res.add("-Xmn128m");
            }
            if (!StrUtils.isBlank(this.options.getPermSize())) {
                if (jv == null || jv.getParsedVersion() < 5) {
                    res.add("-XX:PermSize=" + this.options.getPermSize() + "m");
                } else if (jv.getParsedVersion() >= 5) {
                    res.add("-XX:MetaspaceSize=" + this.options.getPermSize() + "m");
                }
            }
        }
        if (jv != null) {
            HMCLog.log("Java Version: " + jv.getVersion());
            HMCLog.log("Java Platform: " + jv.getPlatform().getBit());
        }
        HMCLog.log("System Platform: " + Platform.getPlatform().getBit());
        if (jv != null && jv.getPlatform() == Platform.BIT_32 && Platform.getPlatform() == Platform.BIT_64) {
            MessageBox.Show(C.i18n("advice.os64butjdk32", new Object[0]));
        }
        if (!StrUtils.isBlank(this.options.getMaxMemory())) {
            int mem = MathUtils.parseMemory(this.options.getMaxMemory(), Integer.MAX_VALUE);
            if (jv != null && jv.getPlatform() == Platform.BIT_32 && mem > 1024) {
                MessageBox.Show(C.i18n("launch.too_big_memory_alloc_64bit", new Object[0]));
            } else {
                long a = OS.getTotalPhysicalMemory() / 1024L / 1024L;
                HMCLog.log("System Physical Memory: " + a);
                if (a > 0L && a < (long)mem) {
                    MessageBox.Show(C.i18n("launch.too_big_memory_alloc_free_space_too_low", a));
                }
            }
            String a = "-Xmx" + this.options.getMaxMemory();
            if (MathUtils.canParseInt(this.options.getMaxMemory())) {
                a = a + "m";
            }
            res.add(a);
        }
        res.add("-Djava.library.path=" + this.service.version().getDecompressNativesToLocation(this.version).getPath());
        res.add("-Dfml.ignoreInvalidMinecraftCertificates=true");
        res.add("-Dfml.ignorePatchDiscrepancies=true");
        if (OS.os() != OS.WINDOWS) {
            res.add("-Duser.home=" + this.gameDir.getParent());
        }
    }

    @Override
    public List<String> makeLaunchingCommand() throws GameException {
        String serverIp;
        HMCLog.log("*** Make shell command ***");
        ArrayList<String> res = new ArrayList<String>();
        this.makeHeadCommand(res);
        this.makeSelf(res);
        HMCLog.log("On making launcher args.");
        if (StrUtils.isNotBlank(this.options.getHeight()) && StrUtils.isNotBlank(this.options.getWidth())) {
            res.add("--height");
            res.add(this.options.getHeight());
            res.add("--width");
            res.add(this.options.getWidth());
        }
        if (StrUtils.isNotBlank(serverIp = this.options.getServerIp())) {
            String[] args = serverIp.split(":");
            res.add("--server");
            res.add(args[0]);
            res.add("--port");
            res.add(args.length > 1 ? args[1] : "25565");
        }
        if (this.options.isFullscreen()) {
            res.add("--fullscreen");
        }
        if (StrUtils.isNotBlank(this.options.getProxyHost()) && StrUtils.isNotBlank(this.options.getProxyPort()) && MathUtils.canParseInt(this.options.getProxyPort())) {
            res.add("--proxyHost");
            res.add(this.options.getProxyHost());
            res.add("--proxyPort");
            res.add(this.options.getProxyPort());
            if (StrUtils.isNotBlank(this.options.getProxyUser()) && StrUtils.isNotBlank(this.options.getProxyPass())) {
                res.add("--proxyUser");
                res.add(this.options.getProxyUser());
                res.add("-=proxyPass");
                res.add(this.options.getProxyPass());
            }
        }
        if (StrUtils.isNotBlank(this.options.getMinecraftArgs())) {
            res.addAll(Arrays.asList(this.options.getMinecraftArgs().split(" ")));
        }
        return res;
    }

    protected abstract void makeSelf(List<String> var1) throws GameException;

    protected void appendJVMArgs(List<String> list) {
    }
}

