/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.launch;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.jackhuang.hellominecraft.launcher.api.PluginManager;
import org.jackhuang.hellominecraft.launcher.core.GameException;
import org.jackhuang.hellominecraft.launcher.core.auth.AuthenticationException;
import org.jackhuang.hellominecraft.launcher.core.auth.IAuthenticator;
import org.jackhuang.hellominecraft.launcher.core.auth.LoginInfo;
import org.jackhuang.hellominecraft.launcher.core.auth.UserProfileProvider;
import org.jackhuang.hellominecraft.launcher.core.download.DownloadLibraryJob;
import org.jackhuang.hellominecraft.launcher.core.launch.LaunchOptions;
import org.jackhuang.hellominecraft.launcher.core.launch.LaunchingState;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftLoader;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftService;
import org.jackhuang.hellominecraft.launcher.core.version.DecompressLibraryJob;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.EventHandler;
import org.jackhuang.hellominecraft.util.MessageBox;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.FileUtils;
import org.jackhuang.hellominecraft.util.system.IOUtils;
import org.jackhuang.hellominecraft.util.system.JavaProcess;
import org.jackhuang.hellominecraft.util.system.OS;
import org.jackhuang.hellominecraft.util.system.ProcessManager;

public class GameLauncher {
    public static final ProcessManager PROCESS_MANAGER = new ProcessManager();
    LaunchOptions options;
    IMinecraftService service;
    LoginInfo info;
    UserProfileProvider result;
    IAuthenticator login;
    public final EventHandler<List<DownloadLibraryJob>> downloadLibrariesEvent = new EventHandler(this);
    public final EventHandler<List<String>> successEvent = new EventHandler(this);
    public final EventHandler<JavaProcess> launchEvent = new EventHandler(this);
    public final EventHandler<LaunchingState> launchingStateChangedEvent = new EventHandler(this);
    public final EventHandler<DecompressLibraryJob> decompressNativesEvent = new EventHandler(this);
    private Object tag;

    public GameLauncher(LaunchOptions options, IMinecraftService version, LoginInfo info, IAuthenticator lg) {
        this.options = options;
        this.service = version;
        this.info = info;
        this.login = lg;
    }

    public Object getTag() {
        return this.tag;
    }

    public void setTag(Object tag) {
        this.tag = tag;
    }

    public IMinecraftLoader makeLaunchCommand() throws AuthenticationException, GameException {
        HMCLog.log("Building process");
        HMCLog.log("Logging in...");
        this.launchingStateChangedEvent.execute(LaunchingState.LoggingIn);
        this.result = this.info != null ? this.login.login(this.info) : this.login.loginBySettings();
        if (this.result == null) {
            throw new AuthenticationException("Result can not be null.");
        }
        PluginManager.plugin().onProcessingLoginResult(this.result);
        this.launchingStateChangedEvent.execute(LaunchingState.GeneratingLaunchingCodes);
        IMinecraftLoader loader = this.service.launch(this.options, this.result);
        File file = this.service.version().getDecompressNativesToLocation(loader.getMinecraftVersion());
        if (file != null) {
            FileUtils.cleanDirectoryQuietly(file);
        }
        if (!this.options.isNotCheckGame()) {
            HMCLog.log("Detecting libraries...");
            this.launchingStateChangedEvent.execute(LaunchingState.DownloadingLibraries);
            if (!this.downloadLibrariesEvent.execute(this.service.download().getDownloadLibraries(loader.getMinecraftVersion()))) {
                throw new GameException("Failed to download libraries");
            }
        }
        HMCLog.log("Unpacking natives...");
        this.launchingStateChangedEvent.execute(LaunchingState.DecompressingNatives);
        DecompressLibraryJob job = this.service.version().getDecompressLibraries(loader.getMinecraftVersion());
        if (!this.decompressNativesEvent.execute(job)) {
            throw new GameException("Failed to decompress natives");
        }
        this.successEvent.execute(loader.makeLaunchingCommand());
        return loader;
    }

    public void launch(List str) throws IOException {
        if (!this.service.version().onLaunch(this.options.getLaunchVersion())) {
            return;
        }
        if (StrUtils.isNotBlank(this.options.getPrecalledCommand())) {
            Process p = Runtime.getRuntime().exec(this.options.getPrecalledCommand());
            try {
                if (p.isAlive()) {
                    p.waitFor();
                }
            }
            catch (InterruptedException ex) {
                HMCLog.warn("Failed to invoke precalled command", ex);
            }
        }
        HMCLog.log("Starting process");
        ProcessBuilder builder = new ProcessBuilder(str);
        if (this.options.getLaunchVersion() == null || this.service.baseDirectory() == null) {
            throw new Error("Fucking bug!");
        }
        builder.redirectErrorStream(true).directory(this.service.version().getRunDirectory(this.options.getLaunchVersion())).environment().put("APPDATA", this.service.baseDirectory().getAbsolutePath());
        JavaProcess jp = new JavaProcess(str, builder.start(), PROCESS_MANAGER);
        HMCLog.log("Have started the process");
        this.launchEvent.execute(jp);
    }

    public File makeLauncher(String launcherName, List str) throws IOException {
        BufferedWriter writer;
        HMCLog.log("Making shell launcher...");
        this.service.version().onLaunch(this.options.getLaunchVersion());
        boolean isWin = OS.os() == OS.WINDOWS;
        File f = new File(launcherName + (isWin ? ".bat" : ".sh"));
        if (!f.exists() && !f.createNewFile()) {
            HMCLog.warn("Failed to create " + f);
        }
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), System.getProperty("sun.jnu.encoding", "UTF-8")));
        }
        catch (UnsupportedEncodingException ex) {
            HMCLog.warn("Failed to create writer, will try again.", ex);
            writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(f)));
        }
        if (isWin) {
            writer.write("@echo off");
            writer.newLine();
            String appdata = IOUtils.tryGetCanonicalFilePath(this.service.baseDirectory());
            if (appdata != null) {
                writer.write("set appdata=" + appdata);
                writer.newLine();
                writer.write("cd %appdata%");
                writer.newLine();
            }
        }
        if (StrUtils.isNotBlank(this.options.getPrecalledCommand())) {
            writer.write(this.options.getPrecalledCommand());
            writer.newLine();
        }
        writer.write(StrUtils.makeCommand(str));
        writer.close();
        if (!f.setExecutable(true)) {
            HMCLog.warn("Failed to give launcher permission.");
            MessageBox.Show(C.i18n("launch.failed_sh_permission", new Object[0]));
        }
        HMCLog.log("Command: " + StrUtils.parseParams("", str, " "));
        return f;
    }
}

