/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.launch;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jackhuang.hellominecraft.launcher.core.GameException;
import org.jackhuang.hellominecraft.launcher.core.auth.UserProfileProvider;
import org.jackhuang.hellominecraft.launcher.core.launch.AbstractMinecraftLoader;
import org.jackhuang.hellominecraft.launcher.core.launch.LaunchOptions;
import org.jackhuang.hellominecraft.launcher.core.launch.MinecraftLoader$$Lambda$1;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftService;
import org.jackhuang.hellominecraft.launcher.core.version.MinecraftLibrary;
import org.jackhuang.hellominecraft.launcher.core.version.MinecraftVersion;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.func.BiFunction;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.IOUtils;
import org.jackhuang.hellominecraft.util.system.OS;

public class MinecraftLoader
extends AbstractMinecraftLoader {
    private final BiFunction<MinecraftVersion, Boolean, String> DEFAULT_ASSET_PROVIDER = MinecraftLoader$$Lambda$1.lambdaFactory$(this);
    private BiFunction<MinecraftVersion, Boolean, String> assetProvider = this.DEFAULT_ASSET_PROVIDER;

    public MinecraftLoader(LaunchOptions p, IMinecraftService provider, UserProfileProvider lr) throws GameException {
        super(p, provider, p.getLaunchVersion(), lr);
    }

    @Override
    protected void makeSelf(List<String> res) throws GameException {
        StringBuilder library = new StringBuilder("");
        for (MinecraftLibrary l : this.version.libraries) {
            if (!l.allow() || l.isRequiredToUnzip()) continue;
            library.append(l.getFilePath(this.gameDir).getAbsolutePath()).append(File.pathSeparator);
        }
        File f = this.version.getJar(this.service.baseDirectory());
        if (!f.exists()) {
            throw new GameException("Minecraft jar does not exists");
        }
        library.append(IOUtils.tryGetCanonicalFilePath(f)).append(File.pathSeparator);
        res.add("-cp");
        res.add(library.toString().substring(0, library.length() - File.pathSeparator.length()));
        res.add(this.version.mainClass);
        String[] splitted = StrUtils.tokenize(this.version.minecraftArguments);
        String game_assets = this.assetProvider.apply(this.version, !this.options.isNotCheckGame());
        for (String t : splitted) {
            t = t.replace("${auth_player_name}", this.lr.getUserName());
            t = t.replace("${auth_session}", this.lr.getSession());
            t = t.replace("${auth_uuid}", this.lr.getUserId());
            t = t.replace("${version_name}", this.options.getVersionName());
            t = t.replace("${profile_name}", this.options.getName());
            t = t.replace("${version_type}", this.options.getType());
            t = t.replace("${game_directory}", this.service.version().getRunDirectory(this.version.id).getAbsolutePath());
            t = t.replace("${game_assets}", game_assets);
            t = t.replace("${assets_root}", this.service.asset().getAssets().getAbsolutePath());
            t = t.replace("${auth_access_token}", this.lr.getAccessToken());
            t = t.replace("${user_type}", this.lr.getUserType());
            t = t.replace("${assets_index_name}", this.version.getAssetsIndex().getId());
            t = t.replace("${user_properties}", this.lr.getUserProperties());
            res.add(t);
        }
        if (res.indexOf("--gameDir") != -1 && res.indexOf("--workDir") != -1) {
            res.add("--workDir");
            res.add(this.gameDir.getAbsolutePath());
        }
    }

    @Override
    protected void appendJVMArgs(List<String> list) {
        super.appendJVMArgs(list);
        try {
            if (OS.os() == OS.OSX) {
                list.add("-Xdock:icon=" + this.service.asset().getAssetObject(this.version.getAssetsIndex().getId(), "icons/minecraft.icns").getAbsolutePath());
                list.add("-Xdock:name=Minecraft");
            }
        }
        catch (IOException e) {
            HMCLog.err("Failed to append jvm arguments when searching for asset objects.", e);
        }
    }

    public void setAssetProvider(BiFunction<MinecraftVersion, Boolean, String> assetProvider) {
        this.assetProvider = assetProvider == null ? this.DEFAULT_ASSET_PROVIDER : assetProvider;
    }

    private /* synthetic */ String lambda$new$8(MinecraftVersion t, Boolean allow) {
        return new File(this.service.baseDirectory(), "assets").getAbsolutePath();
    }

    static /* synthetic */ String access$lambda$0(MinecraftLoader minecraftLoader, MinecraftVersion minecraftVersion, Boolean bl) {
        return minecraftLoader.lambda$new$8(minecraftVersion, bl);
    }
}

