/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.mod;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jackhuang.hellominecraft.launcher.core.mod.ModInfo;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftModService;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftService;
import org.jackhuang.hellominecraft.util.code.DigestUtils;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.FileUtils;

public class MinecraftModService
extends IMinecraftModService {
    Map<String, List<ModInfo>> modCache = Collections.synchronizedMap(new HashMap());

    public MinecraftModService(IMinecraftService service) {
        super(service);
    }

    @Override
    public List<ModInfo> getMods(String id) {
        if (this.modCache.containsKey(id)) {
            return this.modCache.get(id);
        }
        return this.recacheMods(id);
    }

    @Override
    public List<ModInfo> recacheMods(String id) {
        File modsFolder = this.service.version().getRunDirectory(id, "mods");
        ArrayList<ModInfo> mods = new ArrayList<ModInfo>();
        File[] fs = modsFolder.listFiles();
        if (fs != null) {
            for (File f : fs) {
                File[] ss;
                if (ModInfo.isFileMod(f)) {
                    mods.add(ModInfo.readModInfo(f));
                    continue;
                }
                if (!f.isDirectory() || (ss = f.listFiles()) == null) continue;
                for (File ff : ss) {
                    if (!ModInfo.isFileMod(ff)) continue;
                    mods.add(ModInfo.readModInfo(ff));
                }
            }
        }
        Collections.sort(mods);
        this.modCache.put(id, mods);
        return mods;
    }

    @Override
    public boolean addMod(String id, File f) {
        try {
            File modsFolder;
            if (!ModInfo.isFileMod(f)) {
                return false;
            }
            if (!this.modCache.containsKey(id)) {
                this.recacheMods(id);
            }
            if (!(modsFolder = this.service.version().getRunDirectory(id, "mods")).exists() && !modsFolder.mkdirs()) {
                HMCLog.warn("Failed to make directories: " + modsFolder);
            }
            File newf = new File(modsFolder, f.getName());
            FileUtils.copyFile(f, newf);
            ModInfo i = ModInfo.readModInfo(f);
            this.modCache.get(id).add(i);
            return true;
        }
        catch (IOException ex) {
            HMCLog.warn("Failed to copy mod", ex);
            return false;
        }
    }

    @Override
    public void removeMod(String id, Object[] rows) {
        if (rows.length == 0) {
            return;
        }
        for (Object r : rows) {
            if (r instanceof ModInfo) {
                if (((ModInfo)r).location.delete()) continue;
                HMCLog.warn("Failed to delete mod" + r);
                continue;
            }
            if (!(r instanceof Number) || this.getMods((String)id).get((int)((Number)r).intValue()).location.delete()) continue;
            HMCLog.warn("Failed to delete mod " + r + ", maybe not a file?");
        }
        this.recacheMods(id);
    }

    public String[] checkMd5s(String id) throws IOException {
        String[] res = new String[this.getMods(id).size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = DigestUtils.md5Hex(new FileInputStream(this.getMods((String)id).get((int)i).location));
        }
        return res;
    }
}

