/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.version;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jackhuang.hellominecraft.launcher.core.GameException;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftProvider;
import org.jackhuang.hellominecraft.launcher.core.version.AssetIndexDownloadInfo;
import org.jackhuang.hellominecraft.launcher.core.version.GameDownloadInfo;
import org.jackhuang.hellominecraft.launcher.core.version.IMinecraftLibrary;
import org.jackhuang.hellominecraft.launcher.core.version.MinecraftLibrary;
import org.jackhuang.hellominecraft.launcher.core.version.MinecraftVersion$$Lambda$1;
import org.jackhuang.hellominecraft.util.ArrayUtils;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.Utils;

public class MinecraftVersion
implements Cloneable,
Comparable<MinecraftVersion> {
    public String minecraftArguments;
    public String mainClass;
    public String time;
    public String id;
    public String type;
    public String processArguments;
    public String releaseTime;
    public String jar;
    public String inheritsFrom;
    public String runDir;
    protected String assets;
    public int minimumLauncherVersion;
    public boolean hidden;
    public AssetIndexDownloadInfo assetIndex;
    private Map<String, GameDownloadInfo> downloads;
    public ArrayList<MinecraftLibrary> libraries;

    public MinecraftVersion() {
    }

    public MinecraftVersion(String minecraftArguments, String mainClass, String time, String id, String type, String processArguments, String releaseTime, String assets, String jar, String inheritsFrom, String runDir, int minimumLauncherVersion, List<MinecraftLibrary> libraries, boolean hidden, Map<String, GameDownloadInfo> downloads, AssetIndexDownloadInfo assetIndexDownloadInfo) {
        this();
        this.minecraftArguments = minecraftArguments;
        this.mainClass = mainClass;
        this.time = time;
        this.id = id;
        this.type = type;
        this.processArguments = processArguments;
        this.releaseTime = releaseTime;
        this.assets = assets;
        this.jar = jar;
        this.inheritsFrom = inheritsFrom;
        this.minimumLauncherVersion = minimumLauncherVersion;
        this.hidden = hidden;
        this.runDir = runDir;
        this.assetIndex = assetIndexDownloadInfo == null ? null : (AssetIndexDownloadInfo)assetIndexDownloadInfo.clone();
        if (libraries == null) {
            this.libraries = new ArrayList();
        } else {
            this.libraries = new ArrayList(libraries.size());
            for (MinecraftLibrary minecraftLibrary : libraries) {
                if (minecraftLibrary == null) continue;
                this.libraries.add((MinecraftLibrary)minecraftLibrary.clone());
            }
        }
        if (downloads == null) {
            this.downloads = null;
        } else {
            this.downloads = new HashMap<String, GameDownloadInfo>(downloads.size());
            for (Map.Entry entry : downloads.entrySet()) {
                this.downloads.put((String)entry.getKey(), (GameDownloadInfo)((GameDownloadInfo)entry.getValue()).clone());
            }
        }
    }

    public Object clone() {
        try {
            MinecraftVersion mv = (MinecraftVersion)super.clone();
            mv.libraries = (ArrayList)mv.libraries.clone();
            return mv;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public MinecraftVersion resolve(IMinecraftProvider provider) throws GameException {
        return this.resolve(provider, new HashSet<String>());
    }

    protected MinecraftVersion resolve(IMinecraftProvider provider, Set<String> resolvedSoFar) throws GameException {
        if (this.inheritsFrom == null) {
            return this;
        }
        if (!resolvedSoFar.add(this.id)) {
            throw new GameException(C.i18n("launch.circular_dependency_versions", new Object[0]));
        }
        MinecraftVersion parent = provider.getVersionById(this.inheritsFrom);
        if (parent == null) {
            if (!provider.install(this.inheritsFrom, MinecraftVersion$$Lambda$1.lambdaFactory$())) {
                return this;
            }
            parent = provider.getVersionById(this.inheritsFrom);
        }
        parent = parent.resolve(provider, resolvedSoFar);
        MinecraftVersion result = new MinecraftVersion(this.minecraftArguments != null ? this.minecraftArguments : parent.minecraftArguments, this.mainClass != null ? this.mainClass : parent.mainClass, this.time, this.id, this.type, parent.processArguments, this.releaseTime, this.assets != null ? this.assets : parent.assets, this.jar != null ? this.jar : parent.jar, null, this.runDir, parent.minimumLauncherVersion, this.libraries != null ? ArrayUtils.merge(this.libraries, parent.libraries) : parent.libraries, this.hidden, this.downloads != null ? this.downloads : parent.downloads, this.assetIndex != null ? this.assetIndex : parent.assetIndex);
        return result;
    }

    public File getJar(File gameDir) {
        String jarId = this.jar == null ? this.id : this.jar;
        return new File(gameDir, "versions/" + jarId + "/" + jarId + ".jar");
    }

    public File getJar(File gameDir, String suffix) {
        String jarId = this.jar == null ? this.id : this.jar;
        return new File(gameDir, "versions/" + jarId + "/" + jarId + suffix + ".jar");
    }

    public File getNatives(File gameDir) {
        return new File(gameDir, "versions/" + this.id + "/" + this.id + "-natives");
    }

    public boolean isAllowedToUnpackNatives() {
        return true;
    }

    @Override
    public int compareTo(MinecraftVersion o) {
        return this.id.compareTo(o.id);
    }

    public AssetIndexDownloadInfo getAssetsIndex() {
        if (this.assetIndex == null) {
            this.assetIndex = new AssetIndexDownloadInfo((String)Utils.firstNonNull(this.assets, "legacy"));
        }
        return this.assetIndex;
    }

    public GameDownloadInfo getClientDownloadInfo() {
        if (this.downloads == null) {
            this.downloads = new HashMap<String, GameDownloadInfo>();
        }
        if (!this.downloads.containsKey("client")) {
            this.downloads.put("client", new GameDownloadInfo());
        }
        GameDownloadInfo i = this.downloads.get("client");
        if (i.id == null) {
            i.id = this.id;
        }
        return i;
    }

    public Set<IMinecraftLibrary> getLibraries() {
        return this.libraries == null ? new HashSet<IMinecraftLibrary>() : new HashSet<MinecraftLibrary>(this.libraries);
    }

    static /* synthetic */ void access$lambda$0(MinecraftVersion minecraftVersion) {
        minecraftVersion.hidden = true;
    }
}

