/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.version;

import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.jackhuang.hellominecraft.launcher.core.GameException;
import org.jackhuang.hellominecraft.launcher.core.MCUtils;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftProvider;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftService;
import org.jackhuang.hellominecraft.launcher.core.version.DecompressLibraryJob;
import org.jackhuang.hellominecraft.launcher.core.version.Extract;
import org.jackhuang.hellominecraft.launcher.core.version.IMinecraftLibrary;
import org.jackhuang.hellominecraft.launcher.core.version.MinecraftClassicVersion;
import org.jackhuang.hellominecraft.launcher.core.version.MinecraftVersion;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.MessageBox;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.func.Consumer;
import org.jackhuang.hellominecraft.util.func.Predicate;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.FileUtils;
import org.jackhuang.hellominecraft.util.system.IOUtils;
import org.jackhuang.hellominecraft.util.tasks.TaskWindow;
import org.jackhuang.hellominecraft.util.ui.SwingUtils;

public class MinecraftVersionManager
extends IMinecraftProvider {
    final Map<String, MinecraftVersion> versions = new TreeMap<String, MinecraftVersion>();

    public MinecraftVersionManager(IMinecraftService p) {
        super(p);
    }

    @Override
    public Collection<MinecraftVersion> getVersions() {
        return this.versions.values();
    }

    @Override
    public int getVersionCount() {
        return this.versions.size();
    }

    @Override
    public synchronized void refreshVersions() {
        File version;
        File[] files;
        this.onRefreshingVersions.execute(this.service);
        try {
            MCUtils.tryWriteProfile(this.service.baseDirectory());
        }
        catch (IOException ex) {
            HMCLog.warn("Failed to create launcher_profiles.json, Forge/LiteLoader installer will not work.", ex);
        }
        this.versions.clear();
        File oldDir = new File(this.service.baseDirectory(), "bin");
        if (oldDir.exists()) {
            MinecraftClassicVersion v = new MinecraftClassicVersion();
            this.versions.put(v.id, v);
        }
        if ((files = (version = new File(this.service.baseDirectory(), "versions")).listFiles()) != null && files.length > 0) {
            for (File dir : files) {
                MinecraftVersion mcVersion;
                String id = dir.getName();
                File jsonFile = new File(dir, id + ".json");
                if (!dir.isDirectory()) continue;
                boolean ask = false;
                File[] jsons = null;
                if (!jsonFile.exists() && (jsons = FileUtils.searchSuffix(dir, "json")).length == 1) {
                    ask = true;
                }
                if (ask) {
                    HMCLog.warn("Found not matched filenames version: " + id + ", json: " + jsons[0].getName());
                    if (MessageBox.Show(String.format(C.i18n("launcher.versions_json_not_matched", new Object[0]), id, jsons[0].getName()), 10) == 0 && !jsons[0].renameTo(new File(jsons[0].getParent(), id + ".json"))) {
                        HMCLog.warn("Failed to rename version json " + jsons[0]);
                    }
                }
                if (!jsonFile.exists()) {
                    if (MessageBox.Show(C.i18n("launcher.versions_json_not_matched_cannot_auto_completion", id), 10) != 0) continue;
                    FileUtils.deleteDirectoryQuietly(dir);
                    continue;
                }
                try {
                    mcVersion = C.GSON.fromJson(FileUtils.read(jsonFile), MinecraftVersion.class);
                    if (mcVersion == null) {
                        throw new GameException("Wrong json format, got null.");
                    }
                }
                catch (Exception e) {
                    HMCLog.warn("Found wrong format json, try to fix it.", e);
                    if (MessageBox.Show(C.i18n("launcher.versions_json_not_formatted", id), 10) != 0) continue;
                    this.service.download().downloadMinecraftVersionJson(id);
                    try {
                        mcVersion = C.GSON.fromJson(FileUtils.read(jsonFile), MinecraftVersion.class);
                        if (mcVersion == null) {
                            throw new GameException("Wrong json format, got null.");
                        }
                    }
                    catch (JsonSyntaxException | IOException | GameException ex) {
                        HMCLog.warn("Ignoring: " + dir + ", the json of this Minecraft is malformed.", ex);
                        continue;
                    }
                }
                try {
                    if (!id.equals(mcVersion.id)) {
                        HMCLog.warn("Found: " + dir + ", it contains id: " + mcVersion.id + ", expected: " + id + ", this app will fix this problem.");
                        mcVersion.id = id;
                        FileUtils.writeQuietly(jsonFile, C.GSON.toJson(mcVersion));
                    }
                    this.versions.put(id, mcVersion);
                    this.onLoadedVersion.execute(id);
                }
                catch (Exception e) {
                    HMCLog.warn("Ignoring: " + dir + ", the json of this Minecraft is malformed.", e);
                }
            }
        }
        this.onRefreshedVersions.execute(this.service);
    }

    @Override
    public File versionRoot(String id) {
        return new File(this.service.baseDirectory(), "versions/" + id);
    }

    @Override
    public boolean removeVersionFromDisk(String name) {
        File version = this.versionRoot(name);
        if (!version.exists()) {
            return true;
        }
        this.versions.remove(name);
        return FileUtils.deleteDirectoryQuietly(version);
    }

    @Override
    public boolean renameVersion(String from, String to) {
        try {
            File newJar;
            File fromJson = new File(this.versionRoot(from), from + ".json");
            MinecraftVersion mcVersion = C.GSON.fromJson(FileUtils.read(fromJson), MinecraftVersion.class);
            mcVersion.id = to;
            FileUtils.writeQuietly(fromJson, C.GSON.toJson(mcVersion));
            File toDir = this.versionRoot(to);
            if (!this.versionRoot(from).renameTo(toDir)) {
                HMCLog.warn("MinecraftVersionManager.RenameVersion: Failed to rename version root " + from + " to " + to);
            }
            File toJson = new File(toDir, to + ".json");
            File toJar = new File(toDir, to + ".jar");
            if (new File(toDir, from + ".json").renameTo(toJson)) {
                HMCLog.warn("MinecraftVersionManager.RenameVersion: Failed to rename json");
            }
            if ((newJar = new File(toDir, from + ".jar")).exists() && !newJar.renameTo(toJar)) {
                HMCLog.warn("Failed to rename pre jar " + newJar + " to new jar " + toJar);
            }
            return true;
        }
        catch (JsonSyntaxException | IOException e) {
            HMCLog.warn("Failed to rename " + from + " to " + to + ", the json of this Minecraft is malformed.", e);
            return false;
        }
    }

    @Override
    public File getRunDirectory(String id) {
        if (this.getVersionById(id) != null && "version".equals(this.getVersionById((String)id).runDir)) {
            return this.versionRoot(id);
        }
        return this.baseDirectory();
    }

    @Override
    public boolean install(String id, Consumer<MinecraftVersion> callback) {
        if (!TaskWindow.factory().append(this.service.download().downloadMinecraft(id)).create()) {
            return false;
        }
        if (callback != null) {
            File mvt = new File(this.versionRoot(id), id + ".json");
            MinecraftVersion v = C.GSON.fromJson(FileUtils.readQuietly(mvt), MinecraftVersion.class);
            if (v == null) {
                return false;
            }
            callback.accept(v);
            FileUtils.writeQuietly(mvt, C.GSON.toJson(v));
        }
        this.refreshVersions();
        return true;
    }

    @Override
    public void open(String mv, String name) {
        SwingUtils.openFolder(name == null ? this.getRunDirectory(mv) : new File(this.getRunDirectory(mv), name));
    }

    @Override
    public DecompressLibraryJob getDecompressLibraries(MinecraftVersion v) throws GameException {
        if (v.libraries == null) {
            throw new GameException("Wrong format: minecraft.json");
        }
        ArrayList<File> unzippings = new ArrayList<File>();
        ArrayList<Extract> extractRules = new ArrayList<Extract>();
        for (IMinecraftLibrary iMinecraftLibrary : v.libraries) {
            if (!iMinecraftLibrary.isRequiredToUnzip() || !v.isAllowedToUnpackNatives()) continue;
            unzippings.add(IOUtils.tryGetCanonicalFile(iMinecraftLibrary.getFilePath(this.service.baseDirectory())));
            extractRules.add(iMinecraftLibrary.getDecompressExtractRules());
        }
        return new DecompressLibraryJob(unzippings.toArray(new File[unzippings.size()]), extractRules.toArray(new Extract[extractRules.size()]), this.getDecompressNativesToLocation(v));
    }

    @Override
    public File getDecompressNativesToLocation(MinecraftVersion v) {
        return v == null ? null : v.getNatives(this.service.baseDirectory());
    }

    @Override
    public File getMinecraftJar(String id) {
        if (this.versions.containsKey(id)) {
            return this.versions.get(id).getJar(this.service.baseDirectory());
        }
        return null;
    }

    @Override
    public MinecraftVersion getOneVersion(Predicate<MinecraftVersion> pred) {
        for (MinecraftVersion v : this.versions.values()) {
            if (pred != null && !pred.apply(v)) continue;
            return v;
        }
        return null;
    }

    @Override
    public MinecraftVersion getVersionById(String id) {
        return StrUtils.isBlank(id) ? null : this.versions.get(id);
    }

    @Override
    public boolean onLaunch(String id) {
        File resourcePacks = new File(this.getRunDirectory(id), "resourcepacks");
        if (!resourcePacks.exists() && !resourcePacks.mkdirs()) {
            HMCLog.warn("Failed to make resourcePacks: " + resourcePacks);
        }
        return true;
    }

    @Override
    public void cleanFolder() {
        for (MinecraftVersion s : this.getVersions()) {
            String[] files;
            String[] dir;
            FileUtils.deleteDirectoryQuietly(new File(this.versionRoot(s.id), s.id + "-natives"));
            File f = this.getRunDirectory(s.id);
            for (String str : dir = new String[]{"natives", "native", "$native", "AMD", "crash-reports", "logs", "asm", "NVIDIA", "server-resource-packs", "natives", "native"}) {
                FileUtils.deleteDirectoryQuietly(new File(f, str));
            }
            for (String str : files = new String[]{"output-client.log", "usercache.json", "usernamecache.json", "hmclmc.log"}) {
                if (new File(f, str).delete()) continue;
                HMCLog.warn("Failed to delete " + str);
            }
        }
    }

    @Override
    public void initializeMiencraft() {
    }
}

