/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.setting;

import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.jackhuang.hellominecraft.launcher.Main;
import org.jackhuang.hellominecraft.launcher.core.MCUtils;
import org.jackhuang.hellominecraft.launcher.core.download.DownloadType;
import org.jackhuang.hellominecraft.launcher.setting.Config;
import org.jackhuang.hellominecraft.launcher.setting.Profile;
import org.jackhuang.hellominecraft.launcher.setting.Settings$$Lambda$1;
import org.jackhuang.hellominecraft.launcher.setting.Settings$$Lambda$2;
import org.jackhuang.hellominecraft.launcher.setting.Settings$$Lambda$3;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.CollectionUtils;
import org.jackhuang.hellominecraft.util.EventHandler;
import org.jackhuang.hellominecraft.util.MessageBox;
import org.jackhuang.hellominecraft.util.UpdateChecker;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.FileUtils;

public final class Settings {
    public static final String DEFAULT_PROFILE = "Default";
    public static final String HOME_PROFILE = "Home";
    public static final File SETTINGS_FILE = new File("hmcl.json");
    private static final Config SETTINGS;
    public static final UpdateChecker UPDATE_CHECKER;
    public static final EventHandler<Profile> profileChangedEvent;
    public static final EventHandler<Void> profileLoadingEvent;

    public static Config getInstance() {
        return SETTINGS;
    }

    private static Config initSettings() {
        Config c = new Config();
        if (SETTINGS_FILE.exists()) {
            try {
                String str = FileUtils.read(SETTINGS_FILE);
                if (str == null || str.trim().equals("")) {
                    HMCLog.log("Settings file is empty, use the default settings.");
                } else {
                    Config d = C.GSON.fromJson(str, Config.class);
                    if (d != null) {
                        c = d;
                    }
                }
                HMCLog.log("Initialized settings.");
            }
            catch (JsonSyntaxException | IOException e) {
                HMCLog.warn("Something happened wrongly when load settings.", e);
            }
        } else {
            HMCLog.log("No settings file here, may be first loading.");
            if (!c.getConfigurations().containsKey(HOME_PROFILE)) {
                c.getConfigurations().put(HOME_PROFILE, new Profile(HOME_PROFILE, MCUtils.getLocation().getPath()));
            }
        }
        return c;
    }

    public static void save() {
        try {
            FileUtils.write(SETTINGS_FILE, C.GSON.toJson(SETTINGS));
        }
        catch (IOException ex) {
            HMCLog.err("Failed to save config", ex);
        }
    }

    public static Profile getLastProfile() {
        if (!Settings.hasProfile(Settings.getInstance().getLast())) {
            Settings.getInstance().setLast(DEFAULT_PROFILE);
        }
        return Settings.getProfile(Settings.getInstance().getLast());
    }

    public static Profile getProfile(String name) {
        Profile p;
        if (name == null) {
            name = DEFAULT_PROFILE;
        }
        if ((p = Settings.getProfiles().get(name)) == null) {
            if (Settings.getProfiles().containsKey(DEFAULT_PROFILE)) {
                p = Settings.getProfiles().get(DEFAULT_PROFILE);
            } else {
                p = new Profile();
                Settings.getProfiles().put(DEFAULT_PROFILE, p);
            }
        }
        return p;
    }

    public static boolean hasProfile(String name) {
        if (name == null) {
            name = DEFAULT_PROFILE;
        }
        return Settings.getProfiles().containsKey(name);
    }

    public static Map<String, Profile> getProfiles() {
        return SETTINGS.getConfigurations();
    }

    public static void setProfile(Profile ver) {
        Settings.getProfiles().put(ver.getName(), ver);
    }

    public static Collection<Profile> getProfilesFiltered() {
        return CollectionUtils.map(Settings.getProfiles().values(), Settings$$Lambda$1.lambdaFactory$());
    }

    public static Profile getOneProfile() {
        return SETTINGS.getConfigurations().firstEntry().getValue();
    }

    public static boolean putProfile(Profile ver) {
        if (ver == null || ver.getName() == null || Settings.getProfiles().containsKey(ver.getName())) {
            return false;
        }
        Settings.getProfiles().put(ver.getName(), ver);
        return true;
    }

    public static boolean delProfile(Profile ver) {
        return Settings.delProfile(ver.getName());
    }

    public static boolean delProfile(String ver) {
        boolean flag;
        if (DEFAULT_PROFILE.equals(ver)) {
            MessageBox.Show(C.i18n("settings.cannot_remove_default_config", new Object[0]));
            return false;
        }
        boolean notify = false;
        if (Settings.getLastProfile().getName().equals(ver)) {
            notify = true;
        }
        boolean bl = flag = Settings.getProfiles().remove(ver) != null;
        if (notify && flag) {
            Settings.onProfileChanged();
        }
        return flag;
    }

    static void onProfileChanged() {
        Profile p = Settings.getLastProfile();
        if (p == null) {
            throw new Error("No profiles here, it should not happen");
        }
        profileChangedEvent.execute(p);
        p.onSelected();
    }

    public static void onProfileLoading() {
        profileLoadingEvent.execute(null);
        Settings.onProfileChanged();
    }

    private static /* synthetic */ boolean lambda$getProfilesFiltered$13(Profile t) {
        return t != null && t.getName() != null;
    }

    static {
        UPDATE_CHECKER = new UpdateChecker(Main.getVersionNumber(), "hmcl");
        SETTINGS = Settings.initSettings();
        Settings.SETTINGS.downloadTypeChangedEvent.register(Settings$$Lambda$2.lambdaFactory$());
        DownloadType.setSuggestedDownloadType(SETTINGS.getDownloadSource());
        if (!Settings.getProfiles().containsKey(DEFAULT_PROFILE)) {
            Settings.getProfiles().put(DEFAULT_PROFILE, new Profile(DEFAULT_PROFILE));
        }
        for (Map.Entry<String, Profile> entry : Settings.getProfiles().entrySet()) {
            Profile e = entry.getValue();
            e.setName(entry.getKey());
            e.checkFormat();
            e.propertyChanged.register(Settings$$Lambda$3.lambdaFactory$());
        }
        profileChangedEvent = new EventHandler(null);
        profileLoadingEvent = new EventHandler(null);
    }

    static /* synthetic */ boolean access$lambda$0(Profile profile) {
        return Settings.lambda$getProfilesFiltered$13(profile);
    }

    static /* synthetic */ void access$lambda$1() {
        Settings.save();
    }
}

