/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.setting;

import java.io.File;
import java.io.IOException;
import org.jackhuang.hellominecraft.launcher.Main;
import org.jackhuang.hellominecraft.launcher.core.launch.LaunchOptions;
import org.jackhuang.hellominecraft.launcher.core.version.GameDirType;
import org.jackhuang.hellominecraft.launcher.setting.Settings;
import org.jackhuang.hellominecraft.launcher.util.LauncherVisibility;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.EventHandler;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.Utils;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.Java;
import org.jackhuang.hellominecraft.util.system.JdkVersion;

public class VersionSetting {
    public transient String id;
    private String javaArgs;
    private String minecraftArgs = "";
    private String maxMemory;
    private String permSize;
    private String width;
    private String height;
    private String javaDir = "";
    private String precalledCommand = "";
    private String serverIp = "";
    private String java = "";
    private String wrapper = "";
    private boolean fullscreen = false;
    private boolean noJVMArgs;
    private boolean notCheckGame;
    private int launcherVisibility = 1;
    private int gameDirType = 0;
    public final transient EventHandler<String> propertyChanged = new EventHandler(this);

    public VersionSetting() {
    }

    public VersionSetting(VersionSetting v) {
        this();
        if (v == null) {
            return;
        }
        this.maxMemory = v.maxMemory;
        this.width = v.width;
        this.height = v.height;
        this.java = v.java;
        this.fullscreen = v.fullscreen;
        this.javaArgs = v.javaArgs;
        this.javaDir = v.javaDir;
        this.minecraftArgs = v.minecraftArgs;
        this.permSize = v.permSize;
        this.gameDirType = v.gameDirType;
        this.noJVMArgs = v.noJVMArgs;
        this.launcherVisibility = v.launcherVisibility;
        this.precalledCommand = v.precalledCommand;
        this.wrapper = v.wrapper;
        this.serverIp = v.serverIp;
    }

    public String getJavaDir() {
        Java j = this.getJava();
        if (j.getHome() == null) {
            return this.javaDir;
        }
        return j.getJava();
    }

    public String getSettingsJavaDir() {
        return this.javaDir;
    }

    public File getJavaDirFile() {
        return new File(this.getJavaDir());
    }

    public void setJavaDir(String javaDir) {
        this.javaDir = javaDir;
        this.propertyChanged.execute("javaDir");
    }

    public Java getJava() {
        return Java.JAVA.get(this.getJavaIndexInAllJavas());
    }

    public int getJavaIndexInAllJavas() {
        int idx;
        if (StrUtils.isBlank(this.java) && StrUtils.isNotBlank(this.javaDir)) {
            this.java = "Custom";
        }
        if ((idx = Java.JAVA.indexOf(new Java(this.java, null))) == -1) {
            this.java = Java.suggestedJava().getName();
            idx = 0;
        }
        return idx;
    }

    public void setJava(Java java) {
        if (java == null) {
            this.java = Java.JAVA.get(0).getName();
        } else {
            int idx = Java.JAVA.indexOf(java);
            if (idx == -1) {
                return;
            }
            this.java = java.getName();
        }
        this.propertyChanged.execute("java");
    }

    public String getJavaArgs() {
        if (StrUtils.isBlank(this.javaArgs)) {
            return "";
        }
        return this.javaArgs;
    }

    public void setJavaArgs(String javaArgs) {
        this.javaArgs = javaArgs;
        this.propertyChanged.execute("javaArgs");
    }

    public boolean hasJavaArgs() {
        return StrUtils.isNotBlank(this.getJavaArgs().trim());
    }

    public String getMaxMemory() {
        if (StrUtils.isBlank(this.maxMemory)) {
            return String.valueOf(Utils.getSuggestedMemorySize());
        }
        return this.maxMemory;
    }

    public void setMaxMemory(String maxMemory) {
        this.maxMemory = maxMemory;
        this.propertyChanged.execute("maxMemory");
    }

    public String getWidth() {
        if (StrUtils.isBlank(this.width)) {
            return "854";
        }
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
        this.propertyChanged.execute("width");
    }

    public String getHeight() {
        if (StrUtils.isBlank(this.height)) {
            return "480";
        }
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
        this.propertyChanged.execute("height");
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public void setFullscreen(boolean fullscreen) {
        this.fullscreen = fullscreen;
        this.propertyChanged.execute("fullscreen");
    }

    public LauncherVisibility getLauncherVisibility() {
        return LauncherVisibility.values()[this.launcherVisibility];
    }

    public void setLauncherVisibility(LauncherVisibility launcherVisibility) {
        this.launcherVisibility = launcherVisibility.ordinal();
        this.propertyChanged.execute("launcherVisibility");
    }

    public GameDirType getGameDirType() {
        if (this.gameDirType < 0 || this.gameDirType > 1) {
            this.setGameDirType(GameDirType.ROOT_FOLDER);
        }
        return GameDirType.values()[this.gameDirType];
    }

    public void setGameDirType(GameDirType gameDirType) {
        this.gameDirType = gameDirType.ordinal();
        this.propertyChanged.execute("gameDirType");
    }

    public String getPermSize() {
        return this.permSize;
    }

    public void setPermSize(String permSize) {
        this.permSize = permSize;
        this.propertyChanged.execute("permSize");
    }

    public boolean isNoJVMArgs() {
        return this.noJVMArgs;
    }

    public void setNoJVMArgs(boolean noJVMArgs) {
        this.noJVMArgs = noJVMArgs;
        this.propertyChanged.execute("noJVMArgs");
    }

    public String getMinecraftArgs() {
        return this.minecraftArgs;
    }

    public void setMinecraftArgs(String minecraftArgs) {
        this.minecraftArgs = minecraftArgs;
        this.propertyChanged.execute("minecraftArgs");
    }

    public String getPrecalledCommand() {
        return this.precalledCommand;
    }

    public void setPrecalledCommand(String precalledCommand) {
        this.precalledCommand = precalledCommand;
        this.propertyChanged.execute("precalledCommand");
    }

    public String getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(String wrapper) {
        this.wrapper = wrapper;
        this.propertyChanged.execute("wrapper");
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
        this.propertyChanged.execute("serverIp");
    }

    public boolean isNotCheckGame() {
        return this.notCheckGame;
    }

    public void setNotCheckGame(boolean notCheckGame) {
        this.notCheckGame = notCheckGame;
        this.propertyChanged.execute("notCheckGame");
    }

    public LaunchOptions createLaunchOptions(File gameDir) {
        LaunchOptions x = new LaunchOptions();
        x.setFullscreen(this.isFullscreen());
        x.setWrapper(this.getWrapper());
        x.setGameDir(gameDir);
        x.setGameDirType(this.getGameDirType());
        x.setHeight(this.getHeight());
        x.setJavaArgs(this.getJavaArgs());
        x.setLaunchVersion(this.id);
        x.setMaxMemory(this.getMaxMemory());
        x.setMinecraftArgs(this.getMinecraftArgs());
        x.setName(Main.shortTitle());
        x.setType(Main.shortTitle());
        x.setVersionName(Main.shortTitle());
        x.setNoJVMArgs(this.isNoJVMArgs());
        x.setNotCheckGame(this.isNotCheckGame());
        x.setPermSize(this.getPermSize());
        x.setPrecalledCommand(this.getPrecalledCommand());
        x.setProxyHost(Settings.getInstance().getProxyHost());
        x.setProxyPort(Settings.getInstance().getProxyPort());
        x.setProxyUser(Settings.getInstance().getProxyUserName());
        x.setProxyPass(Settings.getInstance().getProxyPassword());
        x.setServerIp(this.getServerIp());
        x.setWidth(this.getWidth());
        String str = this.getJavaDir();
        if (!this.getJavaDirFile().exists()) {
            HMCLog.err(C.i18n("launch.wrong_javadir", new Object[0]));
            this.setJava(null);
            str = this.getJavaDir();
        }
        JdkVersion jv = new JdkVersion(str);
        if (Settings.getInstance().getJava().contains(jv)) {
            jv = Settings.getInstance().getJava().get(Settings.getInstance().getJava().indexOf(jv));
        } else {
            try {
                jv = JdkVersion.getJavaVersionFromExecutable(str);
                Settings.getInstance().getJava().add(jv);
                Settings.save();
            }
            catch (IOException ex) {
                HMCLog.warn("Failed to get java version", ex);
                jv = null;
            }
        }
        x.setJava(jv);
        x.setJavaDir(str);
        return x;
    }
}

