/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import org.jackhuang.hellominecraft.launcher.core.install.InstallerType;
import org.jackhuang.hellominecraft.launcher.core.mod.ModInfo;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftService;
import org.jackhuang.hellominecraft.launcher.core.version.GameDirType;
import org.jackhuang.hellominecraft.launcher.core.version.MinecraftVersion;
import org.jackhuang.hellominecraft.launcher.setting.Profile;
import org.jackhuang.hellominecraft.launcher.setting.Settings;
import org.jackhuang.hellominecraft.launcher.setting.VersionSetting;
import org.jackhuang.hellominecraft.launcher.ui.AnimatedPanel;
import org.jackhuang.hellominecraft.launcher.ui.GameDownloadPanel;
import org.jackhuang.hellominecraft.launcher.ui.GameSettingsPanel$$Lambda$1;
import org.jackhuang.hellominecraft.launcher.ui.GameSettingsPanel$$Lambda$10;
import org.jackhuang.hellominecraft.launcher.ui.GameSettingsPanel$$Lambda$11;
import org.jackhuang.hellominecraft.launcher.ui.GameSettingsPanel$$Lambda$12;
import org.jackhuang.hellominecraft.launcher.ui.GameSettingsPanel$$Lambda$13;
import org.jackhuang.hellominecraft.launcher.ui.GameSettingsPanel$$Lambda$2;
import org.jackhuang.hellominecraft.launcher.ui.GameSettingsPanel$$Lambda$3;
import org.jackhuang.hellominecraft.launcher.ui.GameSettingsPanel$$Lambda$4;
import org.jackhuang.hellominecraft.launcher.ui.GameSettingsPanel$$Lambda$5;
import org.jackhuang.hellominecraft.launcher.ui.GameSettingsPanel$$Lambda$6;
import org.jackhuang.hellominecraft.launcher.ui.GameSettingsPanel$$Lambda$7;
import org.jackhuang.hellominecraft.launcher.ui.GameSettingsPanel$$Lambda$8;
import org.jackhuang.hellominecraft.launcher.ui.GameSettingsPanel$$Lambda$9;
import org.jackhuang.hellominecraft.launcher.ui.InstallerPanel;
import org.jackhuang.hellominecraft.launcher.ui.MainFrame;
import org.jackhuang.hellominecraft.launcher.ui.NewProfileWindow;
import org.jackhuang.hellominecraft.launcher.ui.NewTabPane;
import org.jackhuang.hellominecraft.launcher.util.FileNameFilter;
import org.jackhuang.hellominecraft.launcher.util.LauncherVisibility;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.MessageBox;
import org.jackhuang.hellominecraft.util.MinecraftVersionRequest;
import org.jackhuang.hellominecraft.util.OverridableSwingWorker;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.func.Consumer;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.FileUtils;
import org.jackhuang.hellominecraft.util.system.Java;
import org.jackhuang.hellominecraft.util.system.OS;
import org.jackhuang.hellominecraft.util.tasks.TaskWindow;
import org.jackhuang.hellominecraft.util.ui.LogWindow;
import org.jackhuang.hellominecraft.util.ui.SwingUtils;

public final class GameSettingsPanel
extends AnimatedPanel
implements DropTargetListener {
    boolean isLoading = false;
    public MinecraftVersionRequest minecraftVersion;
    String mcVersion;
    final InstallerPanel[] installerPanels = new InstallerPanel[InstallerType.values().length];
    private boolean reloadingMods = false;
    private final Object modLock = new Object();
    JPopupMenu ppmManage;
    JPopupMenu ppmExplore;
    DropTarget dropTarget;
    private JButton btnAddMod;
    private JButton btnChoosingGameDir;
    private JButton btnChoosingJavaDir;
    private JButton btnCleanGame;
    private JButton btnDownloadAllAssets;
    private JButton btnExplore;
    private JButton btnIncludeMinecraft;
    private JButton btnMakeLaunchScript;
    private JButton btnModify;
    private JButton btnNewProfile;
    private JButton btnRefreshVersions;
    private JButton btnRemoveMod;
    private JButton btnRemoveProfile;
    private JButton btnShowLog;
    private JButton btnTestGame;
    private JComboBox cboJava;
    private JComboBox cboLauncherVisibility;
    private JComboBox cboProfiles;
    private JComboBox cboRunDirectory;
    private JComboBox cboVersions;
    private JCheckBox chkDontCheckGame;
    private JCheckBox chkFullscreen;
    private JCheckBox chkNoJVMArgs;
    private JScrollPane jScrollPane1;
    private JLabel lblDimension;
    private JLabel lblDimensionX;
    private JLabel lblGameDir;
    private JLabel lblJavaArgs;
    private JLabel lblJavaDir;
    private JLabel lblLauncherVisibility;
    private JLabel lblMaxMemory;
    private JLabel lblMaxMemorySize;
    private JLabel lblMinecraftArgs;
    private JLabel lblModInfo;
    private JLabel lblPermSize;
    private JLabel lblPrecalledCommand;
    private JLabel lblPrecalledCommand1;
    private JLabel lblProfile;
    private JLabel lblRunDirectory;
    private JLabel lblServerIP;
    private JLabel lblVersions;
    private JTable lstExternalMods;
    private JPanel pnlAdvancedSettings;
    private JPanel pnlAutoInstall;
    private JPanel pnlManagement;
    private JPanel pnlModManagement;
    private JPanel pnlModManagementContent;
    private JPanel pnlSelection;
    private JPanel pnlSettings;
    private JPanel pnlTop;
    private JTabbedPane tabInstallers;
    private JTabbedPane tabVersionEdit;
    private JTextField txtGameDir;
    private JTextField txtHeight;
    private JTextField txtJavaArgs;
    private JTextField txtJavaDir;
    private JTextField txtMaxMemory;
    private JTextField txtMinecraftArgs;
    private JTextField txtMinecraftVersion;
    private JTextField txtPermSize;
    private JTextField txtPrecalledCommand;
    private JTextField txtServerIP;
    private JTextField txtWidth;
    private JTextField txtWrapperLauncher;
    private JPanel pnlGameDownloads;
    final Runnable onLoadingProfiles = GameSettingsPanel$$Lambda$1.lambdaFactory$(this);
    final Consumer<IMinecraftService> onRefreshedVersions = GameSettingsPanel$$Lambda$2.lambdaFactory$(this);
    final Consumer<String> selectedVersionChangedEvent = GameSettingsPanel$$Lambda$3.lambdaFactory$(this);
    final Consumer<Profile> onSelectedProfilesChanged = GameSettingsPanel$$Lambda$4.lambdaFactory$(this);

    public GameSettingsPanel(MainFrame mf) {
        mf.actions.put("showGameDownloads", GameSettingsPanel$$Lambda$5.lambdaFactory$(this));
    }

    void initGui() {
        this.initComponents();
        this.setBackground(Color.white);
        this.setOpaque(true);
        for (int i = 0; i < InstallerType.values().length; ++i) {
            this.installerPanels[i] = new InstallerPanel(this, InstallerType.values()[i]);
        }
        this.pnlGameDownloads = new GameDownloadPanel(this);
        this.initExplorationMenu();
        this.initManagementMenu();
        this.initExternalModsTable();
        this.initTabs();
        this.isLoading = true;
        for (Java j : Java.JAVA) {
            this.cboJava.addItem(j.getLocalizedName());
        }
        this.isLoading = false;
        Settings.profileLoadingEvent.register(this.onLoadingProfiles);
        Settings.profileChangedEvent.register(this.onSelectedProfilesChanged);
        this.dropTarget = new DropTarget(this.lstExternalMods, 3, this);
    }

    void initExplorationMenu() {
        this.ppmExplore = new JPopupMenu();
        JMenuItem itm = new JMenuItem(C.i18n("folder.game", new Object[0]));
        class ImplementedActionListener
        implements ActionListener {
            String a;

            ImplementedActionListener(String s) {
                this.a = s;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.getLastProfile().service().version().open(GameSettingsPanel.this.mcVersion, this.a);
            }
        }
        itm.addActionListener(new ImplementedActionListener(null));
        this.ppmExplore.add(itm);
        itm = new JMenuItem(C.i18n("folder.mod", new Object[0]));
        itm.addActionListener(new ImplementedActionListener("mods"));
        this.ppmExplore.add(itm);
        itm = new JMenuItem(C.i18n("folder.coremod", new Object[0]));
        itm.addActionListener(new ImplementedActionListener("coremods"));
        this.ppmExplore.add(itm);
        itm = new JMenuItem(C.i18n("folder.config", new Object[0]));
        itm.addActionListener(new ImplementedActionListener("config"));
        this.ppmExplore.add(itm);
        itm = new JMenuItem(C.i18n("folder.resourcepacks", new Object[0]));
        itm.addActionListener(new ImplementedActionListener("resourcepacks"));
        this.ppmExplore.add(itm);
        itm = new JMenuItem(C.i18n("folder.screenshots", new Object[0]));
        itm.addActionListener(new ImplementedActionListener("screenshots"));
        this.ppmExplore.add(itm);
    }

    void initManagementMenu() {
        this.ppmManage = new JPopupMenu();
        JMenuItem itm = new JMenuItem(C.i18n("versions.manage.rename", new Object[0]));
        itm.addActionListener(GameSettingsPanel$$Lambda$6.lambdaFactory$(this));
        this.ppmManage.add(itm);
        itm = new JMenuItem(C.i18n("versions.manage.remove", new Object[0]));
        itm.addActionListener(GameSettingsPanel$$Lambda$7.lambdaFactory$(this));
        this.ppmManage.add(itm);
        itm = new JMenuItem(C.i18n("versions.manage.redownload_json", new Object[0]));
        itm.addActionListener(GameSettingsPanel$$Lambda$8.lambdaFactory$(this));
        this.ppmManage.add(itm);
        itm = new JMenuItem(C.i18n("versions.manage.redownload_assets_index", new Object[0]));
        itm.addActionListener(GameSettingsPanel$$Lambda$9.lambdaFactory$(this));
        this.ppmManage.add(itm);
        itm = new JMenuItem(C.i18n("versions.mamage.remove_libraries", new Object[0]));
        itm.addActionListener(GameSettingsPanel$$Lambda$10.lambdaFactory$(this));
        this.ppmManage.add(itm);
    }

    void initExternalModsTable() {
        if (this.lstExternalMods.getColumnModel().getColumnCount() > 0) {
            this.lstExternalMods.getColumnModel().getColumn(0).setMinWidth(17);
            this.lstExternalMods.getColumnModel().getColumn(0).setPreferredWidth(17);
            this.lstExternalMods.getColumnModel().getColumn(0).setMaxWidth(17);
        }
        this.lstExternalMods.getSelectionModel().addListSelectionListener(GameSettingsPanel$$Lambda$11.lambdaFactory$(this));
        ((DefaultTableModel)this.lstExternalMods.getModel()).addTableModelListener(GameSettingsPanel$$Lambda$12.lambdaFactory$(this));
    }

    void initTabs() {
        this.tabVersionEdit.addChangeListener(new ChangeListener(){
            boolean b = false;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (GameSettingsPanel.this.tabVersionEdit.getSelectedComponent() == GameSettingsPanel.this.pnlAutoInstall && !this.b) {
                    this.b = true;
                    GameSettingsPanel.this.installerPanels[0].refreshVersions();
                }
            }
        });
        ((NewTabPane)this.tabVersionEdit).initializing = true;
        this.tabVersionEdit.addTab(C.i18n("settings.tabs.game_download", new Object[0]), this.pnlGameDownloads);
        ((NewTabPane)this.tabVersionEdit).initializing = false;
        ((NewTabPane)this.tabInstallers).initializing = true;
        for (int i = 0; i < InstallerType.values().length; ++i) {
            this.tabInstallers.addTab(InstallerType.values()[i].getLocalizedName(), this.installerPanels[i]);
        }
        ((NewTabPane)this.tabInstallers).initializing = false;
    }

    private void initComponents() {
        this.tabVersionEdit = new NewTabPane();
        ((NewTabPane)this.tabVersionEdit).initializing = true;
        this.pnlSettings = new AnimatedPanel();
        this.lblGameDir = new JLabel();
        this.txtGameDir = new JTextField();
        this.lblDimension = new JLabel();
        this.txtWidth = new JTextField();
        this.txtHeight = new JTextField();
        this.lblDimensionX = new JLabel();
        this.chkFullscreen = new JCheckBox();
        this.txtJavaDir = new JTextField();
        this.lblJavaDir = new JLabel();
        this.lblMaxMemory = new JLabel();
        this.txtMaxMemory = new JTextField();
        this.lblMaxMemorySize = new JLabel();
        this.btnDownloadAllAssets = new JButton();
        this.cboLauncherVisibility = new JComboBox();
        this.lblLauncherVisibility = new JLabel();
        this.lblRunDirectory = new JLabel();
        this.cboRunDirectory = new JComboBox();
        this.btnChoosingJavaDir = new JButton();
        this.cboJava = new JComboBox();
        this.btnChoosingGameDir = new JButton();
        this.btnCleanGame = new JButton();
        this.pnlAdvancedSettings = new AnimatedPanel();
        this.lblJavaArgs = new JLabel();
        this.txtJavaArgs = new JTextField();
        this.txtMinecraftArgs = new JTextField();
        this.lblMinecraftArgs = new JLabel();
        this.lblPermSize = new JLabel();
        this.txtPermSize = new JTextField();
        this.chkNoJVMArgs = new JCheckBox();
        this.lblPrecalledCommand = new JLabel();
        this.txtPrecalledCommand = new JTextField();
        this.lblServerIP = new JLabel();
        this.txtServerIP = new JTextField();
        this.lblPrecalledCommand1 = new JLabel();
        this.txtWrapperLauncher = new JTextField();
        this.chkDontCheckGame = new JCheckBox();
        this.pnlModManagement = new AnimatedPanel();
        this.pnlModManagementContent = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.lstExternalMods = new JTable();
        this.btnAddMod = new JButton();
        this.btnRemoveMod = new JButton();
        this.lblModInfo = new JLabel();
        this.pnlAutoInstall = new AnimatedPanel();
        this.tabInstallers = new NewTabPane();
        this.pnlTop = new JPanel();
        this.pnlSelection = new JPanel();
        this.lblProfile = new JLabel();
        this.cboProfiles = new JComboBox();
        this.cboVersions = new JComboBox();
        this.lblVersions = new JLabel();
        this.pnlManagement = new JPanel();
        this.btnModify = new JButton();
        this.btnRefreshVersions = new JButton();
        this.txtMinecraftVersion = new JTextField();
        this.btnNewProfile = new JButton();
        this.btnRemoveProfile = new JButton();
        this.btnExplore = new JButton();
        this.btnTestGame = new JButton();
        this.btnShowLog = new JButton();
        this.btnMakeLaunchScript = new JButton();
        this.btnIncludeMinecraft = new JButton();
        this.setBackground(new Color(255, 255, 255));
        this.setOpaque(false);
        this.tabVersionEdit.setName("tabVersionEdit");
        this.lblGameDir.setText(C.i18n("settings.game_directory", new Object[0]));
        this.txtGameDir.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                GameSettingsPanel.this.txtGameDirFocusLost(evt);
            }
        });
        this.lblDimension.setText(C.i18n("settings.dimension", new Object[0]));
        this.txtWidth.setToolTipText("");
        this.txtWidth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                GameSettingsPanel.this.txtWidthFocusLost(evt);
            }
        });
        this.txtHeight.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                GameSettingsPanel.this.txtHeightFocusLost(evt);
            }
        });
        this.lblDimensionX.setText("x");
        this.chkFullscreen.setText(C.i18n("settings.fullscreen", new Object[0]));
        this.chkFullscreen.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GameSettingsPanel.this.chkFullscreenItemStateChanged(evt);
            }
        });
        this.txtJavaDir.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                GameSettingsPanel.this.txtJavaDirFocusLost(evt);
            }
        });
        this.lblJavaDir.setText(C.i18n("settings.java_dir", new Object[0]));
        this.lblMaxMemory.setText(C.i18n("settings.max_memory", new Object[0]));
        this.txtMaxMemory.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                GameSettingsPanel.this.txtMaxMemoryFocusLost(evt);
            }
        });
        this.lblMaxMemorySize.setText(C.i18n("settings.physical_memory", new Object[0]) + ": " + OS.getTotalPhysicalMemory() / 1024L / 1024L + "MB");
        this.btnDownloadAllAssets.setText(C.i18n("assets.download_all", new Object[0]));
        this.btnDownloadAllAssets.setToolTipText("");
        this.btnDownloadAllAssets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameSettingsPanel.this.btnDownloadAllAssetsActionPerformed(evt);
            }
        });
        this.cboLauncherVisibility.setModel(new DefaultComboBoxModel<String>(new String[]{C.i18n("advancedsettings.launcher_visibility.close", new Object[0]), C.i18n("advancedsettings.launcher_visibility.hide", new Object[0]), C.i18n("advancedsettings.launcher_visibility.keep", new Object[0])}));
        this.cboLauncherVisibility.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GameSettingsPanel.this.cboLauncherVisibilityItemStateChanged(evt);
            }
        });
        this.lblLauncherVisibility.setText(C.i18n("advancedsettings.launcher_visible", new Object[0]));
        this.lblRunDirectory.setText(C.i18n("settings.run_directory", new Object[0]));
        this.cboRunDirectory.setModel(new DefaultComboBoxModel<String>(new String[]{C.i18n("advancedsettings.game_dir.default", new Object[0]), C.i18n("advancedsettings.game_dir.independent", new Object[0])}));
        this.cboRunDirectory.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GameSettingsPanel.this.cboRunDirectoryItemStateChanged(evt);
            }
        });
        this.btnChoosingJavaDir.setText(C.i18n("ui.button.explore", new Object[0]));
        this.btnChoosingJavaDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameSettingsPanel.this.btnChoosingJavaDirActionPerformed(evt);
            }
        });
        this.cboJava.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GameSettingsPanel.this.cboJavaItemStateChanged(evt);
            }
        });
        this.btnChoosingGameDir.setText(C.i18n("ui.button.explore", new Object[0]));
        this.btnChoosingGameDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameSettingsPanel.this.btnChoosingGameDirActionPerformed(evt);
            }
        });
        this.btnCleanGame.setText(C.i18n("setupwindow.clean", new Object[0]));
        this.btnCleanGame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameSettingsPanel.this.btnCleanGameActionPerformed(evt);
            }
        });
        GroupLayout pnlSettingsLayout = new GroupLayout(this.pnlSettings);
        this.pnlSettings.setLayout(pnlSettingsLayout);
        pnlSettingsLayout.setHorizontalGroup(pnlSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlSettingsLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(pnlSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlSettingsLayout.createSequentialGroup().addGroup(pnlSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblJavaDir).addComponent(this.lblMaxMemory).addComponent(this.lblGameDir).addComponent(this.lblRunDirectory).addComponent(this.lblLauncherVisibility).addComponent(this.lblDimension)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cboLauncherVisibility, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addGroup(pnlSettingsLayout.createSequentialGroup().addComponent(this.txtWidth, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblDimensionX).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtHeight, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 63, Short.MAX_VALUE).addComponent(this.chkFullscreen)).addGroup(GroupLayout.Alignment.TRAILING, pnlSettingsLayout.createSequentialGroup().addComponent(this.txtMaxMemory).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMaxMemorySize)).addGroup(GroupLayout.Alignment.TRAILING, pnlSettingsLayout.createSequentialGroup().addComponent(this.txtGameDir).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnChoosingGameDir)).addGroup(GroupLayout.Alignment.TRAILING, pnlSettingsLayout.createSequentialGroup().addComponent(this.cboJava, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtJavaDir).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnChoosingJavaDir)).addComponent(this.cboRunDirectory, 0, -1, Short.MAX_VALUE))).addGroup(pnlSettingsLayout.createSequentialGroup().addComponent(this.btnDownloadAllAssets).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnCleanGame))).addGap(0, 0, 0)));
        pnlSettingsLayout.setVerticalGroup(pnlSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlSettingsLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(pnlSettingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtGameDir, -2, 26, -2).addComponent(this.lblGameDir).addComponent(this.btnChoosingGameDir, -2, 26, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlSettingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtJavaDir, -2, 26, -2).addComponent(this.lblJavaDir).addComponent(this.btnChoosingJavaDir, -2, 26, -2).addComponent(this.cboJava, -2, 26, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlSettingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMaxMemorySize).addComponent(this.txtMaxMemory, -2, 26, -2).addComponent(this.lblMaxMemory)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlSettingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cboLauncherVisibility, -2, 26, -2).addComponent(this.lblLauncherVisibility)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlSettingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cboRunDirectory, -2, 26, -2).addComponent(this.lblRunDirectory)).addGap(4, 4, 4).addGroup(pnlSettingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtHeight, -2, 26, -2).addComponent(this.chkFullscreen, -2, 26, -2).addComponent(this.lblDimensionX, -2, 26, -2).addComponent(this.lblDimension).addComponent(this.txtWidth, -2, 26, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 99, Short.MAX_VALUE).addGroup(pnlSettingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnDownloadAllAssets).addComponent(this.btnCleanGame)).addContainerGap()));
        this.tabVersionEdit.addTab(C.i18n("settings", new Object[0]), this.pnlSettings);
        this.lblJavaArgs.setText(C.i18n("advancedsettings.jvm_args", new Object[0]));
        this.txtJavaArgs.setToolTipText(C.i18n("advancedsettings.java_args_default", new Object[0]));
        this.txtJavaArgs.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                GameSettingsPanel.this.txtJavaArgsFocusLost(evt);
            }
        });
        this.txtMinecraftArgs.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                GameSettingsPanel.this.txtMinecraftArgsFocusLost(evt);
            }
        });
        this.lblMinecraftArgs.setText(C.i18n("advancedsettings.Minecraft_arguments", new Object[0]));
        this.lblPermSize.setText(C.i18n("advancedsettings.java_permanent_generation_space", new Object[0]));
        this.txtPermSize.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                GameSettingsPanel.this.txtPermSizeFocusLost(evt);
            }
        });
        this.chkNoJVMArgs.setText(C.i18n("advancedsettings.no_jvm_args", new Object[0]));
        this.chkNoJVMArgs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GameSettingsPanel.this.chkNoJVMArgsItemStateChanged(evt);
            }
        });
        this.lblPrecalledCommand.setText(C.i18n("advancedsettings.precall_command", new Object[0]));
        this.txtPrecalledCommand.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                GameSettingsPanel.this.txtPrecalledCommandFocusLost(evt);
            }
        });
        this.lblServerIP.setText(C.i18n("advancedsettings.server_ip", new Object[0]));
        this.txtServerIP.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                GameSettingsPanel.this.txtServerIPFocusLost(evt);
            }
        });
        this.lblPrecalledCommand1.setText(C.i18n("advancedsettings.wrapper_launcher", new Object[0]));
        this.txtWrapperLauncher.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                GameSettingsPanel.this.txtWrapperLauncherFocusLost(evt);
            }
        });
        this.chkDontCheckGame.setText(C.i18n("advancedsettings.dont_check_game_completeness", new Object[0]));
        this.chkDontCheckGame.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GameSettingsPanel.this.chkDontCheckGameItemStateChanged(evt);
            }
        });
        GroupLayout pnlAdvancedSettingsLayout = new GroupLayout(this.pnlAdvancedSettings);
        this.pnlAdvancedSettings.setLayout(pnlAdvancedSettingsLayout);
        pnlAdvancedSettingsLayout.setHorizontalGroup(pnlAdvancedSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtPrecalledCommand).addComponent(this.txtServerIP).addGroup(GroupLayout.Alignment.TRAILING, pnlAdvancedSettingsLayout.createSequentialGroup().addGroup(pnlAdvancedSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMinecraftArgs).addComponent(this.lblPermSize).addComponent(this.lblJavaArgs)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlAdvancedSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtJavaArgs, -1, 325, Short.MAX_VALUE).addComponent(this.txtMinecraftArgs).addComponent(this.txtPermSize, GroupLayout.Alignment.TRAILING))).addGroup(pnlAdvancedSettingsLayout.createSequentialGroup().addGroup(pnlAdvancedSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtWrapperLauncher).addGroup(pnlAdvancedSettingsLayout.createSequentialGroup().addComponent(this.lblPrecalledCommand1).addGap(0, 0, Short.MAX_VALUE)).addGroup(pnlAdvancedSettingsLayout.createSequentialGroup().addContainerGap().addComponent(this.chkNoJVMArgs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.chkDontCheckGame)).addGroup(pnlAdvancedSettingsLayout.createSequentialGroup().addGroup(pnlAdvancedSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblPrecalledCommand).addComponent(this.lblServerIP)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        pnlAdvancedSettingsLayout.setVerticalGroup(pnlAdvancedSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlAdvancedSettingsLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(pnlAdvancedSettingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtJavaArgs, -2, 26, -2).addComponent(this.lblJavaArgs)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlAdvancedSettingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtMinecraftArgs, -2, 26, -2).addComponent(this.lblMinecraftArgs)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlAdvancedSettingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtPermSize, -2, 26, -2).addComponent(this.lblPermSize)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPrecalledCommand1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtWrapperLauncher, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPrecalledCommand).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtPrecalledCommand, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblServerIP).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtServerIP, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 39, Short.MAX_VALUE).addGroup(pnlAdvancedSettingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chkNoJVMArgs).addComponent(this.chkDontCheckGame)).addContainerGap()));
        this.tabVersionEdit.addTab(C.i18n("advancedsettings", new Object[0]), this.pnlAdvancedSettings);
        this.lstExternalMods.setModel(SwingUtils.makeDefaultTableModel(new String[]{"", "Mod", C.i18n("ui.label.version", new Object[0])}, new Class[]{Boolean.class, String.class, String.class}, new boolean[]{true, false, false}));
        this.lstExternalMods.setColumnSelectionAllowed(true);
        this.lstExternalMods.getTableHeader().setReorderingAllowed(false);
        this.lstExternalMods.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                GameSettingsPanel.this.lstExternalModsKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstExternalMods);
        this.lstExternalMods.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.btnAddMod.setText(C.i18n("mods.add", new Object[0]));
        this.btnAddMod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameSettingsPanel.this.btnAddModActionPerformed(evt);
            }
        });
        this.btnRemoveMod.setText(C.i18n("mods.remove", new Object[0]));
        this.btnRemoveMod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameSettingsPanel.this.btnRemoveModActionPerformed(evt);
            }
        });
        this.lblModInfo.setText(C.i18n("mods.default_information", new Object[0]));
        this.lblModInfo.setCursor(new Cursor(0));
        this.lblModInfo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GameSettingsPanel.this.lblModInfoMouseClicked(evt);
            }
        });
        GroupLayout pnlModManagementContentLayout = new GroupLayout(this.pnlModManagementContent);
        this.pnlModManagementContent.setLayout(pnlModManagementContentLayout);
        pnlModManagementContentLayout.setHorizontalGroup(pnlModManagementContentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlModManagementContentLayout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 550, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlModManagementContentLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnRemoveMod, -1, -1, Short.MAX_VALUE).addComponent(this.btnAddMod, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, pnlModManagementContentLayout.createSequentialGroup().addComponent(this.lblModInfo, -1, 646, Short.MAX_VALUE).addContainerGap()));
        pnlModManagementContentLayout.setVerticalGroup(pnlModManagementContentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlModManagementContentLayout.createSequentialGroup().addGroup(pnlModManagementContentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlModManagementContentLayout.createSequentialGroup().addComponent(this.btnAddMod).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRemoveMod).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 299, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblModInfo)));
        GroupLayout pnlModManagementLayout = new GroupLayout(this.pnlModManagement);
        this.pnlModManagement.setLayout(pnlModManagementLayout);
        pnlModManagementLayout.setHorizontalGroup(pnlModManagementLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlModManagementContent, -1, -1, Short.MAX_VALUE));
        pnlModManagementLayout.setVerticalGroup(pnlModManagementLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlModManagementContent, -1, -1, Short.MAX_VALUE));
        this.tabVersionEdit.addTab(C.i18n("mods", new Object[0]), this.pnlModManagement);
        GroupLayout pnlAutoInstallLayout = new GroupLayout(this.pnlAutoInstall);
        this.pnlAutoInstall.setLayout(pnlAutoInstallLayout);
        pnlAutoInstallLayout.setHorizontalGroup(pnlAutoInstallLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabInstallers));
        pnlAutoInstallLayout.setVerticalGroup(pnlAutoInstallLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabInstallers));
        this.tabVersionEdit.addTab(C.i18n("settings.tabs.installers", new Object[0]), this.pnlAutoInstall);
        this.lblProfile.setText(C.i18n("ui.label.profile", new Object[0]));
        this.cboProfiles.setMinimumSize(new Dimension(32, 23));
        this.cboProfiles.setPreferredSize(new Dimension(32, 23));
        this.cboProfiles.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GameSettingsPanel.this.cboProfilesItemStateChanged(evt);
            }
        });
        this.cboVersions.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GameSettingsPanel.this.cboVersionsItemStateChanged(evt);
            }
        });
        this.lblVersions.setText(C.i18n("ui.label.version", new Object[0]));
        GroupLayout pnlSelectionLayout = new GroupLayout(this.pnlSelection);
        this.pnlSelection.setLayout(pnlSelectionLayout);
        pnlSelectionLayout.setHorizontalGroup(pnlSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlSelectionLayout.createSequentialGroup().addContainerGap().addGroup(pnlSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblVersions).addComponent(this.lblProfile)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cboProfiles, 0, -1, Short.MAX_VALUE).addComponent(this.cboVersions, 0, -1, Short.MAX_VALUE))));
        pnlSelectionLayout.setVerticalGroup(pnlSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlSelectionLayout.createSequentialGroup().addContainerGap().addGroup(pnlSelectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cboProfiles, -2, 26, -2).addComponent(this.lblProfile)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlSelectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cboVersions, -2, 26, -2).addComponent(this.lblVersions)).addContainerGap(-1, Short.MAX_VALUE)));
        this.btnModify.setText(C.i18n("settings.manage", new Object[0]));
        this.btnModify.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GameSettingsPanel.this.btnModifyMouseClicked(evt);
            }
        });
        this.btnRefreshVersions.setText(C.i18n("ui.button.refresh", new Object[0]));
        this.btnRefreshVersions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameSettingsPanel.this.btnRefreshVersionsActionPerformed(evt);
            }
        });
        this.txtMinecraftVersion.setEditable(false);
        this.btnNewProfile.setText(C.i18n("setupwindow.new", new Object[0]));
        this.btnNewProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameSettingsPanel.this.btnNewProfileActionPerformed(evt);
            }
        });
        this.btnRemoveProfile.setText(C.i18n("ui.button.delete", new Object[0]));
        this.btnRemoveProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameSettingsPanel.this.btnRemoveProfileActionPerformed(evt);
            }
        });
        this.btnExplore.setText(C.i18n("settings.explore", new Object[0]));
        this.btnExplore.setToolTipText("");
        this.btnExplore.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GameSettingsPanel.this.btnExploreMouseClicked(evt);
            }
        });
        GroupLayout pnlManagementLayout = new GroupLayout(this.pnlManagement);
        this.pnlManagement.setLayout(pnlManagementLayout);
        pnlManagementLayout.setHorizontalGroup(pnlManagementLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlManagementLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(pnlManagementLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnNewProfile, -1, -1, Short.MAX_VALUE).addComponent(this.txtMinecraftVersion)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlManagementLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnRemoveProfile, -1, -1, Short.MAX_VALUE).addComponent(this.btnRefreshVersions, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlManagementLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnModify, -1, -1, Short.MAX_VALUE).addComponent(this.btnExplore, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        pnlManagementLayout.setVerticalGroup(pnlManagementLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlManagementLayout.createSequentialGroup().addContainerGap().addGroup(pnlManagementLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnNewProfile, -2, 26, -2).addComponent(this.btnRemoveProfile, -2, 26, -2).addComponent(this.btnExplore, -2, 26, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlManagementLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtMinecraftVersion, -2, 26, -2).addComponent(this.btnRefreshVersions, -2, 26, -2).addComponent(this.btnModify, -2, 26, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout pnlTopLayout = new GroupLayout(this.pnlTop);
        this.pnlTop.setLayout(pnlTopLayout);
        pnlTopLayout.setHorizontalGroup(pnlTopLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlTopLayout.createSequentialGroup().addComponent(this.pnlSelection, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlManagement, -2, -1, -2)));
        pnlTopLayout.setVerticalGroup(pnlTopLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlTopLayout.createSequentialGroup().addGroup(pnlTopLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.pnlSelection, -1, -1, Short.MAX_VALUE).addComponent(this.pnlManagement, -1, -1, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE)));
        this.btnTestGame.setText(C.i18n("settings.test_game", new Object[0]));
        this.btnTestGame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameSettingsPanel.this.btnTestGameActionPerformed(evt);
            }
        });
        this.btnShowLog.setText(C.i18n("mainwindow.show_log", new Object[0]));
        this.btnShowLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameSettingsPanel.this.btnShowLogActionPerformed(evt);
            }
        });
        this.btnMakeLaunchScript.setText(C.i18n("mainwindow.make_launch_script", new Object[0]));
        this.btnMakeLaunchScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameSettingsPanel.this.btnMakeLaunchScriptActionPerformed(evt);
            }
        });
        this.btnIncludeMinecraft.setText(C.i18n("setupwindow.include_minecraft", new Object[0]));
        this.btnIncludeMinecraft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameSettingsPanel.this.btnIncludeMinecraftActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlTop, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabVersionEdit).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnMakeLaunchScript).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnShowLog).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnTestGame))).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.btnIncludeMinecraft).addContainerGap(577, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlTop, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabVersionEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnTestGame).addComponent(this.btnShowLog).addComponent(this.btnMakeLaunchScript)).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(447, Short.MAX_VALUE).addComponent(this.btnIncludeMinecraft).addContainerGap())));
        ((NewTabPane)this.tabVersionEdit).initializing = false;
    }

    private void cboProfilesItemStateChanged(ItemEvent evt) {
        if (!this.isLoading) {
            Settings.getInstance().setLast((String)this.cboProfiles.getSelectedItem());
        }
    }

    private void btnNewProfileActionPerformed(ActionEvent evt) {
        new NewProfileWindow(null).setVisible(true);
        this.loadProfiles();
    }

    private void btnRemoveProfileActionPerformed(ActionEvent evt) {
        if (MessageBox.Show(C.i18n("ui.message.sure_remove", Settings.getLastProfile().getName()), 10) == 1) {
            return;
        }
        Settings.delProfile(Settings.getLastProfile());
    }

    private void cboVersionsItemStateChanged(ItemEvent evt) {
        if (this.isLoading || evt.getStateChange() != 1 || this.cboVersions.getSelectedIndex() < 0 || StrUtils.isBlank((String)this.cboVersions.getSelectedItem())) {
            return;
        }
        Settings.getLastProfile().setSelectedMinecraftVersion((String)this.cboVersions.getSelectedItem());
    }

    private void btnRefreshVersionsActionPerformed(ActionEvent evt) {
        this.refreshVersions();
    }

    private void btnExploreMouseClicked(MouseEvent evt) {
        this.ppmExplore.show(evt.getComponent(), evt.getPoint().x, evt.getPoint().y);
    }

    private void btnModifyMouseClicked(MouseEvent evt) {
        this.ppmManage.show(evt.getComponent(), evt.getPoint().x, evt.getPoint().y);
    }

    private void btnDownloadAllAssetsActionPerformed(ActionEvent evt) {
        if (this.mcVersion != null) {
            TaskWindow.execute(Settings.getLastProfile().service().asset().downloadAssets(this.mcVersion));
        }
    }

    private void txtGameDirFocusLost(FocusEvent evt) {
        Settings.getLastProfile().setGameDir(this.txtGameDir.getText());
        this.loadVersions();
    }

    private void btnChoosingJavaDirActionPerformed(ActionEvent evt) {
        if (this.cboJava.getSelectedIndex() != 1) {
            return;
        }
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setDialogTitle(C.i18n("settings.choose_javapath", new Object[0]));
        fc.setMultiSelectionEnabled(false);
        fc.setFileFilter(new FileNameFilter("javaw.exe"));
        fc.addChoosableFileFilter(new FileNameFilter("java.exe"));
        fc.addChoosableFileFilter(new FileNameFilter("java"));
        fc.showOpenDialog(this);
        if (fc.getSelectedFile() == null) {
            return;
        }
        try {
            String path = fc.getSelectedFile().getCanonicalPath();
            this.txtJavaDir.setText(path);
            Settings.getLastProfile().getSelectedVersionSetting().setJavaDir(this.txtJavaDir.getText());
        }
        catch (IOException e) {
            HMCLog.warn("Failed to set java path.", e);
            MessageBox.Show(C.i18n("ui.label.failed_set", new Object[0]) + e.getMessage());
        }
    }

    private void cboJavaItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 1 || this.cboJava.getSelectedIndex() < 0 || StrUtils.isBlank((String)this.cboJava.getSelectedItem())) {
            return;
        }
        int idx = this.cboJava.getSelectedIndex();
        if (idx != -1) {
            Java j = Java.JAVA.get(idx);
            this.txtJavaDir.setText(j.getHome() == null ? Settings.getLastProfile().getSelectedVersionSetting().getSettingsJavaDir() : j.getJava());
            this.txtJavaDir.setEnabled(idx == 1);
            if (!this.isLoading) {
                Settings.getLastProfile().getSelectedVersionSetting().setJava(j);
            }
        }
    }

    private void btnAddModActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setDialogTitle(C.i18n("mods.choose_mod", new Object[0]));
        fc.setMultiSelectionEnabled(true);
        if (fc.showOpenDialog(this) != 0) {
            return;
        }
        boolean flag = true;
        for (File f : fc.getSelectedFiles()) {
            flag &= Settings.getLastProfile().service().mod().addMod(Settings.getLastProfile().getSelectedVersion(), f);
        }
        this.reloadMods();
        if (!flag) {
            MessageBox.Show(C.i18n("mods.failed", new Object[0]));
        }
    }

    private void btnRemoveModActionPerformed(ActionEvent evt) {
        Settings.getLastProfile().service().mod().removeMod(Settings.getLastProfile().getSelectedVersion(), SwingUtils.getValueBySelectedRow(this.lstExternalMods, this.lstExternalMods.getSelectedRows(), 1));
        this.reloadMods();
    }

    private void lstExternalModsKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.btnRemoveModActionPerformed(null);
        }
    }

    private void lblModInfoMouseClicked(MouseEvent evt) {
        int idx = this.lstExternalMods.getSelectedRow();
        if (idx > 0 && idx < Settings.getLastProfile().service().mod().getMods(Settings.getLastProfile().getSelectedVersion()).size()) {
            SwingUtils.openLink(Settings.getLastProfile().service().mod().getMods((String)Settings.getLastProfile().getSelectedVersion()).get((int)idx).url);
        }
    }

    private void btnChoosingGameDirActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        fc.setDialogTitle(C.i18n("settings.choose_gamedir", new Object[0]));
        fc.setMultiSelectionEnabled(false);
        fc.showOpenDialog(this);
        if (fc.getSelectedFile() == null) {
            return;
        }
        try {
            String path = fc.getSelectedFile().getCanonicalPath();
            this.txtGameDir.setText(path);
            Settings.getLastProfile().setGameDir(path);
        }
        catch (IOException e) {
            HMCLog.warn("Failed to set game dir.", e);
            MessageBox.Show(C.i18n("ui.label.failed_set", new Object[0]) + e.getMessage());
        }
    }

    private void btnCleanGameActionPerformed(ActionEvent evt) {
        Settings.getLastProfile().service().version().cleanFolder();
    }

    private void btnTestGameActionPerformed(ActionEvent evt) {
        LogWindow.INSTANCE.setVisible(true);
        MainFrame.INSTANCE.daemon.runGame(Settings.getLastProfile());
    }

    private void btnShowLogActionPerformed(ActionEvent evt) {
        LogWindow.INSTANCE.setVisible(true);
    }

    private void btnMakeLaunchScriptActionPerformed(ActionEvent evt) {
        MainFrame.INSTANCE.daemon.makeLaunchScript(Settings.getLastProfile());
    }

    private void btnIncludeMinecraftActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser(new File("."));
        fc.setFileSelectionMode(1);
        if (fc.showOpenDialog(this) == 0) {
            File newGameDir = fc.getSelectedFile();
            String name = JOptionPane.showInputDialog(C.i18n("setupwindow.give_a_name", new Object[0]));
            if (StrUtils.isBlank(name)) {
                MessageBox.Show(C.i18n("setupwindow.no_empty_name", new Object[0]));
                return;
            }
            Settings.putProfile(new Profile(name).setGameDir(newGameDir.getAbsolutePath()));
            MessageBox.Show(C.i18n("setupwindow.find_in_configurations", new Object[0]));
            this.loadProfiles();
        }
    }

    private void cboRunDirectoryItemStateChanged(ItemEvent evt) {
        if (!this.isLoading && this.cboRunDirectory.getSelectedIndex() >= 0) {
            Settings.getLastProfile().getSelectedVersionSetting().setGameDirType(GameDirType.values()[this.cboRunDirectory.getSelectedIndex()]);
        }
    }

    private void cboLauncherVisibilityItemStateChanged(ItemEvent evt) {
        if (!this.isLoading && this.cboLauncherVisibility.getSelectedIndex() >= 0) {
            Settings.getLastProfile().getSelectedVersionSetting().setLauncherVisibility(LauncherVisibility.values()[this.cboLauncherVisibility.getSelectedIndex()]);
        }
    }

    private void chkFullscreenItemStateChanged(ItemEvent evt) {
        if (!this.isLoading) {
            Settings.getLastProfile().getSelectedVersionSetting().setFullscreen(this.chkFullscreen.isSelected());
        }
    }

    private void chkNoJVMArgsItemStateChanged(ItemEvent evt) {
        if (!this.isLoading) {
            Settings.getLastProfile().getSelectedVersionSetting().setNoJVMArgs(this.chkNoJVMArgs.isSelected());
        }
    }

    private void txtMaxMemoryFocusLost(FocusEvent evt) {
        Settings.getLastProfile().getSelectedVersionSetting().setMaxMemory(this.txtMaxMemory.getText());
    }

    private void txtWidthFocusLost(FocusEvent evt) {
        Settings.getLastProfile().getSelectedVersionSetting().setWidth(this.txtWidth.getText());
    }

    private void txtHeightFocusLost(FocusEvent evt) {
        Settings.getLastProfile().getSelectedVersionSetting().setHeight(this.txtHeight.getText());
    }

    private void txtJavaDirFocusLost(FocusEvent evt) {
        Settings.getLastProfile().getSelectedVersionSetting().setJavaDir(this.txtJavaDir.getText());
    }

    private void txtJavaArgsFocusLost(FocusEvent evt) {
        Settings.getLastProfile().getSelectedVersionSetting().setJavaArgs(this.txtJavaArgs.getText());
    }

    private void txtMinecraftArgsFocusLost(FocusEvent evt) {
        Settings.getLastProfile().getSelectedVersionSetting().setMinecraftArgs(this.txtMinecraftArgs.getText());
    }

    private void txtPermSizeFocusLost(FocusEvent evt) {
        Settings.getLastProfile().getSelectedVersionSetting().setPermSize(this.txtPermSize.getText());
    }

    private void txtPrecalledCommandFocusLost(FocusEvent evt) {
        Settings.getLastProfile().getSelectedVersionSetting().setPrecalledCommand(this.txtPrecalledCommand.getText());
    }

    private void txtServerIPFocusLost(FocusEvent evt) {
        Settings.getLastProfile().getSelectedVersionSetting().setServerIp(this.txtServerIP.getText());
    }

    private void txtWrapperLauncherFocusLost(FocusEvent evt) {
        Settings.getLastProfile().getSelectedVersionSetting().setWrapper(this.txtWrapperLauncher.getText());
    }

    private void chkDontCheckGameItemStateChanged(ItemEvent evt) {
        if (!this.isLoading) {
            Settings.getLastProfile().getSelectedVersionSetting().setNotCheckGame(this.chkDontCheckGame.isSelected());
        }
    }

    void prepareVersionSetting(VersionSetting profile) {
        if (profile == null) {
            return;
        }
        this.isLoading = true;
        this.txtWidth.setText(profile.getWidth());
        this.txtHeight.setText(profile.getHeight());
        this.txtMaxMemory.setText(profile.getMaxMemory());
        this.txtPermSize.setText(profile.getPermSize());
        this.txtJavaArgs.setText(profile.getJavaArgs());
        this.txtMinecraftArgs.setText(profile.getMinecraftArgs());
        this.txtPrecalledCommand.setText(profile.getPrecalledCommand());
        this.txtServerIP.setText(profile.getServerIp());
        this.chkNoJVMArgs.setSelected(profile.isNoJVMArgs());
        this.chkDontCheckGame.setSelected(profile.isNotCheckGame());
        this.chkFullscreen.setSelected(profile.isFullscreen());
        this.cboLauncherVisibility.setSelectedIndex(profile.getLauncherVisibility().ordinal());
        this.cboRunDirectory.setSelectedIndex(profile.getGameDirType().ordinal());
        this.cboJava.setSelectedIndex(profile.getJavaIndexInAllJavas());
        this.isLoading = false;
    }

    void loadMinecraftVersion(String id) {
        this.txtMinecraftVersion.setText("");
        if (id == null) {
            return;
        }
        this.minecraftVersion = MinecraftVersionRequest.minecraftVersion(Settings.getLastProfile().service().version().getMinecraftJar(id));
        this.txtMinecraftVersion.setText(MinecraftVersionRequest.getResponse(this.minecraftVersion));
    }

    String getMinecraftVersionFormatted() {
        return this.minecraftVersion == null ? "" : (StrUtils.formatVersion(this.minecraftVersion.version) == null ? this.mcVersion : this.minecraftVersion.version);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        DataFlavor[] f = dtde.getCurrentDataFlavors();
        if (f[0].match(DataFlavor.javaFileListFlavor)) {
            try {
                Transferable tr = dtde.getTransferable();
                List files = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : files) {
                    Settings.getLastProfile().service().mod().addMod(Settings.getLastProfile().getSelectedVersion(), file);
                }
            }
            catch (Exception ex) {
                HMCLog.warn("Failed to drop file.", ex);
            }
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
    }

    void refreshVersions() {
        Settings.getLastProfile().service().version().refreshVersions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadMods() {
        Object object = this.modLock;
        synchronized (object) {
            if (this.reloadingMods) {
                return;
            }
            this.reloadingMods = true;
            DefaultTableModel model = SwingUtils.clearDefaultTable(this.lstExternalMods);
            new OverridableSwingWorker<List<ModInfo>>(){

                @Override
                protected void work() throws Exception {
                    this.publish(Settings.getLastProfile().service().mod().recacheMods(Settings.getLastProfile().getSelectedVersion()));
                }
            }.reg(GameSettingsPanel$$Lambda$13.lambdaFactory$(this, model)).execute();
        }
    }

    void save() {
        VersionSetting vs = Settings.getLastProfile().getSelectedVersionSetting();
        if (this.txtServerIP.hasFocus()) {
            vs.setServerIp(this.txtServerIP.getText());
        }
        if (this.txtPrecalledCommand.hasFocus()) {
            vs.setPrecalledCommand(this.txtPrecalledCommand.getText());
        }
        if (this.txtPermSize.hasFocus()) {
            vs.setPermSize(this.txtPermSize.getText());
        }
        if (this.txtMinecraftArgs.hasFocus()) {
            vs.setMinecraftArgs(this.txtMinecraftArgs.getText());
        }
        if (this.txtJavaArgs.hasFocus()) {
            vs.setJavaArgs(this.txtJavaArgs.getText());
        }
        if (this.txtJavaDir.hasFocus()) {
            vs.setJavaDir(this.txtJavaDir.getText());
        }
        if (this.txtHeight.hasFocus()) {
            vs.setHeight(this.txtHeight.getText());
        }
        if (this.txtWidth.hasFocus()) {
            vs.setWidth(this.txtWidth.getText());
        }
        if (this.txtMaxMemory.hasFocus()) {
            vs.setMaxMemory(this.txtMaxMemory.getText());
        }
    }

    @Override
    public void onCreate() {
        this.initGui();
        super.onCreate();
        Settings.onProfileLoading();
    }

    @Override
    public void onLeave() {
        super.onLeave();
        this.save();
    }

    public void showGameDownloads() {
        this.tabVersionEdit.setSelectedComponent(this.pnlGameDownloads);
    }

    private void loadProfiles() {
        this.isLoading = true;
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (Profile s : Settings.getProfilesFiltered()) {
            model.addElement(s.getName());
        }
        this.cboProfiles.setModel(model);
        this.isLoading = false;
    }

    void loadVersions() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (MinecraftVersion each : Settings.getLastProfile().service().version().getVersions()) {
            if (each.hidden) continue;
            model.addElement(each.id);
        }
        this.cboVersions.setModel(model);
        if (Settings.getLastProfile().getSelectedVersion() != null) {
            this.selectedVersionChangedEvent.accept(Settings.getLastProfile().getSelectedVersion());
        }
    }

    public void versionChanged(String version) {
        this.isLoading = true;
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.cboVersions.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!model.getElementAt(i).equals(version)) continue;
            model.setSelectedItem(version);
            break;
        }
        this.cboVersions.setToolTipText(version);
        this.mcVersion = version;
        this.reloadMods();
        this.prepareVersionSetting(Settings.getLastProfile().getVersionSetting(version));
        this.loadMinecraftVersion(version);
        for (InstallerPanel p : this.installerPanels) {
            p.loadVersions();
        }
        this.isLoading = false;
    }

    private /* synthetic */ void lambda$new$27(Profile t) {
        t.service().version().onRefreshedVersions.register(this.onRefreshedVersions);
        t.selectedVersionChangedEvent.register(this.selectedVersionChangedEvent);
        this.txtGameDir.setText(t.getGameDir());
        this.isLoading = true;
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.cboProfiles.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!model.getElementAt(i).equals(t.getName())) continue;
            model.setSelectedItem(t.getName());
            break;
        }
        this.isLoading = false;
    }

    private /* synthetic */ void lambda$new$26(IMinecraftService t) {
        if (Settings.getLastProfile().service() == t) {
            this.loadVersions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$reloadMods$25(DefaultTableModel model, List t) {
        Object object = this.modLock;
        synchronized (object) {
            for (ModInfo x : t) {
                model.addRow(new Object[]{x.isActive(), x, x.version});
            }
            this.reloadingMods = false;
        }
    }

    private /* synthetic */ void lambda$initExternalModsTable$24(TableModelEvent e) {
        if (e.getType() == 0 && e.getColumn() == 0) {
            int row = this.lstExternalMods.getSelectedRow();
            List<ModInfo> mods = Settings.getLastProfile().service().mod().getMods(Settings.getLastProfile().getSelectedVersion());
            if (mods != null && mods.size() > row && row >= 0) {
                mods.get(row).reverseModState();
            }
        }
    }

    private /* synthetic */ void lambda$initExternalModsTable$23(ListSelectionEvent e) {
        int row = this.lstExternalMods.getSelectedRow();
        List<ModInfo> mods = Settings.getLastProfile().service().mod().getMods(Settings.getLastProfile().getSelectedVersion());
        if (mods != null && 0 <= row && row < mods.size()) {
            ModInfo m = mods.get(row);
            boolean hasLink = m.url != null;
            String text = "<html>" + (hasLink ? "<a href=\"" + m.url + "\">" : "") + m.getName() + (hasLink ? "</a>" : "");
            text = text + " by " + m.getAuthor();
            String description = "No mod description found";
            if (m.description != null) {
                description = "";
                for (String desc : m.description.split("\n")) {
                    description = description + SwingUtils.getParsedJPanelText(this.lblModInfo, desc) + "<br/>";
                }
            }
            text = text + "<br>" + description;
            this.lblModInfo.setText(text);
            this.lblModInfo.setCursor(new Cursor(hasLink ? 12 : 0));
        }
    }

    private /* synthetic */ void lambda$initManagementMenu$22(ActionEvent e) {
        if (this.mcVersion != null) {
            FileUtils.deleteDirectoryQuietly(new File(Settings.getLastProfile().service().baseDirectory(), "libraries"));
        }
    }

    private /* synthetic */ void lambda$initManagementMenu$21(ActionEvent e) {
        if (this.mcVersion != null) {
            Settings.getLastProfile().service().asset().refreshAssetsIndex(this.mcVersion);
        }
    }

    private /* synthetic */ void lambda$initManagementMenu$20(ActionEvent e) {
        if (this.mcVersion != null) {
            Settings.getLastProfile().service().download().downloadMinecraftVersionJson(this.mcVersion);
        }
    }

    private /* synthetic */ void lambda$initManagementMenu$19(ActionEvent e) {
        if (this.mcVersion != null && MessageBox.Show(C.i18n("versions.manage.remove.confirm", new Object[0]) + this.mcVersion, 10) == 0 && Settings.getLastProfile().service().version().removeVersionFromDisk(this.mcVersion)) {
            this.refreshVersions();
        }
    }

    private /* synthetic */ void lambda$initManagementMenu$18(ActionEvent e) {
        String newName;
        if (this.mcVersion != null && (newName = JOptionPane.showInputDialog(C.i18n("versions.manage.rename.message", new Object[0]), (Object)this.mcVersion)) != null && Settings.getLastProfile().service().version().renameVersion(this.mcVersion, newName)) {
            this.refreshVersions();
        }
    }

    private /* synthetic */ void lambda$new$17() {
        MainFrame.INSTANCE.selectTab("game");
        this.showGameDownloads();
    }

    static /* synthetic */ void access$lambda$0(GameSettingsPanel gameSettingsPanel) {
        gameSettingsPanel.loadProfiles();
    }

    static /* synthetic */ void access$lambda$1(GameSettingsPanel gameSettingsPanel, IMinecraftService iMinecraftService) {
        gameSettingsPanel.lambda$new$26(iMinecraftService);
    }

    static /* synthetic */ void access$lambda$2(GameSettingsPanel gameSettingsPanel, String string) {
        gameSettingsPanel.versionChanged(string);
    }

    static /* synthetic */ void access$lambda$3(GameSettingsPanel gameSettingsPanel, Profile profile) {
        gameSettingsPanel.lambda$new$27(profile);
    }

    static /* synthetic */ void access$lambda$4(GameSettingsPanel gameSettingsPanel) {
        gameSettingsPanel.lambda$new$17();
    }

    static /* synthetic */ void access$lambda$5(GameSettingsPanel gameSettingsPanel, ActionEvent actionEvent) {
        gameSettingsPanel.lambda$initManagementMenu$18(actionEvent);
    }

    static /* synthetic */ void access$lambda$6(GameSettingsPanel gameSettingsPanel, ActionEvent actionEvent) {
        gameSettingsPanel.lambda$initManagementMenu$19(actionEvent);
    }

    static /* synthetic */ void access$lambda$7(GameSettingsPanel gameSettingsPanel, ActionEvent actionEvent) {
        gameSettingsPanel.lambda$initManagementMenu$20(actionEvent);
    }

    static /* synthetic */ void access$lambda$8(GameSettingsPanel gameSettingsPanel, ActionEvent actionEvent) {
        gameSettingsPanel.lambda$initManagementMenu$21(actionEvent);
    }

    static /* synthetic */ void access$lambda$9(GameSettingsPanel gameSettingsPanel, ActionEvent actionEvent) {
        gameSettingsPanel.lambda$initManagementMenu$22(actionEvent);
    }

    static /* synthetic */ void access$lambda$10(GameSettingsPanel gameSettingsPanel, ListSelectionEvent listSelectionEvent) {
        gameSettingsPanel.lambda$initExternalModsTable$23(listSelectionEvent);
    }

    static /* synthetic */ void access$lambda$11(GameSettingsPanel gameSettingsPanel, TableModelEvent tableModelEvent) {
        gameSettingsPanel.lambda$initExternalModsTable$24(tableModelEvent);
    }

    static /* synthetic */ void access$lambda$12(GameSettingsPanel gameSettingsPanel, DefaultTableModel defaultTableModel, List list) {
        gameSettingsPanel.lambda$reloadMods$25(defaultTableModel, list);
    }
}

