/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jackhuang.hellominecraft.launcher.Main;
import org.jackhuang.hellominecraft.launcher.core.auth.IAuthenticator;
import org.jackhuang.hellominecraft.launcher.setting.Settings;
import org.jackhuang.hellominecraft.launcher.ui.AnimatedPanel;
import org.jackhuang.hellominecraft.launcher.ui.DraggableFrame;
import org.jackhuang.hellominecraft.launcher.ui.GameSettingsPanel;
import org.jackhuang.hellominecraft.launcher.ui.HeaderTab;
import org.jackhuang.hellominecraft.launcher.ui.LauncherSettingsPanel;
import org.jackhuang.hellominecraft.launcher.ui.LaunchingUIDaemon;
import org.jackhuang.hellominecraft.launcher.ui.MainFrame$$Lambda$1;
import org.jackhuang.hellominecraft.launcher.ui.MainFrame$$Lambda$2;
import org.jackhuang.hellominecraft.launcher.ui.MainFrame$$Lambda$3;
import org.jackhuang.hellominecraft.launcher.ui.MainFrame$$Lambda$4;
import org.jackhuang.hellominecraft.launcher.ui.MainFrame$$Lambda$5;
import org.jackhuang.hellominecraft.launcher.ui.MainFrame$$Lambda$6;
import org.jackhuang.hellominecraft.launcher.ui.MainFrame$$Lambda$7;
import org.jackhuang.hellominecraft.launcher.ui.MainPagePanel;
import org.jackhuang.hellominecraft.lookandfeel.Theme;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.MessageBox;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.ui.BasicColors;
import org.jackhuang.hellominecraft.util.ui.DropShadowBorder;
import org.jackhuang.hellominecraft.util.ui.GraphicsUtils;
import org.jackhuang.hellominecraft.util.ui.SwingUtils;
import org.jackhuang.hellominecraft.util.ui.TintablePanel;

public final class MainFrame
extends DraggableFrame {
    public static final MainFrame INSTANCE = new MainFrame();
    TintablePanel centralPanel;
    JPanel header;
    JPanel infoSwap;
    JPanel realPanel;
    CardLayout infoLayout;
    JLabel backgroundLabel;
    JLabel windowTitle;
    DropShadowBorder border;
    boolean enableShadow;
    String defaultTitle;
    private int tempW;
    private int tempH;
    private final ActionListener tabListener = MainFrame$$Lambda$1.lambdaFactory$(this);
    private final List<HeaderTab> tabHeader = new ArrayList<HeaderTab>();
    private JPanel[] tabWrapper;
    private final List<AnimatedPanel> tabContent = new ArrayList<AnimatedPanel>();
    ImageIcon background;
    boolean isShowedMessage = false;
    Color borderColor;
    Color borderColorDarker;
    LaunchingUIDaemon daemon = new LaunchingUIDaemon();
    final HashMap<String, Runnable> actions = new HashMap();

    void setContentSize(int w, int h) {
        this.setSize(w, h);
        this.tempW = w;
        this.tempH = h;
    }

    MainFrame() {
        this.setUndecorated(!Settings.getInstance().isDecorated());
        this.defaultTitle = this.isUndecorated() ? Main.makeTitle() : "";
        boolean bl = this.enableShadow = Settings.getInstance().isEnableShadow() && this.isUndecorated();
        if (this.enableShadow) {
            this.setContentSize(834, 542);
        } else {
            this.setContentSize(802, 511);
        }
        this.setDefaultCloseOperation(3);
        this.setTitle(Main.makeTitle());
        this.initComponents();
        this.loadBackground();
        this.setLocationRelativeTo(null);
        if (this.isUndecorated()) {
            this.setResizable(false);
        }
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                MainFrame.this.closing();
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
                if (!MainFrame.this.isUndecorated()) {
                    int w = MainFrame.this.tempW + MainFrame.this.getWidth() - MainFrame.this.getContentPane().getWidth();
                    int h = MainFrame.this.tempH + MainFrame.this.getHeight() - MainFrame.this.getContentPane().getHeight();
                    MainFrame.this.setSize(w, h);
                    MainFrame.this.setResizable(false);
                    MainFrame.this.setLocationRelativeTo(null);
                }
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        if (this.enableShadow) {
            try {
                this.setBackground(new Color(0, 0, 0, 0));
                this.border = new DropShadowBorder(this.borderColor, 4);
                this.getRootPane().setBorder(this.border);
            }
            catch (Throwable ex) {
                HMCLog.err("Failed to set window transparent.", ex);
                Settings.getInstance().setEnableShadow(false);
                this.setSize(802, 511);
            }
        }
        ((JPanel)this.getContentPane()).setOpaque(true);
        Settings.getInstance().themeChangedEvent.register(MainFrame$$Lambda$2.lambdaFactory$(this));
        SwingUtilities.invokeLater(MainFrame$$Lambda$3.lambdaFactory$(this));
    }

    private void initComponents() {
        this.initBorderColor(Settings.getInstance().getTheme());
        this.realPanel = new JPanel();
        this.realPanel.setLayout(null);
        this.header = new JPanel();
        this.header.setBounds(0, 0, 800, 30);
        this.realPanel.add(this.header);
        this.header.setOpaque(true);
        this.header.setLayout(new BoxLayout(this.header, 2));
        this.header.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 5));
        this.header.setBackground(this.borderColor);
        this.header.setForeground(BasicColors.COLOR_WHITE_TEXT);
        ImageIcon headerIcon = Main.getIcon("icon.png");
        this.setIconImage(headerIcon.getImage());
        headerIcon = SwingUtils.scaleImage(headerIcon, 16, 16);
        JLabel headerLabel = new JLabel(headerIcon);
        headerLabel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        this.header.add(headerLabel);
        this.header.add(Box.createRigidArea(new Dimension(8, 0)));
        this.initializeTab(new MainPagePanel(), "main");
        this.initializeTab(new GameSettingsPanel(this), "game");
        this.initializeTab(new LauncherSettingsPanel(), "launcher");
        this.header.add(Box.createHorizontalGlue());
        JPanel rightHeaderPanel = new JPanel();
        rightHeaderPanel.setOpaque(false);
        rightHeaderPanel.setLayout(new BoxLayout(rightHeaderPanel, 3));
        rightHeaderPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        JPanel windowGadgetPanel = new JPanel();
        windowGadgetPanel.setOpaque(false);
        windowGadgetPanel.setLayout(new BoxLayout(windowGadgetPanel, 2));
        windowGadgetPanel.setAlignmentX(1.0f);
        if (!Settings.getInstance().isDecorated()) {
            ImageIcon minimizeIcon = Main.getIcon("minimize.png");
            JButton minimizeButton = new JButton(minimizeIcon);
            minimizeButton.setBorder(BorderFactory.createEmptyBorder());
            minimizeButton.setContentAreaFilled(false);
            minimizeButton.setCursor(new Cursor(12));
            minimizeButton.setFocusable(false);
            minimizeButton.addActionListener(MainFrame$$Lambda$4.lambdaFactory$(this));
            windowGadgetPanel.add(minimizeButton);
            ImageIcon closeIcon = Main.getIcon("close.png");
            JButton closeButton = new JButton(closeIcon);
            closeButton.setBorder(BorderFactory.createEmptyBorder());
            closeButton.setContentAreaFilled(false);
            closeButton.addActionListener(MainFrame$$Lambda$5.lambdaFactory$(this));
            closeButton.setCursor(new Cursor(12));
            closeButton.setFocusable(false);
            windowGadgetPanel.add(closeButton);
        }
        rightHeaderPanel.add(windowGadgetPanel);
        this.windowTitle = new JLabel(this.defaultTitle);
        this.windowTitle.setForeground(BasicColors.COLOR_WHITE_TEXT);
        this.windowTitle.addMouseListener(MouseListenerImpl.INSTANCE);
        this.header.add(this.windowTitle);
        this.header.add(Box.createHorizontalGlue());
        this.header.add(rightHeaderPanel);
        this.centralPanel = new TintablePanel();
        this.centralPanel.setTintColor(BasicColors.COLOR_CENTRAL_BACK);
        this.realPanel.add(this.centralPanel);
        JPanel truePanel = new JPanel();
        truePanel.setLayout(new BorderLayout());
        this.infoSwap = new JPanel();
        this.infoLayout = new CardLayout();
        this.infoSwap.setLayout(this.infoLayout);
        this.infoSwap.setOpaque(false);
        this.tabWrapper = new JPanel[this.tabHeader.size()];
        for (int i = 0; i < this.tabHeader.size(); ++i) {
            this.tabWrapper[i] = new JPanel();
            this.tabWrapper[i].setLayout(new GridLayout());
            this.infoSwap.add((Component)this.tabWrapper[i], this.tabHeader.get(i).getActionCommand());
        }
        truePanel.add((Component)this.infoSwap, "Center");
        this.centralPanel.setLayout(null);
        this.centralPanel.add(truePanel);
        truePanel.setBounds(0, 0, 800, 480);
        this.centralPanel.setBounds(0, 30, 800, 480);
        this.setLayout(null);
        this.realPanel.setBounds(1, 0, 800, 511);
        this.add(this.realPanel);
    }

    private void initializeTab(AnimatedPanel inst, String cmd) {
        HeaderTab tab = new HeaderTab(C.i18n("launcher.title." + cmd, new Object[0]));
        tab.setActionCommand(cmd);
        tab.setForeground(BasicColors.COLOR_WHITE_TEXT);
        tab.setBackground(this.borderColorDarker);
        tab.setLayout(null);
        tab.addActionListener(this.tabListener);
        this.header.add(tab);
        this.tabHeader.add(tab);
        this.tabContent.add(inst);
    }

    public void selectTab(String tabName) {
        int i;
        int chosen = -1;
        AnimatedPanel onCreate = null;
        AnimatedPanel onSelect = null;
        for (i = 0; i < this.tabHeader.size(); ++i) {
            if (!tabName.equalsIgnoreCase(this.tabHeader.get(i).getActionCommand())) continue;
            if (!this.tabContent.get(i).isCreated()) {
                onCreate = this.tabContent.get(i);
                this.tabWrapper[i].add(this.tabContent.get(i));
            } else if (this.tabContent.get(i).isSelected()) continue;
            chosen = i;
            break;
        }
        if (chosen != -1) {
            for (i = 0; i < this.tabHeader.size(); ++i) {
                if (i == chosen || this.tabContent.get(i) == null || !this.tabContent.get(i).isSelected()) continue;
                this.tabContent.get(i).onLeave();
            }
            for (i = 0; i < this.tabHeader.size(); ++i) {
                if (i != chosen) continue;
                for (int j = 0; j < this.tabHeader.size(); ++j) {
                    if (j == i) continue;
                    this.tabHeader.get(j).setIsActive(false);
                }
                this.tabHeader.get(i).setIsActive(true);
                onSelect = this.tabContent.get(i);
            }
            this.infoLayout.show(this.infoSwap, tabName);
            if (onCreate != null) {
                onCreate.onCreate();
            }
            if (onSelect != null) {
                onSelect.onSelect();
            }
        }
    }

    protected void closing() {
        for (int i = 0; i < this.tabHeader.size(); ++i) {
            if (this.tabContent.get(i) == null || !this.tabContent.get(i).isSelected()) continue;
            this.tabContent.get(i).onLeave();
        }
    }

    protected void closeWindow() {
        this.closing();
        System.exit(0);
    }

    protected void minimizeWindow() {
        this.setState(1);
    }

    public void loadBackground() {
        this.background = SwingUtils.searchBackgroundImage(Main.getIcon(Settings.getInstance().getTheme().settings.get("Customized.MainFrame.background_image")), Settings.getInstance().getBgpath(), 800, 480);
        if (this.background != null) {
            if (this.backgroundLabel == null) {
                this.backgroundLabel = new JLabel(this.background);
                this.backgroundLabel.setBounds(0, 0, 800, 480);
                this.centralPanel.add((Component)this.backgroundLabel, -1);
            } else {
                this.backgroundLabel.setIcon(this.background);
            }
        } else {
            HMCLog.warn("No background image here! The background will be empty!");
        }
    }

    public JPanel getTitleBar() {
        return this.header;
    }

    public void closeMessage() {
        if (this.isShowedMessage) {
            this.isShowedMessage = false;
            this.reloadColor(Settings.getInstance().getTheme());
            this.windowTitle.setText(this.defaultTitle);
            this.windowTitle.setForeground(Settings.UPDATE_CHECKER.OUT_DATED ? Color.red : Color.white);
        }
    }

    public void showMessage(String message) {
        this.isShowedMessage = true;
        this.borderColor = BasicColors.COLOR_RED;
        this.borderColorDarker = BasicColors.COLOR_RED_DARKER;
        this.header.setBackground(this.borderColor);
        for (HeaderTab tab : this.tabHeader) {
            tab.setBackground(this.borderColorDarker);
        }
        if (this.border != null) {
            this.border.setColor(this.borderColor);
        }
        this.repaint();
        this.windowTitle.setText(message);
        this.windowTitle.setForeground(Color.white);
    }

    public static void showMainFrame() {
        IAuthenticator l = Settings.getInstance().getAuthenticator();
        if (StrUtils.isBlank(l.getUserName())) {
            SwingUtilities.invokeLater(MainFrame$$Lambda$6.lambdaFactory$());
        }
        if (l.hasPassword() && !l.isLoggedIn()) {
            SwingUtilities.invokeLater(MainFrame$$Lambda$7.lambdaFactory$());
        }
        INSTANCE.setVisible(true);
    }

    private void initBorderColor(Theme t) {
        this.borderColor = GraphicsUtils.getWebColor(t.settings.get("Customized.MainFrame.background"));
        this.borderColorDarker = GraphicsUtils.getWebColor(t.settings.get("Customized.MainFrame.selected_background"));
    }

    public void reloadColor(Theme t) {
        this.initBorderColor(t);
        if (this.border != null) {
            this.border.setColor(this.borderColor);
        }
        this.header.setBackground(this.borderColor);
        for (HeaderTab tab : this.tabHeader) {
            tab.setBackground(this.borderColorDarker);
        }
        this.repaint();
    }

    private void paintImpl(Graphics g) {
        int off = this.enableShadow ? 16 : 0;
        int yoff = this.getInsets().top + off;
        int xoff = this.getInsets().left + off;
        int width = 800;
        int height = this.header.getHeight() + 480 - 1;
        super.paint(g);
        g.setColor(this.borderColor);
        g.drawLine(xoff, yoff, xoff, height + yoff + 1);
        g.drawLine(xoff + width + 1, yoff, xoff + width + 1, height + yoff + 1);
        g.drawLine(xoff, height + yoff + 1, xoff + width + 1, height + yoff + 1);
    }

    @Override
    public void paint(Graphics g) {
        if (!this.enableShadow) {
            this.paintImpl(g);
        } else {
            int off = this.enableShadow ? 16 : 0;
            int width = this.getWidth();
            int height = this.getHeight();
            int contentWidth = width - off - off;
            int contentHeight = height - off - off;
            BufferedImage contentImage = new BufferedImage(contentWidth, contentHeight, 1);
            Graphics2D contentG2d = contentImage.createGraphics();
            contentG2d.translate(-off, -off);
            this.paintImpl(g);
            this.paintImpl(contentG2d);
            contentG2d.dispose();
            g.drawImage(contentImage, off, off, this);
        }
    }

    public void invokeUpdate() {
        this.defaultTitle = Main.makeTitle() + C.i18n("update.found", new Object[0]);
        if (!this.isShowedMessage) {
            this.windowTitle.setText(this.defaultTitle);
            this.windowTitle.setForeground(Color.red);
        }
    }

    public void failed(String s) {
        if (s != null) {
            MessageBox.Show(s);
        }
        this.closeMessage();
    }

    void invokeAction(String name) {
        if (this.actions.containsKey(name)) {
            this.actions.get(name).run();
        }
    }

    private /* synthetic */ void lambda$new$32(ActionEvent e) {
        this.selectTab(e.getActionCommand());
    }

    private /* synthetic */ void lambda$initComponents$31(ActionEvent e) {
        this.closeWindow();
    }

    private /* synthetic */ void lambda$initComponents$30(ActionEvent e) {
        this.minimizeWindow();
    }

    private /* synthetic */ void lambda$new$29() {
        this.selectTab("main");
    }

    static /* synthetic */ void access$lambda$0(MainFrame mainFrame, ActionEvent actionEvent) {
        mainFrame.lambda$new$32(actionEvent);
    }

    static /* synthetic */ void access$lambda$1(MainFrame mainFrame, Theme theme) {
        mainFrame.reloadColor(theme);
    }

    static /* synthetic */ void access$lambda$2(MainFrame mainFrame) {
        mainFrame.lambda$new$29();
    }

    static /* synthetic */ void access$lambda$3(MainFrame mainFrame, ActionEvent actionEvent) {
        mainFrame.lambda$initComponents$30(actionEvent);
    }

    static /* synthetic */ void access$lambda$4(MainFrame mainFrame, ActionEvent actionEvent) {
        mainFrame.lambda$initComponents$31(actionEvent);
    }

    static /* synthetic */ void access$lambda$5() {
        MainFrame.INSTANCE.showMessage(C.i18n("ui.message.first_load", new Object[0]));
    }

    static /* synthetic */ void access$lambda$6() {
        MainFrame.INSTANCE.showMessage(C.i18n("ui.message.enter_password", new Object[0]));
    }

    private static class MouseListenerImpl
    implements MouseListener {
        public static final MouseListenerImpl INSTANCE = new MouseListenerImpl();

        private MouseListenerImpl() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Settings.UPDATE_CHECKER.checkOutdate();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

