/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.util;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.jackhuang.hellominecraft.launcher.setting.Settings;
import org.jackhuang.hellominecraft.launcher.util.CrashReporter$$Lambda$1;
import org.jackhuang.hellominecraft.launcher.util.CrashReporter$$Lambda$2;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.MessageBox;
import org.jackhuang.hellominecraft.util.NetUtils;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.OS;
import org.jackhuang.hellominecraft.util.ui.LogWindow;

public class CrashReporter
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOGGER = Logger.getLogger(CrashReporter.class.getName());
    private static final HashMap<String, String> SOURCE = new HashMap<String, String>(){
        {
            this.put("MessageBox", "");
            this.put("AWTError", "");
            this.put("JFileChooser", "Has your operating system been installed completely or is a ghost system?");
            this.put("Jce", "Has your operating system been installed completely or is a ghost system?");
            this.put("couldn't create component peer", "Fucking computer!");
            this.put("sun.awt.shell.Win32ShellFolder2", "crash.user_fault");
            this.put("UnsatisfiedLinkError", "crash.user_fault");
            this.put("java.awt.HeadlessException", "crash.headless");
            this.put("java.lang.NoClassDefFoundError", "crash.NoClassDefFound");
            this.put("java.lang.VerifyError", "crash.NoClassDefFound");
            this.put("java.lang.NoSuchMethodError", "crash.NoClassDefFound");
            this.put("java.lang.IncompatibleClassChangeError", "crash.NoClassDefFound");
            this.put("java.lang.ClassFormatError", "crash.NoClassDefFound");
            this.put("java.lang.OutOfMemoryError", "FUCKING MEMORY LIMIT!");
            this.put("Trampoline", "ui.message.update_java");
            this.put("NoSuchAlgorithmException", "Has your operating system been installed completely or is a ghost system?");
        }
    };
    boolean enableLogger = false;
    private static final HashSet<String> THROWABLE_SET = new HashSet();

    public CrashReporter(boolean enableLogger) {
        this.enableLogger = enableLogger;
    }

    public boolean checkThrowable(Throwable e) {
        String s = StrUtils.getStackTrace(e);
        for (Map.Entry<String, String> entry : SOURCE.entrySet()) {
            if (!s.contains(entry.getKey())) continue;
            if (StrUtils.isNotBlank(entry.getValue())) {
                String info = C.i18n(entry.getKey(), new Object[0]);
                LOGGER.severe(info);
                try {
                    this.showMessage(info);
                }
                catch (Throwable t) {
                    LOGGER.log(Level.SEVERE, "Failed to show message", t);
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        String s = StrUtils.getStackTrace(e);
        if (!s.contains("org.jackhuang")) {
            return;
        }
        try {
            String text = "\n---- Hello Minecraft! Crash Report ----\n";
            text = text + "  Version: 2.4.1.233\n";
            text = text + "  Time: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "\n";
            text = text + "  Thread: " + t.toString() + "\n";
            text = text + "\n  Content: \n    ";
            text = text + s + "\n\n";
            text = text + "-- System Details --\n";
            text = text + "  Operating System: " + OS.getSystemVersion() + "\n";
            text = text + "  Java Version: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor") + "\n";
            text = text + "  Java VM Version: " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor") + "\n";
            if (this.enableLogger) {
                HMCLog.err(text);
            } else {
                System.out.println(text);
            }
            if (this.checkThrowable(e) && !System.getProperty("java.vm.name").contains("OpenJDK")) {
                SwingUtilities.invokeLater(CrashReporter$$Lambda$1.lambdaFactory$());
                if (!Settings.UPDATE_CHECKER.OUT_DATED) {
                    this.reportToServer(text, s);
                }
            }
        }
        catch (Throwable ex) {
            LOGGER.log(Level.SEVERE, "Failed to caught exception", ex);
            LOGGER.log(Level.SEVERE, "There is the original exception", e);
        }
    }

    void showMessage(String s) {
        try {
            MessageBox.Show(s, "ERROR", 0);
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "ERROR", e);
        }
    }

    void reportToServer(String text, String stacktrace) {
        if (THROWABLE_SET.contains(stacktrace)) {
            return;
        }
        THROWABLE_SET.add(stacktrace);
        Thread t = new Thread(CrashReporter$$Lambda$2.lambdaFactory$(text));
        t.setDaemon(true);
        t.start();
    }

    private static /* synthetic */ void lambda$reportToServer$53(String text) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("CrashReport", text);
        try {
            NetUtils.post(NetUtils.constantURL("http://huangyuhui.duapp.com/crash.php"), map);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Failed to post HMCL server.", ex);
        }
    }

    static /* synthetic */ void access$lambda$0() {
        LogWindow.INSTANCE.showAsCrashWindow(Settings.UPDATE_CHECKER.OUT_DATED);
    }

    static /* synthetic */ void access$lambda$1(String string) {
        CrashReporter.lambda$reportToServer$53(string);
    }
}

