/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.util;

import org.jackhuang.hellominecraft.launcher.api.IPlugin;
import org.jackhuang.hellominecraft.launcher.core.auth.IAuthenticator;
import org.jackhuang.hellominecraft.launcher.core.auth.OfflineAuthenticator;
import org.jackhuang.hellominecraft.launcher.core.auth.SkinmeAuthenticator;
import org.jackhuang.hellominecraft.launcher.core.auth.UserProfileProvider;
import org.jackhuang.hellominecraft.launcher.core.auth.YggdrasilAuthenticator;
import org.jackhuang.hellominecraft.launcher.core.launch.LaunchOptions;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftService;
import org.jackhuang.hellominecraft.launcher.setting.Profile;
import org.jackhuang.hellominecraft.launcher.setting.Settings;
import org.jackhuang.hellominecraft.launcher.ui.MainFrame;
import org.jackhuang.hellominecraft.launcher.util.HMCLMinecraftService;
import org.jackhuang.hellominecraft.util.EventHandler;
import org.jackhuang.hellominecraft.util.func.Consumer;

public class DefaultPlugin
implements IPlugin {
    YggdrasilAuthenticator YGGDRASIL_LOGIN = null;
    OfflineAuthenticator OFFLINE_LOGIN = null;
    SkinmeAuthenticator SKINME_LOGIN = null;
    public final transient EventHandler<LaunchOptions> onProcessingLaunchOptionsEvent = new EventHandler(this);

    @Override
    public IMinecraftService provideMinecraftService(Profile profile) {
        return new HMCLMinecraftService(profile);
    }

    @Override
    public void onRegisterAuthenticators(Consumer<IAuthenticator> apply) {
        String clientToken = Settings.getInstance().getClientToken();
        this.OFFLINE_LOGIN = new OfflineAuthenticator(clientToken);
        this.OFFLINE_LOGIN.onLoadSettings(Settings.getInstance().getAuthenticatorConfig(this.OFFLINE_LOGIN.id()));
        this.YGGDRASIL_LOGIN = new YggdrasilAuthenticator(clientToken);
        this.YGGDRASIL_LOGIN.onLoadSettings(Settings.getInstance().getAuthenticatorConfig(this.YGGDRASIL_LOGIN.id()));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Settings.getInstance().setAuthenticatorConfig(DefaultPlugin.this.OFFLINE_LOGIN.id(), DefaultPlugin.this.OFFLINE_LOGIN.onSaveSettings());
                Settings.getInstance().setAuthenticatorConfig(DefaultPlugin.this.YGGDRASIL_LOGIN.id(), DefaultPlugin.this.YGGDRASIL_LOGIN.onSaveSettings());
            }
        });
        apply.accept(this.OFFLINE_LOGIN);
        apply.accept(this.YGGDRASIL_LOGIN);
    }

    @Override
    public void showUI() {
        MainFrame.showMainFrame();
    }

    @Override
    public void onProcessingLoginResult(UserProfileProvider result) {
    }

    @Override
    public void onProcessingLaunchOptions(LaunchOptions p) {
        this.onProcessingLaunchOptionsEvent.execute(p);
    }
}

