/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.util;

import java.io.File;
import org.jackhuang.hellominecraft.launcher.api.PluginManager;
import org.jackhuang.hellominecraft.launcher.core.GameException;
import org.jackhuang.hellominecraft.launcher.core.auth.AuthenticationException;
import org.jackhuang.hellominecraft.launcher.core.auth.IAuthenticator;
import org.jackhuang.hellominecraft.launcher.core.auth.LoginInfo;
import org.jackhuang.hellominecraft.launcher.core.launch.DefaultGameLauncher;
import org.jackhuang.hellominecraft.launcher.core.launch.GameLauncher;
import org.jackhuang.hellominecraft.launcher.core.launch.LaunchOptions;
import org.jackhuang.hellominecraft.launcher.setting.Profile;
import org.jackhuang.hellominecraft.launcher.setting.Settings;
import org.jackhuang.hellominecraft.launcher.util.HMCLGameLauncher$1$$Lambda$1;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.EventHandler;
import org.jackhuang.hellominecraft.util.func.Consumer;
import org.jackhuang.hellominecraft.util.logging.HMCLog;

public class HMCLGameLauncher {
    Profile profile;
    boolean isLaunching = false;
    public final EventHandler<Boolean> launchingStateChanged = new EventHandler(this);

    public HMCLGameLauncher(Profile p) {
        this.profile = p;
    }

    void setLaunching(boolean isLaunching) {
        if (isLaunching != this.isLaunching) {
            this.launchingStateChanged.execute(isLaunching);
        }
        this.isLaunching = isLaunching;
    }

    public void genLaunchCode(final Consumer<GameLauncher> listener, final Consumer<String> failed, String passwordIfNeeded) {
        if (this.isLaunching || this.profile == null) {
            return;
        }
        this.setLaunching(true);
        HMCLog.log("Start generating launching command...");
        File file = this.profile.getCanonicalGameDirFile();
        if (!file.exists()) {
            failed.accept(C.i18n("minecraft.wrong_path", new Object[0]));
            this.setLaunching(false);
            return;
        }
        if (this.profile.getSelectedVersion() == null) {
            failed.accept(C.i18n("minecraft.no_selected_version", new Object[0]));
            this.setLaunching(false);
            return;
        }
        final IAuthenticator l = IAuthenticator.LOGINS.get(Settings.getInstance().getLoginType());
        final LoginInfo li = new LoginInfo(l.getUserName(), l.isLoggedIn() || !l.hasPassword() ? null : passwordIfNeeded);
        Thread t = new Thread(){

            @Override
            public void run() {
                Thread.currentThread().setName("Game Launcher");
                try {
                    LaunchOptions options = HMCLGameLauncher.this.profile.getSelectedVersionSetting().createLaunchOptions(HMCLGameLauncher.this.profile.getCanonicalGameDirFile());
                    PluginManager.plugin().onProcessingLaunchOptions(options);
                    DefaultGameLauncher gl = new DefaultGameLauncher(options, HMCLGameLauncher.this.profile.service(), li, l);
                    gl.setTag((Object)HMCLGameLauncher.this.profile.getSelectedVersionSetting().getLauncherVisibility());
                    gl.successEvent.register(HMCLGameLauncher$1$$Lambda$1.lambdaFactory$(this));
                    listener.accept(gl);
                    gl.makeLaunchCommand();
                }
                catch (GameException e) {
                    failed.accept(C.i18n("launch.failed", new Object[0]) + ", " + e.getMessage());
                    HMCLGameLauncher.this.setLaunching(false);
                }
                catch (AuthenticationException e) {
                    failed.accept(C.i18n("login.failed", new Object[0]) + ", " + e.getMessage());
                    HMCLGameLauncher.this.setLaunching(false);
                }
            }

            private /* synthetic */ void lambda$run$3() {
                HMCLGameLauncher.this.setLaunching(false);
            }

            static /* synthetic */ void access$lambda$0(1 var0) {
                var0.lambda$run$3();
            }
        };
        t.setDaemon(true);
        t.start();
    }
}

