/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.util;

import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jackhuang.hellominecraft.launcher.core.GameException;
import org.jackhuang.hellominecraft.launcher.core.asset.MinecraftAssetService;
import org.jackhuang.hellominecraft.launcher.core.auth.UserProfileProvider;
import org.jackhuang.hellominecraft.launcher.core.download.MinecraftDownloadService;
import org.jackhuang.hellominecraft.launcher.core.install.MinecraftInstallerService;
import org.jackhuang.hellominecraft.launcher.core.launch.LaunchOptions;
import org.jackhuang.hellominecraft.launcher.core.launch.MinecraftLoader;
import org.jackhuang.hellominecraft.launcher.core.mod.MinecraftModService;
import org.jackhuang.hellominecraft.launcher.core.mod.ModpackManager;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftAssetService;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftDownloadService;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftInstallerService;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftLoader;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftModService;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftProvider;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftService;
import org.jackhuang.hellominecraft.launcher.setting.Profile;
import org.jackhuang.hellominecraft.launcher.setting.VersionSetting;
import org.jackhuang.hellominecraft.launcher.ui.MainFrame;
import org.jackhuang.hellominecraft.launcher.util.HMCLGameProvider;
import org.jackhuang.hellominecraft.launcher.util.HMCLMinecraftService$$Lambda$1;
import org.jackhuang.hellominecraft.launcher.util.HMCLMinecraftService$$Lambda$2;
import org.jackhuang.hellominecraft.launcher.util.HMCLMinecraftService$$Lambda$3;
import org.jackhuang.hellominecraft.launcher.util.HMCLMinecraftService$$Lambda$4;
import org.jackhuang.hellominecraft.launcher.util.HMCLMinecraftService$$Lambda$5;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.EventHandler;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.FileUtils;
import org.jackhuang.hellominecraft.util.tasks.TaskWindow;

public class HMCLMinecraftService
extends IMinecraftService {
    Profile p;
    final Map<String, VersionSetting> versionSettings = new HashMap<String, VersionSetting>();
    public boolean checkedModpack = false;
    public boolean checkingModpack = false;
    protected IMinecraftProvider provider;
    protected MinecraftModService mms;
    protected MinecraftDownloadService mds;
    final MinecraftAssetService mas;
    protected MinecraftInstallerService mis;

    public HMCLMinecraftService(Profile p) {
        this.p = p;
        this.provider = new HMCLGameProvider(this);
        this.provider.initializeMiencraft();
        EventHandler<IMinecraftService> eventHandler = this.provider.onRefreshingVersions;
        Map<String, VersionSetting> map = this.versionSettings;
        map.getClass();
        eventHandler.register(HMCLMinecraftService$$Lambda$1.lambdaFactory$(map));
        this.provider.onRefreshedVersions.register(HMCLMinecraftService$$Lambda$2.lambdaFactory$(this));
        this.provider.onLoadedVersion.register(HMCLMinecraftService$$Lambda$3.lambdaFactory$(this));
        this.mms = new MinecraftModService(this);
        this.mds = new MinecraftDownloadService(this);
        this.mas = new MinecraftAssetService(this);
        this.mis = new MinecraftInstallerService(this);
    }

    private void checkModpack() {
        if (!this.checkingModpack) {
            File modpack;
            this.checkingModpack = true;
            if (this.version().getVersionCount() == 0 && (modpack = new File("modpack.zip")).exists()) {
                SwingUtilities.invokeLater(HMCLMinecraftService$$Lambda$4.lambdaFactory$(this, modpack));
            }
        }
    }

    private void loadVersionSetting(String id) {
        String s;
        if (this.provider.getVersionById(id) == null) {
            return;
        }
        VersionSetting vs = null;
        File f = new File(this.provider.versionRoot(id), "hmclversion.cfg");
        if (f.exists() && (s = FileUtils.readQuietly(f)) != null) {
            try {
                vs = C.GSON.fromJson(s, VersionSetting.class);
            }
            catch (JsonSyntaxException ex) {
                HMCLog.warn("Failed to load version setting: " + id, ex);
                vs = null;
            }
        }
        if (vs == null) {
            vs = new VersionSetting();
        }
        vs.id = id;
        vs.propertyChanged.register(HMCLMinecraftService$$Lambda$5.lambdaFactory$(this));
        this.versionSettings.put(id, vs);
    }

    public VersionSetting getVersionSetting(String id) {
        if (!this.versionSettings.containsKey(id)) {
            this.loadVersionSetting(id);
        }
        return this.versionSettings.get(id);
    }

    public void saveVersionSetting(String id) {
        if (!this.versionSettings.containsKey(id)) {
            return;
        }
        File f = new File(this.provider.versionRoot(id), "hmclversion.cfg");
        FileUtils.writeQuietly(f, C.GSON.toJson(this.versionSettings.get(id)));
    }

    @Override
    public File baseDirectory() {
        return this.p.getCanonicalGameDirFile();
    }

    @Override
    public IMinecraftProvider version() {
        return this.provider;
    }

    @Override
    public IMinecraftModService mod() {
        return this.mms;
    }

    @Override
    public IMinecraftDownloadService download() {
        return this.mds;
    }

    @Override
    public IMinecraftAssetService asset() {
        return this.mas;
    }

    @Override
    public IMinecraftInstallerService install() {
        return this.mis;
    }

    @Override
    public IMinecraftLoader launch(LaunchOptions options, UserProfileProvider p) throws GameException {
        MinecraftLoader l = new MinecraftLoader(options, this, p);
        l.setAssetProvider(this.mas.ASSET_PROVIDER_IMPL);
        return l;
    }

    public Profile getProfile() {
        return this.p;
    }

    private /* synthetic */ boolean lambda$loadVersionSetting$55(Object sender, String t) {
        this.saveVersionSetting(((VersionSetting)sender).id);
        return true;
    }

    private /* synthetic */ void lambda$checkModpack$54(File modpack) {
        if (TaskWindow.execute(ModpackManager.install(MainFrame.INSTANCE, modpack, this, null))) {
            this.version().refreshVersions();
        }
        this.checkedModpack = true;
    }

    static /* synthetic */ void access$lambda$0(HMCLMinecraftService hMCLMinecraftService) {
        hMCLMinecraftService.checkModpack();
    }

    static /* synthetic */ void access$lambda$1(HMCLMinecraftService hMCLMinecraftService, String string) {
        hMCLMinecraftService.loadVersionSetting(string);
    }

    static /* synthetic */ void access$lambda$2(HMCLMinecraftService hMCLMinecraftService, File file) {
        hMCLMinecraftService.lambda$checkModpack$54(file);
    }

    static /* synthetic */ boolean access$lambda$3(HMCLMinecraftService hMCLMinecraftService, Object object, String string) {
        return hMCLMinecraftService.lambda$loadVersionSetting$55(object, string);
    }
}

